<?php
/**
 * Plugin Name: WP Courseware
 * Plugin URI:  https://flyplugins.com/wp-courseware
 * Description: WordPress's leading Learning Management System (L.M.S.) plugin Create and sell an online course in minutes.
 * Version:     4.11.3
 * Author:      Fly Plugins
 * Author URI:  https://flyplugins.com
 * License:     GPL3
 * License URI: https://www.gnu.org/licenses/gpl-3.0.html
 * Text Domain: wp-courseware
 * Domain Path: /languages
 *
 * Copyright (c) 2024 Fly Plugins - B & D Endeavors, LLC (email : hello@flyplugins.com)
 *
 * @package WPCW
 * @version 4.11.3
 */

// Exit if accessed directly
defined( 'ABSPATH' ) || exit;

// Plugin Version
define( 'WPCW_VERSION', '4.11.3' );

// Plugin File
define( 'WPCW_FILE', __FILE__ );

// Plugin Base name
define( 'WPCW_BASE_NAME', plugin_basename( dirname( __FILE__ ) ) );

// Plugin Path
defined( 'WPCW_PATH' ) || define( 'WPCW_PATH', plugin_dir_path( WPCW_FILE ) );

// Plugin Url
defined( 'WPCW_URL' ) || define( 'WPCW_URL', plugin_dir_url( WPCW_FILE ) );

// Translation site base URL
if ( ! defined( 'WPCW_TRANSLATIONS_BASE_URL' ) ) {
	define( 'WPCW_TRANSLATIONS_BASE_URL', 'https://languages.wpcourseware.com/projects' );
}

// Upload Directory Path
if ( ! defined( 'WPCW_UPLOAD_DIR_BASE' ) ) {
	define( 'WPCW_UPLOAD_DIR_BASE', trailingslashit( '/wpcourseware_uploads' ) );
}

// TCPDF font folder file path.
$tcpdf_font_path = WP_CONTENT_DIR . WPCW_UPLOAD_DIR_BASE . 'tcpdf-fonts/';
if ( ! file_exists( $tcpdf_font_path ) ) {
	@mkdir( $tcpdf_font_path, 0777, true );
	$font_array = array( 'architectsdaughter.ctg.z', 'architectsdaughter.php', 'architectsdaughter.z', 'helvetica.ctg.z', 'helvetica.php', 'helvetica.z', 'helveticab.ctg.z', 'helveticab.php', 'helveticab.z', 'helveticabi.ctg.z', 'helveticabi.php', 'helveticabi.z', 'helveticai.ctg.z', 'helveticai.php', 'helveticai.z', 'dejavusans.php', 'dejavusans.z', 'dejavusans.ctg.z', 'dejavusansb.ctg.z', 'dejavusansb.php', 'dejavusansb.z' );
	foreach ( $font_array as $font ) {
		$current_file_path = WPCW_PATH . 'includes/library/tcpdf/fonts/' . $font;
		//$new_file_path     = WP_CONTENT_DIR . '/wpcourseware_uploads/tcpdf-fonts/' . $font;
		$new_file_path     = WP_CONTENT_DIR . WPCW_UPLOAD_DIR_BASE . 'tcpdf-fonts/' . $font;
		$fileMoved         = copy( $current_file_path, $new_file_path );
	}
}
define( 'WPCW_PDF_FONTS', 'https://d1fjy2dpdueiqj.cloudfront.net/pdf/' );
define( 'WPCW_WEB_FONTS', 'https://d1fjy2dpdueiqj.cloudfront.net/webkit/' );
define( 'K_PATH_FONTS', WP_CONTENT_DIR . WPCW_UPLOAD_DIR_BASE . 'tcpdf-fonts/' );

// Requirements to run plugin
require_once WPCW_PATH . 'includes/common/requirements.php';

// Requirements check
if ( WPCW_Requirements::check() ) {
	require_once WPCW_PATH . 'includes/plugin.php';

	/**
	 * Main WP Courseware Function.
	 *
	 * The main function responsible for returning
	 * the singleton instance of \WPCW\Plugin.
	 *
	 * Example: <?php $wpcw = wpcw(); ?>
	 *
	 * @since 4.3.0
	 *
	 * @return WPCW_Plugin The WP Courseware plugin singleton instance.
	 */
	function wpcw() {
		return WPCW_Plugin::instance();
	}

	/**
	 * Start WP Courseware.
	 *
	 * Instead of hooking into the 'plugins_loaded' action
	 * we load the singleton instance immediately to load
	 * the necesary objects into memory and fire hooks
	 * at the appropriate time.
	 *
	 * @since 4.3.0
	 */
	wpcw();
}
