<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Ays_Pb
 * @subpackage Ays_Pb/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Ays_Pb
 * @subpackage Ays_Pb/public
 * @author     AYS Pro LLC <info@ays-pro.com>
 */
class Ays_Pb_Public {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

    private $settings;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;

        $this->settings = new Ays_PopupBox_Settings_Actions($this->plugin_name);
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ays_Pb_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ays_Pb_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        // wp_enqueue_style( $this->plugin_name . '-font-awesome',  plugin_dir_url( __FILE__ ) . 'css/ays-pb-font-awesome.min.css', array(), $this->version, 'all' );
		wp_enqueue_style( $this->plugin_name . '-animate', plugin_dir_url( __FILE__ ) . 'css/animate.css', array(), $this->version, 'all' );

	}

    /**
     * Register style sheets for the public side of the site footer.
     *
     * @since    1.0.0
     */
    public function enqueue_styles_footer(){
        wp_enqueue_style( $this->plugin_name . '-min', plugin_dir_url( __FILE__ ) . 'css/ays-pb-public-min.css', array(), $this->version, 'all' );
    }

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {

		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Ays_Pb_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Ays_Pb_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
        wp_enqueue_script( $this->plugin_name . '-functions', plugin_dir_url(__FILE__) . 'js/functions.js', array( 'jquery' ), $this->version, false);

		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/ays-pb-public.js', array( 'jquery' ), $this->version, false );
        wp_localize_script($this->plugin_name, 'pb_public', array(
            'ajax'              => admin_url('admin-ajax.php'),

            'ays_pb_confirm'               => __( 'Are you sure you want to subscribe?', $this->plugin_name),
            'subscription_success_message' => __('Subscription is accomplished! Thank you for subscribing', $this->plugin_name),
            'ays_pb_admin_url'             => AYS_PB_ADMIN_URL,
        ));
	}
	

	public function ays_generate_shortcode(){
        add_shortcode( 'ays_pb', array($this, 'ays_generate_popup') );
    }
	
	public function ays_set_cookie($attr){
        $cookie_time = (isset($attr['cookie']) && $attr['cookie'] != 0) ? absint(intval($attr['cookie'])) : -1;
        $cookie_name = 'ays_popup_cookie_'.$attr['id'];
        $cookie_value = $attr['title'];
        $cookie_expiration =  time() + ($cookie_time * 60);
        setcookie($cookie_name, $cookie_value, $cookie_expiration, '/');
    }

    public function ays_remove_cookie($attr){
        $cookie_name = 'ays_popup_cookie_'.$attr['id'];
        if(isset($_COOKIE[$cookie_name])){
            unset($_COOKIE[$cookie_name]);
            $cookie_expiration =  time() - 1;   
            setcookie($cookie_name, '', $cookie_expiration, '/');
        }
    }

    public function ays_pb_set_cookie_only_once($attr){

        if(isset($_REQUEST['id']) && $_REQUEST['id'] != ''){
             $id = $_REQUEST['id'];
         }else{
            $id = $attr['id'];
         }

        if(isset($_REQUEST['title']) && $_REQUEST['title'] != ''){
              $title = $_REQUEST['title'];
        }else{
            $title =  $attr['title'];
        }
        
        $cookie_name = 'ays_show_popup_only_once_'.$id;
        $cookie_value =  $title;

        $cookie_expiration = time() + (10 * 365 * 24 * 60 * 60);
        setcookie($cookie_name, $cookie_value, $cookie_expiration, '/');
    }

    public function ays_pb_remove_cookie_only_once($attr){
        $cookie_name = 'ays_show_popup_only_once_'.$attr['id'];
        if(isset($_COOKIE[$cookie_name])){
            unset($_COOKIE[$cookie_name]);
            $cookie_expiration =  time() - 1;   
            setcookie($cookie_name, null, $cookie_expiration, '/');
        }
    }

	public function ays_generate_popup( $attr ){
        global $wpdb;
        $id = ( isset($attr['id']) ) ? absint( intval( $attr['id'] ) ) : null;

        if (is_null($id)) {
            return false;
        }

		$popupbox = Ays_Pb_Data::get_pb_by_id( $id );

        $user_data = wp_get_current_user();

        // //Show popup only for author
        // $popupbox['show_only_for_author'] = ( isset( $popupbox['show_only_for_author'] ) && $popupbox['show_only_for_author'] != "") ? stripslashes( esc_attr($popupbox['show_only_for_author']) ) : 'off';
        // $show_only_for_author = ( isset( $popupbox['show_only_for_author']) && $popupbox['show_only_for_author'] == "on") ? true : false;

        // $popup_author = ( isset( $options['create_author'] ) && $options['create_author'] != '' ) ? absint( $options['create_author'] ) : '';
        // $super_admin = get_super_admins();

        // if($show_only_for_author){
        //     if($popup_author == ''){
        //         if( ! in_array($user_data->user_login, $super_admin ) ){
        //             $popupbox['onoffswitch'] = 'Off';
        //         }
        //     }else if($user_data->ID != $popup_author){
        //         $popupbox['onoffswitch'] = 'Off';
        //     }
        // }

        $sub_options = array();
        $subscribes_table = esc_sql($wpdb->prefix."ays_pb_subscribes");

        //Subscribe
        $subscribe_email     = (isset($_POST['popup_attributes']['ays_pb_form_email']) && $_POST['popup_attributes']['ays_pb_form_email'] != '') ? $_POST['popup_attributes']['ays_pb_form_email'] : '' ;
        $subscribe_user_name = (isset($_POST['popup_attributes']['ays_pb_form_name']) && $_POST['popup_attributes']['ays_pb_form_name'] != '') ? $_POST['popup_attributes']['ays_pb_form_name'] : '';

        // PopUp box options
        $pop_options = array();
        if( isset( $popupbox['options'] ) && $popupbox['options'] != '' ){
            $pop_options = json_decode( $popupbox['options'], true );
        }

        //Show popup only for author
        $popupbox['show_only_for_author'] = ( isset( $popupbox['show_only_for_author'] ) && $popupbox['show_only_for_author'] != "") ? stripslashes( esc_attr($popupbox['show_only_for_author']) ) : 'off';
        $show_only_for_author = ( isset( $popupbox['show_only_for_author']) && $popupbox['show_only_for_author'] == "on") ? true : false;

        $popup_author = ( isset( $pop_options['create_author'] ) && $pop_options['create_author'] != '' ) ? absint( $pop_options['create_author'] ) : '';
        $super_admin = get_super_admins();

        if($show_only_for_author){
            if($popup_author == ''){
                if( ! in_array($user_data->user_login, $super_admin ) ){
                    $popupbox['onoffswitch'] = 'Off';
                }
            }else if($user_data->ID != $popup_author){
                $popupbox['onoffswitch'] = 'Off';
            }
        }

        $enable_redirect_after_submission = (isset($pop_options['enable_redirect_after_subscription']) && $pop_options['enable_redirect_after_subscription'] == true) ? true : false;

        $redirect_after_submission_url = (isset($pop_options['enable_redirect_after_subscription_url']) && $pop_options['enable_redirect_after_subscription_url'] != '') ? esc_url($pop_options['enable_redirect_after_subscription_url']) : '';

        //Subscription content
        $ays_pb_subscription_content = '';
        if(!empty($pop_options['ays_popup_send_file_type'])){
            $ays_pb_subscription_content = (isset($pop_options['ays_popup_send_file_type']['ays_pb_send_file_content']) && $pop_options['ays_popup_send_file_type']['ays_pb_send_file_content'] != '') ? stripslashes( esc_attr( $pop_options['ays_popup_send_file_type']['ays_pb_send_file_content'] ) ) : '';
        }
        //Contact Form
        $ays_pb_contact_form_user_name  = (isset($_POST['popup_attributes']['ays_pb_form_name']) && $_POST['popup_attributes']['ays_pb_form_name'] != '') ? $_POST['popup_attributes']['ays_pb_form_name'] : '';
        $ays_pb_contact_form_user_email = (isset($_POST['popup_attributes']['ays_pb_form_email']) && $_POST['popup_attributes']['ays_pb_form_email'] != '') ? $_POST['popup_attributes']['ays_pb_form_email'] : '';
        $ays_pb_contact_form_message    = (isset($_POST['popup_attributes']['ays_pb_form_message']) && $_POST['popup_attributes']['ays_pb_form_message'] != '') ? $_POST['popup_attributes']['ays_pb_form_message'] : '' ;

        //send file after subscription
        $ays_pb_send_file_type_email    = (isset($_POST['popup_attributes']['ays_pb_form_email']) && $_POST['popup_attributes']['ays_pb_form_email'] != '') ? $_POST['popup_attributes']['ays_pb_form_email'] : '';

        switch ($popupbox['modal_content']) {
            case 'contact_form':
                $user_email = $ays_pb_contact_form_user_email;
                $user_name  = $ays_pb_contact_form_user_name;
                break;
            case 'subscription':
                $user_email = $subscribe_email;
                $user_name  = $subscribe_user_name;
                break;
            case 'send_file':
                $user_email = $ays_pb_send_file_type_email;
                $user_name  = '';
                break;
            default:
                $user_email = '';
                $user_name  = '';
                break;
        }

        $send_data = array(
            'user_email'  => $user_email,
            'user_name'   => $user_name,
        );

        if( ( isset( $_POST['ays_pb_sub_button_'.$id] ) && $_POST['ays_pb_sub_button_'.$id] != null ) || ( isset( $_POST['ays_pb_contact_form_button_'.$id] ) && $_POST['ays_pb_contact_form_button_'.$id] != null ) || ( isset($_POST['ays_pb_send_file_type_btn_'.$id] ) && $_POST['ays_pb_send_file_type_btn_'.$id] != null ) ){
            $integrations_args = apply_filters( 'ays_pb_front_end_integrations_options', array(),json_decode($popupbox['options'], true) );
            do_action( 'ays_pb_front_end_integrations', $integrations_args, json_decode($popupbox['options'], true), $send_data );
        }

        if(isset($_POST['ays_pb_sub_button_'.$id])){
            if (!isset($_COOKIE['ays_popupbox_cookie_name_'.$id])) {
                $popup_attributes = isset($_POST['popup_attributes']) && !empty($_POST['popup_attributes']) ? $_POST['popup_attributes'] : array();
                foreach($popup_attributes as $attr_key => &$attr_value){
                    $attr_value = sanitize_text_field($attr_value);
                }
                $sub_options['popup_attributes'] = $popup_attributes;

                $wpdb->insert(
                    $subscribes_table,
                    array(
                        'pb_id'             => $id,
                        'user_id'           => get_current_user_id(),
                        'user_ip'           => $this->get_user_ip(),
                        'subscribe_email'   => $subscribe_email,
                        'user_name'         => $subscribe_user_name,
                        'date'              => current_time( 'mysql' ),
                        'options'           => json_encode($sub_options),
                        'read'              => 0,
                    ),
                    array('%d','%s','%s', '%s', '%s', '%s','%s','%d')
                );

                if($ays_pb_subscription_content != ''){
                    $to = $subscribe_email;
                    $subject = "Popup Box";
                    $message = $ays_pb_subscription_content;

                    $headers  = 'From: '.$subscribe_user_name.'  <'.$subscribe_email.'>'."\r\n";
                    $headers .= "MIME-Version: 1.0\r\n";
                    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";   
                    $headers .= 'Reply-To:' .'<'.$subscribe_email.'>'."\r\n";  

                    wp_mail($to , $subject, $message , $headers);

                }


                $cookie_name = 'ays_popupbox_cookie_name_'.$id;
                $cookie_value = 'ays_popupbox_cookie_value'.$id;
                $cookie_expiration = time() + (30 * 24 * 60 * 60);
                setcookie($cookie_name, $cookie_value, $cookie_expiration, '/');

                if(isset($_POST['ays_pb_redirect_after_subscription_url']) && $_POST['ays_pb_redirect_after_subscription_url'] != '') {
                    if(wp_http_validate_url($_POST['ays_pb_redirect_after_subscription_url'])) {
                        wp_redirect($_POST['ays_pb_redirect_after_subscription_url']);
                    }
                }

                return false;
            }
        }

        if( isset($_COOKIE['ays_popupbox_cookie_name_'.$id]) ){
           return false;
        }

        /*******************************************************************************************************/

        $settings_options = $this->settings->ays_get_setting('options');
        if($settings_options){
            $settings_options = json_decode($settings_options, true);
        }else{
            $settings_options = array();
        }

        /*******************************************************************************************************/
        
        $popupbox = Ays_Pb_Data::get_validated_data_from_array( $popupbox, $attr );

        //limit user by country
        $enable_pb_limit_user_by_country = (isset($popupbox['enable_limit_by_country']) && $popupbox['enable_limit_by_country'] == 'on') ? true : false;
        
        $blocked_pb_user_country = (isset($popupbox['limit_country']) && $popupbox['limit_country'] != '') ? $popupbox['limit_country'] : array();

        $countries_choose_type = (isset($popupbox['countries_choose_type']) && $popupbox['countries_choose_type'] != '') ? $popupbox['countries_choose_type'] : 'exclude';

        //Login Form
        if (is_user_logged_in() && $popupbox["modal_content"] == 'login_form') {
            return false;
        }

        // $user_data = wp_get_current_user();

        $user_display_name = ( isset( $user_data->display_name ) && $user_data->display_name != '' ) ? stripslashes( $user_data->display_name ) : '';

        $user_email = ( isset( $user_data->user_email ) && $user_data->user_email != '' ) ? stripslashes( $user_data->user_email ) : '';

        $pb_user_information = Ays_Pb_Data::get_user_profile_data();
        $user_first_name = (isset( $pb_user_information['user_first_name'] ) && $pb_user_information['user_first_name']  != "") ? $pb_user_information['user_first_name'] : ''; 
        $user_last_name = (isset( $pb_user_information['user_last_name'] ) && $pb_user_information['user_last_name']  != "") ? $pb_user_information['user_last_name'] : '';
        $user_wordpress_roles = (isset( $pb_user_information['user_wordpress_roles'] ) && $pb_user_information['user_wordpress_roles']  != "") ? $pb_user_information['user_wordpress_roles'] : '';
        $user_nickname = (isset( $pb_user_information['user_nickname'] ) && $pb_user_information['user_nickname']  != "") ? $pb_user_information['user_nickname'] : '';

        if(isset($popupbox['author']) && $popupbox['author'] != 'null'){
            if ( ! is_array( $popupbox['author'] ) ) {
                $popupbox['author'] = json_decode($popupbox['author'], true);
                $author = $popupbox['author'];
            } else {
                $author = array_map( 'stripslashes', $popupbox['author'] ); 
            }
        } else {
            $author = array('name' => 'Unknown');
        }

        $current_popup_author = ( isset( $author['name'] ) && $author['name'] != "" ) ? $author['name'] : '';
        
        if($popupbox['button_text'] == ''){
            switch ($popupbox["modal_content"]) {
                case 'send_file':
                case 'subscription':
                    $popupbox['button_text'] = __('Subscribe',$this->plugin_name);
                    break;
                case 'contact_form':
                    $popupbox['button_text'] = __('Send to admin',$this->plugin_name);
                    break;
                default:
                    $popupbox['button_text'] = '';
                    break;
            }
        }

        /*
        ==========================================
            Buttons styles
        ==========================================
        */

        // Buttons font size
        $buttons_font_size = $popupbox['buttons_font_size'] . 'px';

        // Buttons font size
        $buttons_width = '';
        if(isset($popupbox['buttons_width']) && $popupbox['buttons_width'] != ''){
            $buttons_width = $popupbox['buttons_width'].'px';
        }else{
            $buttons_width = '100%';
        }

        // Buttons Left / Right padding
        $buttons_left_right_padding = $popupbox['buttons_left_right_padding'] . 'px';

        // Buttons Top / Bottom padding
        $buttons_top_bottom_padding = $popupbox['buttons_top_bottom_padding'] . 'px';

        // Buttons border radius
        $buttons_border_radius = $popupbox['buttons_border_radius'] . 'px';
        
        $button_layout = (isset($popupbox['button_layout']) && $popupbox['button_layout'] != '') ? $popupbox['button_layout'] : 'row';

        $col_direction = ( $button_layout == 'column' ) ? 'flex-direction: column;' : '';
        $col_direction_margin = ( $button_layout == 'column' ) ? 'margin: 10px 0px !important;' : '';

        //Limit Coupon
        if( $popupbox["modal_content"] == 'coupon_type' && $popupbox['onoffswitch'] !== false){
            if( ! empty( $popupbox['pb_coupons_array'] ) ){
                $popupbox['onoffswitch'] = false;
                
                $pb_active_coupons = ( isset( $popupbox['pb_coupons_array']['pb_active_coupons'] ) && !empty( $popupbox['pb_coupons_array']['pb_active_coupons'] ) ) ? $popupbox['pb_coupons_array']['pb_active_coupons'] : array();
                
                if( empty( $pb_active_coupons ) ){
                    $popupbox['onoffswitch'] = false;
                }else{
                    $popupbox['onoffswitch'] = true;
                }
                
            }else{
                $popupbox['onoffswitch'] = true;
            }

            //Don't open after one time
            // $get_pb_count_by_id = Ays_Pb_Data::get_pb_count_by_id($id);

            // if($get_pb_count_by_id >= 1){
            //     $popupbox['onoffswitch'] = false;
            // }else{
            //     $popupbox['onoffswitch'] = true;
            // }
        }

        //Limit Cookie
        if( $popupbox["modal_content"] == 'cookie' && $popupbox['onoffswitch'] !== false){
            if(isset($_COOKIE['ays_pb_accept_cookie_'.$id])){
                $popupbox['onoffswitch'] = false;
            }
        }

        if(isset($_COOKIE['ays_pb_dismiss_ad_'.$id])){
            $popupbox['onoffswitch'] = false;
        }

        if(isset($options['enable_dismiss']) && $options['enable_dismiss'] == 'off'){
            if(isset($_COOKIE['ays_pb_dismiss_ad_'.$id])){
                unset($_COOKIE['ays_pb_dismiss_ad_'.$id]);
                $cookie_expiration =  time() - 1;   
                setcookie('ays_pb_dismiss_ad_'.$id, null, $cookie_expiration, '/');
            }
        } 

        $message_data = array(
            'user_name'              => $user_display_name,
            'user_email'             => $user_email,
            'user_first_name'        => $user_first_name,
            'user_last_name'         => $user_last_name,
            'current_popup_author'   => $current_popup_author,
            'user_wordpress_roles'   => $user_wordpress_roles,
            'popup_title'            => $popupbox['title'],
            'creation_date'          => $popupbox['create_date'],
            'user_nickname'          => $user_nickname,
        );
        
        if($enable_pb_limit_user_by_country && $popupbox['onoffswitch']){
            $user_ip = $this->get_user_ip();
            $json    = json_decode(file_get_contents("http://ipinfo.io/{$user_ip}/json"));
            $country = (isset($json->country) && $json->country != '') ? $json->country : "";

            if($countries_choose_type == 'include'){
                if(in_array($country, $blocked_pb_user_country)){
                    $popupbox['onoffswitch'] = true;
                }else{
                    $popupbox['onoffswitch'] = false;
                }
            }
            
            if ($countries_choose_type == 'exclude') {
                if(in_array($country, $blocked_pb_user_country)){
                    $popupbox['onoffswitch'] = false;
                }else{
                    $popupbox['onoffswitch'] = true;
                }
            }
        }
        $blured_overlay = '';
        if($popupbox['blured_overlay'] && $popupbox['onoffoverlay'] == 'on'){
            $blured_overlay = '-webkit-backdrop-filter: blur(5px);
            backdrop-filter: blur(20px);
            opacity:unset !important;';
            $popupbox['overlay_color'] = Ays_Pb_Data::hex2rgba( $popupbox['overlay_color'], 0.5 );
        }

        //Overlay Opacity
        $overlay_opacity = ($popupbox['onoffoverlay'] == 'on' && isset($popupbox['overlay_opacity'])) ? $popupbox['overlay_opacity'] : 0.5;
        $enable_overlay_text_mobile = isset($pop_options['enable_overlay_text_mobile']) && $pop_options['enable_overlay_text_mobile'] == 'on' ? 'true' : 'false';
        $overlay_mobile_opacity = ($popupbox['onoffoverlay'] == 'on' && isset($pop_options['overlay_mobile_opacity'])) ? esc_attr($pop_options['overlay_mobile_opacity']) : $overlay_opacity;

        //Close button Delay
        $close_button_delay   = (isset($pop_options["close_button_delay"]) && $pop_options["close_button_delay"] != '') ? absint( intval($pop_options["close_button_delay"]) ) : 0;
        $close_button_delay_for_mobile = (isset($pop_options["close_button_delay_for_mobile"]) && $pop_options["close_button_delay_for_mobile"] != '') ? absint( intval($pop_options["close_button_delay_for_mobile"]) ) : 0;
        $enable_close_button_delay_for_mobile = isset($pop_options['enable_close_button_delay_for_mobile']) && $pop_options['enable_close_button_delay_for_mobile'] == 'on' ? 1 : 0;

        if( $popupbox['onoffswitch'] ){
			
            if( !isset($_COOKIE['ays_popup_cookie_'.$id]) && isset($popupbox['cookie']) && $popupbox['cookie'] != 0 ){
                $this->ays_set_cookie( $popupbox );
            }elseif( isset($popupbox['cookie']) && $popupbox['cookie'] == 0 ){
                $this->ays_remove_cookie( $popupbox );
            }else{
                return;
            }

            $data_for_use = array();

            $modal_class  = 'ays-pb-modal';

            $show_only_once =  $popupbox['show_only_once'];

            if(!isset($_COOKIE['ays_show_popup_only_once_'.$id]) && $popupbox['show_only_once'] && $popupbox['action_button_type'] != 'clickSelector'){
                $this->ays_pb_set_cookie_only_once($popupbox);
            }elseif($popupbox['show_only_once'] === false){
                $this->ays_pb_remove_cookie_only_once($popupbox);
            }elseif($popupbox['show_only_once'] === null){

            }
            elseif(isset($_COOKIE['ays_show_popup_only_once_'.$id]) && $popupbox['show_only_once']){
                return;
            }else{

            }

            $popup_textcolor = isset($popupbox['textcolor']) && $popupbox['textcolor'] != '' ? sanitize_text_field($popupbox['textcolor']) : "#000";
            $ays_pb_font_family = (isset($pop_options['pb_font_family']) && $pop_options['pb_font_family'] != '') ? $pop_options['pb_font_family'] : '';
            
            // Titile text shadow
            $enable_pb_title_text_shadow = (isset($pop_options['enable_pb_title_text_shadow']) && $pop_options['enable_pb_title_text_shadow'] == 'on') ? true : false; 
            $pb_title_text_shadow = (isset($pop_options['pb_title_text_shadow']) && $pop_options['pb_title_text_shadow'] != '') ? stripslashes( esc_attr( $pop_options['pb_title_text_shadow'] ) ) : 'rgba(255,255,255,0)';

            $pb_title_text_shadow_x_offset = (isset($pop_options['pb_title_text_shadow_x_offset']) && $pop_options['pb_title_text_shadow_x_offset'] != '') ? stripslashes( esc_attr( $pop_options['pb_title_text_shadow_x_offset'] ) ) : 2;

            $pb_title_text_shadow_y_offset = (isset($pop_options['pb_title_text_shadow_y_offset']) && $pop_options['pb_title_text_shadow_y_offset'] != '') ? stripslashes( esc_attr( $pop_options['pb_title_text_shadow_y_offset'] ) ) : 2;

            $pb_title_text_shadow_z_offset = (isset($pop_options['pb_title_text_shadow_z_offset']) && $pop_options['pb_title_text_shadow_z_offset'] != '') ? stripslashes( esc_attr( $pop_options['pb_title_text_shadow_z_offset'] ) ) : 0;
            if( $enable_pb_title_text_shadow ){
                $title_text_shadow = 'text-shadow: '.$pb_title_text_shadow_x_offset.'px '.$pb_title_text_shadow_y_offset.'px '.$pb_title_text_shadow_z_offset.'px '.$pb_title_text_shadow;
            }else{
                $title_text_shadow = "";
            }

            if( $popupbox['title'] != '' && $popupbox['show_popup_title'] ){
                $ays_pb_title = "<h2 style='color:" . $popup_textcolor . " !important; font-family:" . $ays_pb_font_family . ";".$title_text_shadow."; font-size: 24px; margin: 0;font-weight: normal;' class='ays_pb_title'>" . $popupbox['title'] . "</h2>";
            } else {
                $ays_pb_title = "";
            }
            
            if( $popupbox['description'] != '' && $popupbox['show_popup_desc'] ){
                $content_desktop = Ays_Pb_Data::ays_autoembed( stripslashes( wpautop($popupbox['description'])) );
                $ays_pb_description = "<div class='ays_pb_description'>".$content_desktop."</div>";
            }else{
                $ays_pb_description = ""; 
            }

            $ays_pb_description = Ays_Pb_Data::replace_message_variables( $ays_pb_description, $message_data );

            $ays_pb_flag = '';
            $open = "";
            $ays_pb_animate_in_open = "";
            $js_events = false;
            $show_popup = "";
            if( $popupbox['action_button_type'] == 'clickSelector' || $popupbox['action_button_type'] == 'hover' ){
                $js_events = true;
            }

            if( $popupbox['action_button_type'] == 'both' || $popupbox['action_button_type'] == 'pageLoaded' ){
                if( $popupbox['delay'] == 0 && $popupbox['scroll_top'] == 0){
                    $ays_pb_animate_in_open = $popupbox['animate_in'];
                    $open = "checked";
                } 
                $ays_pb_flag = "data-ays-flag='false'";
            }

            if( $popupbox['action_button_type'] == 'clickSelector' ){
                $ays_pb_animate_in_open = $popupbox['animate_in'];
                $ays_pb_flag = "data-ays-flag='true'";
                $show_popup = "display:none;";
                $open = "";
            }

            if( $js_events ){
                $ays_pb_animate_in_open = $popupbox['animate_in'];
                $ays_pb_flag = "data-ays-flag='true'";
                $open = "";
            }

            if( $popupbox['action_button_type'] == 'exitIntent' ){
                $ays_pb_animate_in_open = $popupbox['animate_in'];
                $ays_pb_flag = "data-ays-flag='true'";
                $open = "";
            }

            if( $popupbox['action_button_type'] == 'inactivity' ){
                $ays_pb_animate_in_open = $popupbox['animate_in'];
                $ays_pb_flag = "data-ays-flag='true'";
                $show_popup = "display:none;";
                $open = "";
            }

            if( $popupbox['action_button_type'] == 'scrollingtoelement' ){
                $ays_pb_animate_in_open = $popupbox['animate_in'];
                $ays_pb_flag = "data-ays-flag='true'";
                $open = "";
            }

            $open_popup = false;
            if( $popupbox['action_button_type'] == 'xpagevisiting' ){
                session_start();

                $ays_pb_animate_in_open = $popupbox['animate_in'];
                $ays_pb_flag = "data-ays-flag='true'";
                $show_popup = "display:none;";
                $open = "";
    
                if(isset($_SESSION['views'])){
                    $_SESSION['views'] = $_SESSION['views']+1;
                }
                else{
                    $_SESSION['views'] = 1;
                }
                    
        
                if( $_SESSION['views'] >= $popupbox['show_popup_x_page_visiting']){
                    $open_popup = true;
                }else{
                    $open_popup = false;
                }
            }

            switch ($popupbox['action_button_type']) {
                case 'clickSelector':
                    $ays_pb_action_button_type = 'click';
                    $ays_pb_action_type = '';
                    break;
                case 'hover':
                    $ays_pb_action_button_type = 'mouseover';
                    break;
                default:
                    $ays_pb_action_button_type = 'click';
                    $ays_pb_action_type = '';
                    break;
            }

            $ays_pb_custom_css = "";
            if( $popupbox['custom_css'] != '' ){
                $ays_pb_custom_css = "<style>". $popupbox['custom_css'] ."</style>";
            }
            $now_time = time();

            // Enable lazy loading attribute for images
            $settings_options['popup_enable_lazy_loading'] = isset($settings_options['popup_enable_lazy_loading']) ? esc_attr( $settings_options['popup_enable_lazy_loading'] ) : 'on';
            $popup_enable_lazy_loading = (isset($settings_options['popup_enable_lazy_loading']) && esc_attr( $settings_options['popup_enable_lazy_loading'] ) == "on") ? true : false;
            $popupbox['lazy_loading_attr'] = $popup_enable_lazy_loading ? 'loading="lazy"' : '';

            // Enable lazy loading attribute for images
            // $settings_options['popup_enable_lazy_loading'] = isset($settings_options['popup_enable_lazy_loading']) ? esc_attr( $settings_options['popup_enable_lazy_loading'] ) : 'on';
            // $popup_enable_lazy_loading = (isset($settings_options['popup_enable_lazy_loading']) && esc_attr( $settings_options['popup_enable_lazy_loading'] ) == "on") ? true : false;
            // $popupbox['lazy_loading_attr'] = $popup_enable_lazy_loading ? 'loading="lazy"' : '';

            // if(isset($popupbox['close_button_image']) && $popupbox['close_button_image'] != ''){
            //     $ays_pb_close_button_text = "<img class='close_btn_img ays-pb-close-btn-color' src='".$popupbox['close_button_image']."' width='25' height='25'>";
            // }else{
            //     if( $popupbox['close_button_text'] === 'x' ){
            //         $ays_pb_close_button_text = "<img src='". AYS_PB_ADMIN_URL ."/images/icons/times-2x.svg' class='fa fa-times fa-2x lil_close_btn_x_font ays-pb-close-btn-color'>";
            //     }else{
            //         $ays_pb_close_button_text = $popupbox['close_button_text'];
            //     }

            // }
            // $popupbox['ays_pb_close_button_text'] = $ays_pb_close_button_text;

            // Subscription 
            //____________________________________

               $ays_pb_subs_email_placeholder = (isset($popupbox['ays_pb_subs_email_placeholder']) && $popupbox['ays_pb_subs_email_placeholder'] != '') ? $popupbox['ays_pb_subs_email_placeholder'] : 'Email*';

               $enable_ays_pb_subs_name_field = (isset($popupbox['enable_ays_pb_subs_name_field']) && $popupbox['enable_ays_pb_subs_name_field'] == true) ? true : false;
               
               $ays_pb_subs_name_placeholder = (isset($popupbox['ays_pb_subs_name_placeholder']) && $popupbox['ays_pb_subs_name_placeholder'] != '') ? $popupbox['ays_pb_subs_name_placeholder'] : 'Name';

               $ays_pb_subs_name_required = (isset($popupbox['ays_pb_subs_name_required']) && $popupbox['ays_pb_subs_name_required'] == true) ? true : false;


            //____________________________________

            // Yes or No type 
            //____________________________________

            $ays_pb_yes_or_no_question = (isset($popupbox['ays_pb_yes_or_no_question']) && $popupbox['ays_pb_yes_or_no_question'] != '') ? stripslashes( sanitize_text_field( $popupbox['ays_pb_yes_or_no_question'] ) ) : __('Do you like our plugin?',$this->plugin_name);

            $ays_pb_yes_button_action = (isset($popupbox['ays_pb_yes_button_action']) && $popupbox['ays_pb_yes_button_action'] != '') ? $popupbox['ays_pb_yes_button_action'] : 'closePopup';

            $ays_pb_no_button_action = (isset($popupbox['ays_pb_no_button_action']) && $popupbox['ays_pb_no_button_action'] != '') ? $popupbox['ays_pb_no_button_action'] : 'closePopup';

            $ays_pb_yes_btn_redirect_url = (isset($popupbox['ays_pb_yes_btn_redirect_url']) && $popupbox['ays_pb_yes_btn_redirect_url'] != '') ? esc_url($popupbox['ays_pb_yes_btn_redirect_url']) : '';

            $ays_pb_no_btn_redirect_url = (isset($popupbox['ays_pb_no_btn_redirect_url']) && $popupbox['ays_pb_no_btn_redirect_url'] != '') ? esc_url($popupbox['ays_pb_no_btn_redirect_url']) : '';

            $yes_redirect_another_tab = (isset($popupbox['yes_redirect_another_tab']) && $popupbox['yes_redirect_another_tab'] == 'on') ? true : false;

            $no_redirect_another_tab = (isset($popupbox['no_redirect_another_tab']) && $popupbox['no_redirect_another_tab'] == 'on') ? true : false;
            //____________________________________

            // Iframe 
            //____________________________________

            $ays_pb_iframe_link = (isset($popupbox['ays_pb_iframe_link']) && $popupbox['ays_pb_iframe_link'] != '') ? $popupbox['ays_pb_iframe_link'] : '';

            //____________________________________

            // Contact Form
            //____________________________________

            $ays_pb_contact_admin_email = (isset($popupbox['ays_pb_contact_admin_email']) && $popupbox['ays_pb_contact_admin_email'] != '') ? $popupbox['ays_pb_contact_admin_email'] : '';

            //____________________________________

            // Send file
            //____________________________________

            $ays_pb_send_file_url = (isset($popupbox['ays_pb_send_file_url']) && $popupbox['ays_pb_send_file_url'] != '') ? $popupbox['ays_pb_send_file_url'] : '';

            $ays_pb_send_file_id = (isset($popupbox['ays_pb_send_file_id']) && $popupbox['ays_pb_send_file_id'] != '') ? $popupbox['ays_pb_send_file_id'] : '';

            $ays_pb_send_file_name = (isset($popupbox['ays_pb_send_file_name']) && $popupbox['ays_pb_send_file_name'] != '') ? $popupbox['ays_pb_send_file_name'] : __("No uploaded file", $this->plugin_name);

            $ays_pb_send_file_content = (isset($popupbox['ays_pb_send_file_content']) && $popupbox['ays_pb_send_file_content'] != '') ?  stripslashes( esc_attr( $popupbox['ays_pb_send_file_content'] ) ): '';

            $ays_pb_send_file_content = Ays_Pb_Data::replace_message_variables( $ays_pb_send_file_content, $message_data );

            //____________________________________

            // WooCommerce Product
            //____________________________________

            $woo_prod_id = (isset($popupbox['woo_prod_sel']) && $popupbox['woo_prod_sel'] != "") ? $popupbox['woo_prod_sel'] : "";
            $woo_product = array();
            $woo = in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')));
            $product = array();
            if($woo_prod_id == ""){
                $woo_prod_id = null;
            }
            if ($woo && isset($woo_prod_id)) {
                $wpf = new WC_Product_Factory();
                $cart_text = __('Add to cart', 'woocommerce');
                $get_product_name_data = $wpf->get_product($woo_prod_id) ? $wpf->get_product($woo_prod_id)->get_data() : ''; 
                $get_product_name = '';
                if ( isset( $get_product_name_data ) && is_array( $get_product_name_data ) ) {
                    $get_product_name = (isset($get_product_name_data['name']) && $get_product_name_data['name']) ? $get_product_name_data['name'] : "";
                }
                $popup_woo_image = wp_get_attachment_image_src(get_post_thumbnail_id($woo_prod_id), 'single-post-thumbnail') ? wp_get_attachment_image_src(get_post_thumbnail_id($woo_prod_id), 'single-post-thumbnail')[0] : '';

                $woo_product = array(
                    'prodUrl'  => get_permalink(intval($woo_prod_id)),
                    'name'  => $get_product_name,
                    'image' => $popup_woo_image,
                    'link'  => "<a href=\"?add-to-cart=$woo_prod_id\" data-quantity=\"1\" class=\"action-button product_type_simple add_to_cart_button ajax_add_to_cart\" style='display: block;' data-product_id=\"$woo_prod_id\" data-product_sku=\"\" aria-label=\"$cart_text\" rel=\"nofollow\">$cart_text</a>"
                );
                
            }

            //____________________________________

            // Download file
            //____________________________________

            $ays_pb_down_file_url = (isset($popupbox['ays_pb_down_file_url']) && $popupbox['ays_pb_down_file_url'] != '') ? $popupbox['ays_pb_down_file_url'] : '';
            //____________________________________

            // Google map
            //____________________________________

            $ays_pb_google_map_api_key  = (isset($popupbox['ays_pb_google_map_api_key']) && $popupbox['ays_pb_google_map_api_key'] != "") ? $popupbox['ays_pb_google_map_api_key'] : "";

            $ays_pb_google_map_search  = (isset($popupbox['ays_pb_google_map_search']) && $popupbox['ays_pb_google_map_search'] != "") ? $popupbox['ays_pb_google_map_search'] : "";
            if($ays_pb_google_map_api_key != '' && $ays_pb_google_map_search == ''){
                $user_ip = Ays_Pb_Data::get_user_ip() ;
                $json    = json_decode(file_get_contents("http://ipinfo.io/78.109.69.144/json"));
                $country = isset($json->country) && $json->country != '' ? $json->country : "";
                $ays_pb_google_map_search = $country;
            }
            //____________________________________

            //Coupons start
            //Active/Inactive coupons
            $active_inactive_coupons = (isset($popupbox['pb_coupons_array']) && $popupbox['pb_coupons_array'] != '') ? $popupbox['pb_coupons_array'] : array();

            $active_coupon = '';
            if(!empty($active_inactive_coupons)){
                $pb_active_coupons = (isset( $active_inactive_coupons['pb_active_coupons']) && !empty( $active_inactive_coupons['pb_active_coupons'])) ? $active_inactive_coupons['pb_active_coupons'] : array();

                if(! empty($pb_active_coupons)){
                    foreach ($pb_active_coupons as $key => $pb_active_coupon) {
                        $active_coupon = $pb_active_coupon;
                    }
                }
            }else{
                $pb_active_coupons = array();
            }   
            
            //Coupons end

            //Countdown
            $ays_pb_countdown_date  = (isset($popupbox['ays_pb_countdown_date']) && $popupbox['ays_pb_countdown_date'] != "") ? date_create(esc_attr($popupbox['ays_pb_countdown_date'])) : "";
            $countdown_date_format = "";
            if( $ays_pb_countdown_date ){
                $countdown_date_format = date_format($ays_pb_countdown_date,"M d Y H:i:s");
            }

            //Dismiss by Closing 
            $dismiss_closing =  $popupbox['pb_dismiss_closing'];      

            if(isset($_COOKIE['ays_pb_dismiss_closing_accept_cookie_'.$id]) && !$dismiss_closing ){
                $cookie_name = 'ays_pb_dismiss_closing_accept_cookie_'.$id;

                if(isset($_COOKIE[$cookie_name])){
                    unset($_COOKIE[$cookie_name]);
                    $cookie_expiration =  time() - 1;   
                    setcookie($cookie_name, null, $cookie_expiration, '/');
                }

            }elseif(isset($_COOKIE['ays_pb_dismiss_closing_accept_cookie_'.$id]) && $dismiss_closing){
                return;
            }

            $to = '';
            if(isset($_POST['ays_pb_contact_form_button_'.$id])){
                // === Add this later for new submissions 7.8.5 ===

                $contact_form_file_options = array();
                if($ays_pb_contact_form_user_email != "" && $ays_pb_contact_form_user_name != ""){
                    $popup_attributes = isset($_POST['popup_attributes']) && !empty($_POST['popup_attributes']) ? $_POST['popup_attributes'] : array();
                    foreach($popup_attributes as $attr_key => &$attr_value){
                        $attr_value = sanitize_text_field($attr_value);
                    }
                    $contact_form_file_options['popup_attributes'] = $popup_attributes;

                    $wpdb->insert(
                        $subscribes_table,
                        array(
                            'pb_id'             => $id,
                            'user_id'           => get_current_user_id(),
                            'user_ip'           => $this->get_user_ip(),
                            'subscribe_email'   => $ays_pb_contact_form_user_email,
                            'user_name'         => $ays_pb_contact_form_user_name,
                            'date'              => current_time( 'mysql' ),
                            'options'           => json_encode($contact_form_file_options),
                            'read'              => 0,
                        ),
                        array('%d','%s','%s', '%s', '%s', '%s','%s','%d')
                    );
                }

                if($ays_pb_contact_admin_email != ''){
                    $to = $ays_pb_contact_admin_email;
                    $subject = "Popup Box";
                    $message = $ays_pb_contact_form_message;

                    $message = Ays_Pb_Data::replace_message_variables( $message, $message_data );

                    $headers  = 'From: '.$ays_pb_contact_form_user_name.'  <'.$ays_pb_contact_form_user_email.'>'."\r\n";
                    $headers .= "MIME-Version: 1.0\r\n";
                    $headers .= "Content-Type: text/html; charset=UTF-8\r\n";   
                    $headers .= 'Reply-To:' .'<'.$ays_pb_contact_form_user_email.'>'."\r\n";  

                    wp_mail($to , $subject, $message , $headers);

                }

            }

            // $attachment_path = false;
            // if($ays_pb_send_file_id != ''){
            //     $attachment_path = get_attached_file(intval($ays_pb_send_file_id));
            // }
            // $nsite_url_base = parse_url( get_site_url(), PHP_URL_HOST );
            // $nsite_url = trim( $nsite_url_base, '/' );
            

            // $to = '';
            // $nfrom = '';

            // $message_content = array();

            // if($ays_pb_send_file_content != ''){
            //     $message_content[] = '<p>';
            //         $message_content[] = $ays_pb_send_file_content;
            //         $message_content[] = '<strong>'. $ays_pb_send_file_name . '</strong>';
            //     $message_content[] = '<p/>';
            // }else{
            //     $message_content[] = __("You have received this file ", $this->plugin_name) . '<strong>'. $ays_pb_send_file_name . '</strong>';
            // }
            
            // $message_content = implode( '', $message_content );
            // $user_display_name = '';
            // $sub_send_file_options = array();
            // if(isset($_POST['ays_pb_send_file_type_btn_'.$id])){
            //     if($ays_pb_send_file_type_email != '' ){

            //         $user_id = get_current_user_id();
            //         $current_user_data = get_userdata( $user_id );

            //         if ( ! is_null( $current_user_data ) && $current_user_data ) {
            //             $user_display_name = ( isset( $current_user_data->data->display_name ) && $current_user_data->data->display_name != '' ) ? sanitize_text_field( $current_user_data->data->display_name ) : "";
            //         }

            //         if(isset($_POST['popup_attributes']['ays_pb_form_name']) && $_POST['popup_attributes']['ays_pb_form_name'] != ''){
            //             $user_display_name = sanitize_text_field($_POST['popup_attributes']['ays_pb_form_name']);
            //         }

            //         $popup_attributes = isset($_POST['popup_attributes']) && !empty($_POST['popup_attributes']) ? $_POST['popup_attributes'] : array();
            //         foreach($popup_attributes as $attr_key => &$attr_value){
            //             $attr_value = sanitize_text_field($attr_value);
            //         }
            //         $sub_send_file_options['popup_attributes'] = $popup_attributes;

            //         $wpdb->insert(
            //             $subscribes_table,
            //             array(
            //                 'pb_id'             => $id,
            //                 'user_id'           => get_current_user_id(),
            //                 'user_ip'           => $this->get_user_ip(),
            //                 'subscribe_email'   => $ays_pb_send_file_type_email,
            //                 'user_name'         => $user_display_name,
            //                 'date'              => current_time( 'mysql' ),
            //                 'options'           => json_encode($sub_send_file_options),
            //                 'read'              => 0,
            //             ),
            //             array('%d','%s','%s', '%s', '%s', '%s','%s','%d')
            //         );

            //         $to = $ays_pb_send_file_type_email;
            //         $subject = $popupbox['title'] != '' ? $popupbox['title'] : "Popup Box";

            //         $message = $message_content;
            //         $message = Ays_Pb_Data::replace_message_variables( $message, $message_data );

            //         $nfrom = 'From: <noreply@'.$nsite_url.'>' . "\r\n";
            //         $nreply = 'Reply-To:' .'<noreply@'.$nsite_url.'>'."\r\n";

                    
            //         $headers = $nfrom; 
            //         $headers .= "MIME-Version: 1.0\r\n";
            //         $headers .= "Content-Type: text/html; charset=UTF-8\r\n";   
            //         $headers .= $nreply;  
                

            //         if ($attachment_path) {
            //             $mail_send_file = wp_mail($to , $subject, $message , $headers,$attachment_path) ? true : false;
            //         }
            //     }
            // }

            if( isset($_COOKIE['ays_popupbox_hide_after_subscribe_cookie_name_'.$id]) ){
                if($popupbox['hide_after_subscribe'] == false) {
                    unset($_COOKIE['ays_popupbox_hide_after_subscribe_cookie_name_'.$id]);
                    $cookie_expiration =  time() - 1;   
                    setcookie('ays_popupbox_hide_after_subscribe_cookie_name_'.$id, null, $cookie_expiration, '/');
                }
                return false;
            }

            // Popupbox position
            $ays_pb_position = isset($popupbox['pb_position']) && $popupbox['pb_position'] != '' ? $popupbox['pb_position'] : 'center-center';
            $enable_pb_position_mobile = ( isset($pop_options['enable_pb_position_mobile']) && $pop_options['enable_pb_position_mobile'] == 'on' ) ? true : false;
            $ays_pb_position_mobile = isset($pop_options['pb_position_mobile']) && $pop_options['pb_position_mobile'] != '' ? $pop_options['pb_position_mobile'] : 'center-center';

            $ays_pb_margin = isset($popupbox['pb_margin']) && $popupbox['pb_margin'] != '' ? intval( $popupbox['pb_margin'] ) : 0;

            // enable pb fullscreen
            $enable_pb_fullscreen = (isset($pop_options['enable_pb_fullscreen']) && $pop_options['enable_pb_fullscreen'] == 'on') ? true : false;

            $mobile_height = (isset($pop_options['mobile_height']) && $pop_options['mobile_height'] != "") ? $pop_options['mobile_height'] : $popupbox["height"];
            
            if(isset($pop_options['mobile_height']) && $pop_options['mobile_height'] != ''){
                
                $mobile_height = $pop_options['mobile_height'];
                if( $pop_options['mobile_height'] == 0){
                    $mobile_height = $popupbox["height"];
                }
            }else{
                $mobile_height = $popupbox["height"];
            }

            //Background Gradient
            // Bg image positioning
            $pb_bg_image_position = $popupbox['pb_bg_image_position'];

            $pb_bg_image_sizing = $popupbox['pb_bg_image_sizing'];

            $pb_gradient_direction = '';
            switch( $popupbox['pb_gradient_direction'] ) {
                case "horizontal":
                    $pb_gradient_direction = "to right";
                    break;
                case "diagonal_left_to_right":
                    $pb_gradient_direction = "to bottom right";
                    break;
                case "diagonal_right_to_left":
                    $pb_gradient_direction = "to bottom left";
                    break;
                default:
                    $pb_gradient_direction = "to bottom";
            }
            $popupbox['pb_gradient_direction_final'] = $pb_gradient_direction;

            $ays_pb_bg_image = '';
            if( $popupbox["bg_image"] != ''){
                $ays_pb_bg_image = 'background-image: url("'. $popupbox["bg_image"] .'") !important;
                                    background-repeat: no-repeat !important;
                                    background-size: '.$pb_bg_image_sizing.' !important;
                                    background-position: '.$pb_bg_image_position.' !important';
            } elseif ( $popupbox["enable_background_gradient"] ) {
                $ays_pb_bg_image = "background-image: linear-gradient(". $pb_gradient_direction  .",". $popupbox["background_gradient_color_1"] .",". $popupbox["background_gradient_color_2"] .");";
            }

            $popupbox['bg_image_final'] = $ays_pb_bg_image;
            
            $closeButton = '';
            if ( $popupbox['close_button'] ){
                $closeButton = "ays-close-button-on-off";
            } else {
                $closeButton = "";
            }

            $ays_pb_delay                   = ($popupbox["delay"] == false) ? 0 : intval($popupbox["delay"]);
            $enable_open_delay_mobile       = ( isset($pop_options['enable_open_delay_mobile']) && $pop_options['enable_open_delay_mobile'] == 'on' ) ? 1 : 0;
            $ays_pb_open_delay_mobile       = isset($pop_options['open_delay_mobile']) && $pop_options['open_delay_mobile'] != '' ? intval($pop_options['open_delay_mobile']) : 0;
			$ays_pb_scroll_top              = ($popupbox["scroll_top"] == false) ? 0 : intval($popupbox["scroll_top"]);
            $enable_scroll_top_mobile       = ( isset($pop_options['enable_scroll_top_mobile']) && $pop_options['enable_scroll_top_mobile'] == 'on' ) ? 1 : 0;
            $ays_pb_scroll_top_mobile       = isset($pop_options['scroll_top_mobile']) && $pop_options['scroll_top_mobile'] != '' ? intval($pop_options['scroll_top_mobile']) : 0;
            $popup_scroll_from_top_percentage_px_mobile = (isset($pop_options['popup_scroll_from_top_percentage_px_mobile']) && $pop_options['popup_scroll_from_top_percentage_px_mobile'] != '') ? $pop_options['popup_scroll_from_top_percentage_px_mobile'] : 'pixels';

            $enable_autoclose_delay_text_mobile = isset($pop_options['enable_autoclose_delay_text_mobile']) && $pop_options['enable_autoclose_delay_text_mobile'] == 'on' ? true : false;
            $pb_autoclose_mobile = ( isset($pop_options['pb_autoclose_mobile']) && $pop_options['pb_autoclose_mobile'] != '' && $enable_autoclose_delay_text_mobile ) ? intval(esc_attr($pop_options['pb_autoclose_mobile'])) : $popupbox['autoclose'];
            $ays_pb_delay_second = ($popupbox['delay'] > 0) ? ($popupbox['delay'] / 1000) : 0;

            // if(isset($pop_options['enable_open_delay_mobile']) && $pop_options['enable_open_delay_mobile'] == 'on'){
            //     if($pb_autoclose_mobile > 0){
            //         $popup_mobile_delay_in_seconds = ($pop_options['open_delay_mobile'] > 0) ? intval($pop_options['open_delay_mobile']) / 1000 : 0;
            //         if ($pop_options['open_delay_mobile'] != 0) {
            //             $pb_autoclose_mobile += (floor($popup_mobile_delay_in_seconds) - 1);
            //         }
            //     }
            // } else {
            //     if($pb_autoclose_mobile > 0){
            //         if ($popupbox['delay'] != 0 ) {
            //             $pb_autoclose_mobile += (floor($ays_pb_delay_second) - 1);
            //         }
            //     }
            // }

            $ays_pb_autoclose = $popupbox['autoclose'];
            $popupbox['ays_pb_autoclose'] = $ays_pb_autoclose;

            //popup width percentage
            if( $popupbox['width'] != ''){
                if ( $popupbox['popup_width_by_percentage_px'] == 'percentage') {
                    if ( absint( intval( $popupbox['width'] ) ) > 100 ) {
                        $pb_width = '100%';
                    }else{
                        $pb_width = $popupbox['width'] . '%';
                    }
                }else{
                    $pb_width = $popupbox['width'] . 'px';
                }
            }else{
                $pb_width = '100%';
            }

            // popup minimal height
            if ($popupbox['pb_min_height'] == 0) {
                $pb_min_height = '';
            }else{
                $pb_min_height = "min-height: ".$popupbox['pb_min_height']."px;";
            }

            //pb full screen
            $pb_height = '';
            $pb_height_no_px = $popupbox['height'];
            if( $popupbox['enable_pb_fullscreen'] ){
                $pb_width = '100%';
                $pb_height = 'auto';
            }else{
                $pb_width  = $popupbox['popup_width_by_percentage_px'] == 'percentage' ? $popupbox['width'] . '%' : $popupbox['width'] . 'px';
                $pb_height = $popupbox['height'] . 'px';
            }

            if($pb_width == '0px' ||  $pb_width == '0%'){       
                $pb_width = '100%';
            }

            $popupbox['width'] = $pb_width;
            $popupbox['height'] = $pb_height;

            //popup padding percentage
            if( $popupbox['popup_content_padding'] != ''){
                if ( $popupbox['popup_padding_by_percentage_px'] == 'percentage') {
                    if ( absint( intval( $popupbox['popup_content_padding'] ) ) > 100 ) {
                        $pb_padding = '100%';
                    }else{
                        $pb_padding = $popupbox['popup_content_padding'] . '%';
                    }
                }else{
                    $pb_padding = $popupbox['popup_content_padding'] . 'px';
                }
            }else{
                $pb_padding = '20px';
                if($popupbox['view_type'] == 'minimal') {
                    $pb_padding = '0';
                }
            }

            $popupbox['padding'] = $pb_padding;

            //hide timer
            $ays_pb_timer_desc = '';

            $ays_pb_image_direction_timer = '';
            $ays_pb_image_direction_content_alignment = '';
            $ays_pb_image_direction_footer_alignment = '';
            $ays_pb_image_direction_image = '';
            $ays_pb_image_direction_position_relative = '';
            $ays_pb_image_direction_position_absolute = '';
            if( $popupbox['pb_bg_image_direction_on_mobile'] ){
                $ays_pb_image_direction_timer = 'right: 20%;bottom:0;';
                $ays_pb_image_direction_content_alignment = 'align-items: center;';
                $ays_pb_image_direction_footer_alignment = 'flex-direction: column;align-items: center';
                $ays_pb_image_direction_image = 'width:100%; height:180px;';
                $ays_pb_image_direction_position_relative = 'position: unset';
                $ays_pb_image_direction_position_absolute = 'position: unset; height:auto;';
            }

            if($popupbox['enable_hide_timer']){
                $ays_pb_timer_desc = "<p class='ays_pb_timer ays_pb_timer_".$id."' style='visibility:hidden'>".__("This will close in ", $this->plugin_name)." <span data-seconds='".$ays_pb_autoclose."' data-ays-seconds='{$ays_pb_autoclose}' data-ays-mobile-seconds='{$pb_autoclose_mobile}'>$ays_pb_autoclose</span>".__(" seconds", $this->plugin_name)."</p>";
            }else{
                $ays_pb_timer_desc = "<p class='ays_pb_timer ays_pb_timer_".$id."'>".__("This will close in ", $this->plugin_name)." <span data-seconds='$ays_pb_autoclose' data-ays-seconds='{$ays_pb_autoclose}' data-ays-mobile-seconds='{$pb_autoclose_mobile}'>$ays_pb_autoclose</span>".__(" seconds", $this->plugin_name)."</p>";
            }
            $popupbox['ays_pb_timer'] = $ays_pb_timer_desc;

            ///////////////////////////////////////////////////////////////////////////////////
            /* 
             * Popup Box container background gradient
             * 
             */

            //Animation Speed
            $ays_pb_animation_speed = (isset($popupbox["animation_speed"]) && $popupbox["animation_speed"] !== '') ? abs( $popupbox["animation_speed"]) : 1;

            //Close Animation Speed
            $ays_pb_close_animation_speed = (isset($popupbox["close_animation_speed"]) && $popupbox["close_animation_speed"] !== '') ? abs( $popupbox["close_animation_speed"] )  : 1;


            $ays_pb_animation_close_milleseconds = $ays_pb_close_animation_speed * 1000;

            if(!isset($popupbox["close_animation_speed"])){
                $ays_pb_close_animation_speed = $ays_pb_animation_speed;

                $ays_pb_animation_close_milleseconds = $ays_pb_close_animation_speed * 1000;
            }

            //close popup by ESC

            $close_popup_esc_flag = false;
            if( $popupbox['close_popup_esc'] ){
                $close_popup_esc_flag = true;
            }

            //close popup my clicking outsite the box
            $close_popup_overlay_flag= 0;
            $close_popup_overlay_mobile_flag = 0;

            if( $popupbox['close_popup_overlay'] ){
                $close_popup_overlay_flag = 1;
            }

            if( $popupbox['close_popup_overlay_mobile'] ){
                $close_popup_overlay_mobile_flag = 1;
            }

            $close_popup_by_classname_flag = false;
            if( $popupbox['enable_close_by_classname'] ){
                $close_popup_by_classname_flag = true;
            }

            $close_btn_size = (isset($popupbox['close_btn_size']) && $popupbox['close_btn_size'] != '') ? abs($popupbox['close_btn_size']) : '1';
            //close button size 
            $close_button_size = "transform:scale({$close_btn_size})";

            ///////////////////////////////////////////////////////////////////////////////////

            /*
             * PopupBox sound
             */

            $enable_pb_sound     = false;
            $ays_pb_sound_status = false;
            $ays_pb_sound        = "";
            $ays_pb_sound_html   = "";
            $ays_pb_check_sound  = $popupbox['enable_pb_sound'] ? 'on' : 'off';


            if(isset($settings_options['ays_pb_sound']) && $settings_options['ays_pb_sound'] != ''){
                $ays_pb_sound_status = true;
                $ays_pb_sound = $settings_options['ays_pb_sound'];
            }

            if( $popupbox['enable_pb_sound'] ){
                if($ays_pb_sound_status){
                    $enable_pb_sound = true;
                }
            }

            if($enable_pb_sound){
                $ays_pb_sound_html = "<audio id='ays_pb_sound_".$id."' class='ays_pb_sound' src='".$ays_pb_sound."'></audio>";
            }


            //Popup box close sound
            $animation_pb = false;
            $ays_pb_close_sound_status = false;
            $ays_pb_close_sound = "";
            $ays_pb_close_sound_html = "";
            $ays_pb_check_anim_speed  = $popupbox['animation_speed'];
            
            if(isset($settings_options['ays_pb_close_sound']) && $settings_options['ays_pb_close_sound'] != ""){
                $ays_pb_close_sound_status  = true;
                $ays_pb_close_sound = $settings_options['ays_pb_close_sound'];
            }

            if( $ays_pb_animation_speed ){
                if($ays_pb_close_sound_status){
                    $animation_pb = true;
                }
            }

            if($animation_pb){
                $ays_pb_close_sound_html = "<audio id='ays_pb_close_sound_".$id."' class='ays_pb_close_sound' src='".$ays_pb_close_sound."'></audio>";
            }

            // Social Media links
            $enable_social_links = (isset($popupbox['enable_social_links']) && $popupbox['enable_social_links'] == "on") ? true : false;
            
            $ays_social_links = '';
            if($enable_social_links){
                $ays_social_links .= Ays_Pb_Data::ays_pb_get_social_links_html($popupbox);
            }
            $show_dismiss = 'ays_pb_display_none';
            if( $popupbox['enable_dismiss'] ){
                $show_dismiss = '';
            }
            
            $dismiss_add = "<div class='ays-pb-dismiss-ad {$show_dismiss}' data-dismiss='' data-id='{$id}'>
                                <button id='ays_pb_dismiss_ad'>
                                    ".$popupbox['enable_dismiss_text']."
                                </button>
                            </div>";


            //action on popup content
            $popupbox['redirect_url_content_click'];

            $enable_content_click_flag = false;
            $enable_close_content_flag = false;
            $enable_redirect_content_click_flag = false;
            $enable_new_tab_content_click_flag = false;

            if( $popupbox['enable_content_click'] ){
                $enable_content_click_flag = true;
            }
            
            if( $popupbox['enable_close_content_click'] ){
                $enable_close_content_flag = true;
            }

            if( $popupbox['enable_redirect_content_click'] ){
                $enable_redirect_content_click_flag = true;
            }

            if( $popupbox['enable_new_tab_content_click'] ){
                $enable_new_tab_content_click_flag = true;
            }


            //title style
            $popupbox['font_family_str'] = '';
            $popupbox['font_size_str'] = '';
            $popupbox['font_weight_str'] = '';
            $popupbox['text_alignment_str'] = '';
            $popupbox['text_transform_str'] = '';
            $popupbox['text_decoration_str'] = '';
            $popupbox['line_height_str'] = '';
            $popupbox['letter_spacing_str'] = '';
            $popupbox['letter_spacing_str'] = '';
            $popupbox['title_text_shadow'] = '';

            if( $popupbox['enable_title_styles'] ){
                $popupbox['font_family_str'] = $popupbox['title_font_family'];
                $popupbox['font_size_str'] = $popupbox['title_font_size'] . 'px';
                $popupbox['font_weight_str'] = $popupbox['title_font_weight'];
                $popupbox['text_alignment_str'] = $popupbox['title_text_alignment'];
                $popupbox['text_transform_str'] = $popupbox['title_text_transform'];
                $popupbox['text_decoration_str'] = $popupbox['title_text_decoration'];
                $popupbox['line_height_str'] = $popupbox['title_line_height'];
                $popupbox['letter_spacing_str'] = $popupbox['title_letter_spacing'] . 'px';
            }
            
            if($popupbox['enable_pb_title_text_shadow']){
                $popupbox['title_text_shadow'] = 'text-shadow: '.$popupbox['pb_title_text_shadow_x_offset'].'px '.$popupbox['pb_title_text_shadow_y_offset'].'px '.$popupbox['pb_title_text_shadow_z_offset'].'px '.$popupbox['pb_title_text_shadow'];
            }

            /*******************************************************************************************************/
                
            $ays_pb_bgcolor_rgba = Ays_Pb_Data::hex2rgba( $popupbox['bgcolor'], 0.85 );

            switch( $popupbox['view_type'] ){
                case 'mac':
                case 'cmd':
                case 'ubuntu':
                case 'winXP':
                case 'win98':
                case 'lil':
                case 'image':
                case 'minimal':
                case 'template':
                case 'video':
                case 'peachy':
                case 'yellowish':
                case 'coral':
                case 'cookie':
                case 'frozen':
                case 'book':
                case 'holiday':
                case 'food':
                case 'forest':
                    include_once( 'partials/ays-pb-template-'. $popupbox['view_type'] .'.php' );
                    $class_name = 'Ays_Pb_Template_' . ucfirst( $popupbox['view_type'] );
                    $template = new $class_name( $this->plugin_name, $this->version );
                    $modal_close_additional_js = "";
                break;
                default:
                    include_once( 'partials/ays-pb-template-default.php' );
                    $template = new Ays_Pb_Template_Default( $this->plugin_name, $this->version );
                    $modal_close_additional_js = "";
                break;
            }

            if($popupbox['view_type'] == 'cookie'){
                $cookie_class = 'ays-pb-modals_cookie';
            }else{
                $cookie_class = '';
            }

            if( $popupbox['enable_box_shadow'] ){
                $box_shadow = 'box-shadow: '.$popupbox['pb_box_shadow_x_offset'].'px '.$popupbox['pb_box_shadow_y_offset'].'px '.$popupbox['pb_box_shadow_z_offset'].'px '.$popupbox['box_shadow_color'].' !important;';
            }else{
                $box_shadow = "";
            }

            $disable_scroll_on_popup = '';
            $disable_scroll_display_none = '';
            $position_absolute_popup_scroll = '';
            $padding_top_popup_scroll = '';
            $width_popup_scroll = '';
            $bottom_popup_scroll = '';
            $margin_top = '';
            if($popupbox['disable_scroll_on_popup']){
                $disable_scroll_on_popup = 'overflow:hidden !important;';
                $disable_scroll_display_none = 'display:none;';
                $position_absolute_popup_scroll = 'position:absolute;';
                $padding_top_popup_scroll = 'padding:65px 10px;';
                $width_popup_scroll = 'width:100%';
                $bottom_popup_scroll = 'bottom:unset';
                $margin_top = 'margin-top: 65px;';
            }

            $ays_pb_show_scrollbar_class = '';
            if($popupbox['show_scrollbar']){
                $ays_pb_show_scrollbar_class = 'ays-pb-show-scrollbar-content';
            }
            
            $popupbox['closeButton'] = $closeButton;
            $popupbox_view = array();
            
        	$popupbox_view['popupbox_start'] = $ays_pb_custom_css."
        			<div class='".$cookie_class." ays-pb-modals av_pop_modals_".$id."' data-id='".$id."' style='".$show_popup."' data-show='false'>
                        <input type='hidden' value='". $popupbox['animate_in'] ."' id='ays_pb_modal_animate_in_".$id."'>
                        <input type='hidden' value='". $popupbox['animate_out'] ."' id='ays_pb_modal_animate_out_".$id."'>
                        <input type='hidden' value='". $ays_pb_animation_close_milleseconds ."' id='ays_pb_animation_close_speed_".$id."'>
                        <label for='ays-pb-modal-checkbox_".$id."' class='ays-pb-visually-hidden-label'>modal-check</label>
                        <input type='hidden' id='ays_pb_view_type_".$id."' data-type='".$popupbox['view_type']."'>
        				<input id='ays-pb-modal-checkbox_".$id."' class='ays-pb-modal-check' type='checkbox' $open/>
                        {$ays_pb_sound_html}
                        {$ays_pb_close_sound_html}";

            $popupbox_view = apply_filters( 'ays_pb_before_container', $popupbox_view, $popupbox );

            $container_classes = array(
                'main_class'                     => 'ays-pb-modal',
                'class_with_id'                  => 'ays-pb-modal_'.$id,
                'custom_class'                   => $popupbox['custom_class'],
                'animation_class'                => $ays_pb_animate_in_open,
            );

            $container_classes = apply_filters( 'ays_pb_container_class', $container_classes );

            $popupbox_view['popupbox_container_div_start'] = "<div class='ays-popup-box-main-box ". implode( ' ', $container_classes ) . "' ";

            $popupbox_view['ays_pb_flag'] = $ays_pb_flag;

            $popupbox_view['popupbox_container_div_end'] = ">";

            $popupbox_view['popupbox_title'] = $ays_pb_title;

            $popupbox_view['popupbox_description'] = $ays_pb_description;

            $popupbox_view = apply_filters( 'ays_pb_container_header', $popupbox_view, $popupbox );

            $popupbox_view['popupbox_header_hr'] = ( !$popupbox['show_popup_title'] && !$popupbox['show_popup_desc'] ) ?  '' :  '<hr  class="ays-popup-hrs-default"/>';

            $popupbox_view['popupbox_content_start'] = "<div class='" . $ays_pb_show_scrollbar_class . "'>";

            if($popupbox['display_post_content_by_id'] != ''){
                $page_id = $popupbox['display_post_content_by_id']; // the ID of the Bio page
                $page_data = get_page( $page_id );
                $page_content = ( isset( $page_data->post_content ) && $page_data->post_content != '' ) ? do_shortcode( $page_data->post_content ) : '';
                $pb_content = "<div class='ays-pb-custom-html'>".$page_content."</div>";
            }else{
                $pb_content = "<div class='ays-pb-custom-html'>".Ays_Pb_Data::ays_autoembed( $popupbox["custom_html"] )."</div>";
            }

            $pb_content = Ays_Pb_Data::replace_message_variables( $pb_content, $message_data );

            // CUSTOM FIELDS START
            $popup_modal_content_for_fields = (isset($popupbox["modal_content"]) && ($popupbox["modal_content"] == 'contact_form')) ? 'on' : 'off';
            $popup_default_attributes_subscription = array(
                'popup_attributes' => array(
                    'ays_pb_form_name' => array(
                        "id" => null,
                        "slug" => "ays_pb_form_name",
                        "name" => __( "Name", $this->plugin_name ),
                        "type" => 'text',
                        "enable" => ($enable_ays_pb_subs_name_field || $popupbox["modal_content"] == 'contact_form') ? "on" : "off",
                        "required" => ($ays_pb_subs_name_required) ? "on" : "off",
                        "placeholder" => (isset($popupbox['ays_pb_subs_name_placeholder'])) ? $popupbox['ays_pb_subs_name_placeholder'] : 'Name',
                        
                    ),
                    'ays_pb_form_email' => array(
                        "id" => null,
                        "slug" => "ays_pb_form_email",
                        "name" => __( "Email", $this->plugin_name ),
                        "type" => 'email',
                        "enable" => "on",
                        "required" => "on",            
                        "placeholder" => (isset($popupbox['ays_pb_subs_email_placeholder'])) ? $popupbox['ays_pb_subs_email_placeholder'] : 'Email*',
                    ),
                    'ays_pb_form_message' => array(
                        "id" => null,
                        "slug" => "ays_pb_form_message",
                        "name" => __( "Message", $this->plugin_name ),
                        "type" => 'textarea',
                        "enable" => $popup_modal_content_for_fields,
                        "required" => "on",
                        "placeholder" => "Message"
                    )
                )
            );
            $custom_fields_subscription = array();

            if(isset($popupbox['popup_attributes']) && !empty($popupbox['popup_attributes'])){
                $custom_fields_subscription = $popupbox['popup_attributes'];
            }
            else{                            
                $custom_fields_subscription = $popup_default_attributes_subscription['popup_attributes'];
            }

            $classname_for_yes_button = 'ays-pb-class-for-yes-'.$id;
            $classname_for_no_button  = 'ays-pb-class-for-no-'.$id;
            
            // CUSTOM FIELDS END

            $recaptcha_content_html = "";
            $recaptcha_class = "";

            $pop_options['enable_recaptcha'] = (isset( $pop_options['enable_recaptcha'] ) && $pop_options['enable_recaptcha'] == "on") ? "on" : "off";
            $enable_recaptcha = (isset( $pop_options['enable_recaptcha'] ) && $pop_options['enable_recaptcha'] == "on") ? true : false;

            if ( $enable_recaptcha ) {
                $integrations_args = apply_filters( 'ays_pb_front_end_integrations_options', array(), $pop_options );
                $recaptcha_content = apply_filters( "ays_pb_front_end_integrations", array(), $integrations_args, $pop_options );
                if ( !is_null($recaptcha_content) && !empty( $recaptcha_content ) ) {
                    $recaptcha_content_html = implode( $recaptcha_content );
                    $recaptcha_class = "ays-pb-recaptcha-enabled";
                }
            }

            switch ($popupbox["modal_content"]) {
                case 'shortcode':
                    $popupbox_content = do_shortcode( $popupbox["shortcode"] );
                    break;
                case 'custom_html':
                    $popupbox_content = $pb_content;    
                    break;
                case 'subscription': 
                    $redirect_url_value ="";
                    if($enable_redirect_after_submission) {
                        if(wp_http_validate_url($redirect_after_submission_url)) {
                            $redirect_url_value = $redirect_after_submission_url;
                        }
                    }
                    $subscription_content = $this->ays_pb_get_input_fields($custom_fields_subscription , $id , $popupbox["modal_content"]);
                        $popupbox_content = "<form action='' method='post' class='ays-pb-form ". $recaptcha_class ."'>";
                            $popupbox_content .= "<div class='ays_pb_subscription_live_container'>";
                                $popupbox_content .= $subscription_content;
                                $popupbox_content .= $recaptcha_content_html;
                                $popupbox_content .= "<div class='ays_pb_subscription_live'>
                                                        <input type='hidden' name='ays_pb_redirect_after_subscription_url' value='".$redirect_url_value."'>
                                                        <input type='submit' class='ays_pb_sub_button ays-pb-buttons-style' name='ays_pb_sub_button_".$id."' value='".$popupbox['button_text']."'>
                                                    </div>";
                            $popupbox_content .= "</div>";
                        $popupbox_content .= "</form>";  
                    break;
                case 'yes_or_no':
                          $popupbox_content =   "
                            <div class='ays_pb_yes_or_no_live_container'>".
                                "<div class='ays_pb_yes_or_no_live_para'>". 
                                "<p>".$ays_pb_yes_or_no_question."</p>"
                                ."</div>".
                                "<div class='ays_pb_yes_or_no_live_buttons'> 
                                    <div class='ays_pb_yes_or_no_live'>
                                        <input type='button' class='ays_pb_yes_or_no_live_btn ays_pb_yes_or_no_live_btn1 ays-pb-buttons-style ".$classname_for_yes_button."' value='".$popupbox['button_text_yes']."' readonly>
                                    </div>".
                                    "<div class='ays_pb_yes_or_no_live'>
                                        <input type='button' class='ays_pb_yes_or_no_live_btn ays_pb_yes_or_no_live_btn2 ays-pb-buttons-style ".$classname_for_no_button."' value='".$popupbox['button_text_no']."' readonly>
                                        </div>".
                                "</div>".
                            "</div>";
                    break;
                case 'iframe':
                    $popupbox_content = "";
                    if ( !empty( $popupbox['ays_pb_iframe_link'] ) ) {
                        $popupbox_content =  "<div class='ays_video_content'> " . Ays_Pb_Data::ays_autoembed($popupbox['ays_pb_iframe_link']) . " </div>";
                    }
                    break;
                case 'contact_form':
                    $contact_form_content = $this->ays_pb_get_input_fields($custom_fields_subscription , $id , $popupbox["modal_content"]);
                    $popupbox_content =  "<form action='' method='post' class='ays-pb-form ". $recaptcha_class ."'>".
                                            "<div class='ays_pb_contact_form_live_container'>";
                                                $popupbox_content .= $contact_form_content;
                                                $popupbox_content .= $recaptcha_content_html;
                                                $popupbox_content .= "<div class='ays_pb_contact_form_live '><input type='submit' class='ays_pb_contact_form_live_btn ays-pb-buttons-style' name='ays_pb_contact_form_button_".$id."' value='".$popupbox['button_text']."'></div>".
                                            "</div>". 
                                         "</form>";
                    break;                
                case 'send_file':
                    $data_redirect_url ='';
                    if($enable_redirect_after_submission) {
                        if(wp_http_validate_url($redirect_after_submission_url)) {
                            $data_redirect_url = "data-redirect='$redirect_after_submission_url'";
                        }
                    }
                    $send_file_content = $this->ays_pb_get_input_fields($custom_fields_subscription , $id , $popupbox["modal_content"]);
                    $popupbox_content =  "<form action='' method='post' id='ays_pb_send_file_form' class='". $recaptcha_class ." ays_pb_send_file_form ays-pb-form' data-confirm='".$popupbox['ays_pb_sb_enable_conf_box']."'>".
                            "<div class='ays_pb_send_file_container'>";
                                $popupbox_content .= $send_file_content;
                                $popupbox_content .= $recaptcha_content_html;
                                    $popupbox_content .= "<div class='ays_pb_send_file_type'>
                                        <div class='ays-pb-preloader'>
                                            <img src='". AYS_PB_ADMIN_URL ."/images/loaders/3-1.svg' " . $popupbox['lazy_loading_attr'] . ">
                                        </div>
                                        <input type='hidden' name='ays_pb_send_file_name' value='".$ays_pb_send_file_name."'>  
                                        <input type='hidden' name='ays_pb_send_file_content' value='".$ays_pb_send_file_content."'>
                                        <input type='hidden' name='send_file_attachment_id' value='".$ays_pb_send_file_id."'>
                                        <input type='hidden' name='popupbox_title' value='".$popupbox['title']."'>
                                        <input type='hidden' name='current_popup_id' value='".$id."'>
                                        <input type='button' class='ays_pb_send_file_type_btn ays-pb-buttons-style'" . $data_redirect_url . " name='ays_pb_send_file_type_btn_".$id."' value='".$popupbox['button_text']."'>
                                    </div>".
                            "</div>".
                        "</form>";
                    break;    
                case 'down_file':
                    $popupbox_content = '';                    
                    if($ays_pb_down_file_url != ''){

                        $popupbox_content =     "<div class='ays_pb_down_file_container'>" .
                                                    "<div class='ays_pb_down_file_type'><a href='".$ays_pb_down_file_url."' download='".$ays_pb_down_file_url."' class='ays-pb-buttons-style'> ".__("Download", $this->plugin_name)."</a></div>".
                                                "</div>";
                    }
                    break;
                case 'google_map':
                    $popupbox_content = '<div class="ays_pb_google_map_live_container">
                                            <iframe class="ays-pb-iframe-google-map" style="border: 0;" src="https://www.google.com/maps/embed/v1/search?key='.$ays_pb_google_map_api_key.'&q='.$ays_pb_google_map_search.'" width="300" height="250" frameborder="0" allowfullscreen="allowfullscreen" loading="lazy">
                                            </iframe>
                                        </div>';
                    break;                
    
                case 'login_form':
                        $popupbox_content = '';
                        if( !is_user_logged_in() ){
                            $args = array(
                                'echo' => false,
                                // 'redirect'    => admin_url( 'profile.php' ),
                                'id_username' => 'ays_pb_user_login',
                                'id_password' => 'ays_pb_user_pass',
                                'id_remember' => 'ays_pb_rememberme',
                                'id_submit'   => 'ays_pb_submit',
                            );
                            $popupbox_content = "<div class='ays_pb_login_form_container'>" . wp_login_form( $args ) . "</div>";
                        }
                    break;
                case 'coupon_type':
                    $popupbox_content = "<div class='ays_pb_coupon_container'>
                                            <div class='ays_pb_coupon_type'>
                                                <p>".$active_coupon."</p>
                                            </div>
                                        </div>";
                    break;
                case 'woo':
                    $popup_woo_prod_image = isset($woo_product['image']) ? $woo_product['image'] : '';
                    $popup_woo_prod_name  = isset($woo_product['name']) ? $woo_product['name'] : '';
                    $popup_woo_prod_prod_url   = isset($woo_product['prodUrl']) ? $woo_product['prodUrl'] : '';
                    $popup_woo_prod_prod_link  = isset($woo_product['link']) ? $woo_product['link'] : '';
                    $popupbox_content = "<div class='ays_pb_woo_live_container ays-pb-woo-container'>
                                            <div class='ays-woo-block-main'>
                                                <div class='ays-woo-block' style='flex-wrap: wrap;'>
                                                    <div class='product-image'>
                                                        <img style='max-width: 135px;' src='".$popup_woo_prod_image."' alt='".$popup_woo_prod_name." ' " . $popupbox['lazy_loading_attr'] . ">
                                                    </div>
                                                    <div class='ays-woo-product-block' style='padding-top: 20px;'>
                                                        <h4 class='ays-woo-product-title'>
                                                            <a href='".$popup_woo_prod_prod_url."'>".$popup_woo_prod_name."</a>
                                                        </h4>
                                                        <div class='ays-pb-buttons-style ays-pb-woo-button'>".$popup_woo_prod_prod_link."</div>                                                
                                                    </div>
                                                </div>
                                            </div>
                                        </div>";
                break;
                case 'countdown':
                        $countDownHeight  = $pb_height_no_px - (($pb_height_no_px * 10)/100)."px";
                        $popupbox_content = "<form action='' method='post' class='ays-pb-form'>".
                                               "<div class='ays-pb-countdown-container-".$id." display_none'>" . 
                                                   "<div class='ays-pb-countdown-type-".$id."''>
                                                       <div class='ays-pb-countdown-box-".$id."'>
                                                           <div class='ays-pb-countdown-counters'>
                                                               <div class='ays-pb-countdown-counters-timers'>
                                                                   <span id='ays-pb-countdown-days-".$id."'></span>
                                                               </div>
                                                               <div class='ays-pb-countdown-counters-time'>
                                                                   <span>". __( "Days", $this->plugin_name ) ."</span>
                                                               </div>
                                                           </div>
                                                           <div class='ays-pb-countdown-counters'>
                                                               <div class='ays-pb-countdown-counters-timers'>
                                                                   <span id='ays-pb-countdown-hours-".$id."'></span>
                                                               </div>
                                                               <div class='ays-pb-countdown-counters-time'>
                                                                   <span>". __( "Hours", $this->plugin_name ) ."</span>
                                                               </div>
                                                           </div>
                                                           <div class='ays-pb-countdown-counters'>
                                                               <div class='ays-pb-countdown-counters-timers'>
                                                                   <span id='ays-pb-countdown-minutes-".$id."'></span>
                                                               </div>
                                                               <div class='ays-pb-countdown-counters-time'>
                                                                   <span>". __( "Minutes", $this->plugin_name ) ."</span>
                                                               </div>
                                                           </div>
                                                           <div class='ays-pb-countdown-counters'>
                                                               <div class='ays-pb-countdown-counters-timers'>
                                                                   <span id='ays-pb-countdown-seconds-".$id."'></span>
                                                               </div>
                                                               <div class='ays-pb-countdown-counters-time'>
                                                                   <span>". __( "Seconds", $this->plugin_name ) ."</span>
                                                               </div>
                                                           </div>
                                                       </div>
                                                    </div>".
                                                "</div>". 
                                            "</form>";
           
                    break;   
                case 'cookie':
                        $popupbox_content = "<p style='text-align: left; margin:0;'><img src='".AYS_PB_PUBLIC_URL."/images/icons/cookie.svg' style='width:40px;height:40px;' " . $popupbox['lazy_loading_attr'] . " /></p>";
                        $popupbox_content .= "<input type='hidden' class='ays-pb-accept-cookie-expire-time' data-expire='".$popupbox['accept_cookie_expire_time']."' data-id='".$id."'>";
                        $popupbox_content .= $pb_content;
                        $popupbox_content .= "<div class='ays-pb-cookie-btn-container'><button class='ays-pb-accept-all-cookies ays-pb-buttons-style'>". __( "Accept all cookies", $this->plugin_name ) ."</button></div>";
                    break;
                default:
                    $popupbox_content = $pb_content;
                    break;
            }

            $popupbox_view['popupbox_content'] = $popupbox_content;
            $popupbox_view = apply_filters( 'ays_pb_content', $popupbox_view, $popupbox );
            
            $popupbox_view['popupbox_content_end'] = "</div>";
            $popupbox_view['ays_social_links'] = $ays_social_links;
            $popupbox_view['dismiss_add'] = $dismiss_add;
            $popupbox_footer = $ays_pb_timer_desc;
            if( !isset( $popupbox_view['popupbox_footer'] ) ){
                $popupbox_view['popupbox_footer'] = $popupbox_footer;
                $popupbox_view = apply_filters( 'ays_pb_container_footer', $popupbox_view, $popupbox );
            }
            if( !isset( $popupbox_view['popupbox_close'] ) ){
                $popupbox_view['popupbox_close'] = "<div class='ays-pb-modal-close ".$closeButton." ays-pb-modal-close_".$id." ays-pb-close-button-delay ays_pb_pause_sound_".$id."' title='" . $popupbox['close_button_hover_text'] . "'></div>";
                $popupbox_view = apply_filters( 'ays_pb_close_button', $popupbox_view, $popupbox );
            }

            $cookie_top_percent = '';
            if( ( $popupbox['width'] == '' || $popupbox['width'] == '100%' ) &&  $popupbox["modal_content"] == 'cookie' ){
                $cookie_top_percent = 'top: 92%;';
            }
            
           // $popupbox_view['popupbox_footer'] = $popupbox_footer;
           
            $popupbox_view['popupbox_container_end'] = "</div>";

            $popupbox_view = apply_filters( 'ays_pb_after_container', $popupbox_view, $popupbox );

            remove_all_filters( 'ays_pb_before_container' );
            remove_all_filters( 'ays_pb_container_class' );
            remove_all_filters( 'ays_pb_container_header' );
            remove_all_filters( 'ays_pb_content' );
            remove_all_filters( 'ays_pb_container_footer' );
            remove_all_filters( 'ays_pb_close_button' );
            // remove_all_filters( 'ays_pb_after_container' );
            remove_all_filters( 'ays_pb_after_container' );

            $bgImageStyles = '';
            $bgImageStylesToAppend = '';
            if ($popup_enable_lazy_loading && $popupbox['bg_image_final'] != '') {
                $bgImageStylesToAppend = ".ays-pb-modal_".$id." .ays_winxp_content {
                    ". $popupbox['bg_image_final'] .";
                }";
            } else {
                $bgImageStyles = $popupbox['bg_image_final'];
            }

            $popupbox_view['popupbox_end'] = "<div id='ays-pb-screen-shade_".$id."' overlay='overlay_".$id."' data-mobile-overlay='".$enable_overlay_text_mobile."'></div>
                        <input type='hidden' class='ays_pb_delay_".$id."' value='". $popupbox['delay'] ."'/>
                        <input type='hidden' class='ays_pb_delay_mobile_".$id."' value='".$ays_pb_open_delay_mobile."'/>
                        <input type='hidden' class='ays_pb_scroll_".$id."' value='". $popupbox['scroll_top'] ."'/>
                        <input type='hidden' class='ays_pb_scroll_mobile_".$id."' value='".$ays_pb_scroll_top_mobile."'/>
                        <input type='hidden' class='ays_pb_scroll_".$id."' value='". $popupbox['scroll_top'] ."' data-type='".$popupbox['popup_scroll_from_top_percentage_px']."'/>
                        <input type='hidden' class='ays_pb_scroll_mobile_".$id."' value='". $ays_pb_scroll_top_mobile ."' data-type='".$popup_scroll_from_top_percentage_px_mobile."'/>
                        <input type='hidden' class='ays_pb_abt_".$id."' value='". $popupbox['action_button_type'] ."'/>
                        <input type='hidden' class='close_pb_by_scroll_down_".$id."' value='". $popupbox['close_pb_by_scroll_down'] ."'/>
                        <input type='hidden' class='redirect_url_".$id."' value='". $popupbox['redirect_url_content_click'] ."'/>
                        <input type='hidden' class='ays-pb-after-visiting-x-page".$id."' value='".$popupbox['scrolling_to_element']."'>
        			</div>
                    <style>
                        .ays-pb-modal_".$id.", .av_pop_modals_".$id." {
                            display:none;
                        }
                        .ays-pb-modal-check:checked ~ #ays-pb-screen-shade_".$id." {
                            opacity: 0.5;
                            pointer-events: auto;
                        }
                        
                        .ays-pb-modal_".$id." .ays_cmd_window {                            
                            background-color: ".$ays_pb_bgcolor_rgba.";
                        }
                        
                        .ays-pb-modal_".$id." .ays_cmd_window-cursor .ays_cmd_i-cursor-underscore {
                            background-color: black;
                        }
                        
                        .ays-pb-modal_".$id." .ays_cmd_window-cursor .ays_cmd_i-cursor-indicator {
                            background-color: transparent;
                        }

                        .ays-pb-modal_".$id." .ays_pb_description > *, 
                        .ays-pb-modal_".$id." .ays-pb-book-template-content > *, 
                        .ays-pb-modal_".$id." .ays-pb-book-template-content-text, 
                        .ays-pb-modal_".$id." .ays-pb-book-template-body, 
                        .ays-pb-modal_".$id." .ays_pb_timer,
                        .ays-pb-modal_".$id." .ays_content_box p,
                        .ays-pb-modal_".$id." .ays-pb-dismiss-ad > button#ays_pb_dismiss_ad{
                            color: ".$popupbox['textcolor'] ." !important;
                            font-family: ". $popupbox['pb_font_family'] .";
                        }
                        
                        .ays-pb-modal_".$id." .ays_pb_description > *,.ays-pb-modal_".$id." .ays_ubuntu_window_content > .ays_pb_description > p{
                            font-size: ". $popupbox['pb_font_size'] ."px;
                        }
                        
                        .ays-pb-modal_".$id." .ays-pb-close-btn-color,
                        .ays-pb-modal_".$id." .ays_cmd_control-close{
                            color: ".$popupbox['close_button_color']." !important;
                            fill: ".$popupbox['close_button_color']." !important;
                        }    

                        .ays-pb-modal_".$id." .ays-pb-close-btn-color:hover{
                            color: ".$popupbox['close_button_hover_color']." !important;
                        }  

                        .ays-pb-modal_".$id." .ays_pb_material_close_circle_icon{
                            fill: ".$popupbox['close_button_color']." !important;
                        }

                        .ays-pb-modal_".$id." .ays_pb_material_close_circle_icon:hover{
                            fill: ".$popupbox['close_button_hover_color']." !important;
                        }
                        
                        .ays-pb-modal_".$id." .ays_pb_material_close_icon{
                            fill: ".$popupbox['close_button_color']." !important;
                        }
                        
                        .ays-pb-modal_".$id." .ays_pb_material_close_icon:hover{
                            fill: ".$popupbox['close_button_hover_color']." !important;
                        }

                        #ays-pb-screen-shade_".$id." {
                            opacity: 0;
                            background: ". $popupbox['overlay_color'] .";
                            position: fixed;
                            left: 0;
                            right: 0;
                            top: 0;
                            bottom: 0;
                            pointer-events: none;
                            transition: opacity 0.8s;
                            ".$blured_overlay.";
                        }

                        .ays-pb-modal_".$id.".". $popupbox['animate_in'] ." {
                            animation-duration: ". $ays_pb_animation_speed ."s !important;
                        }

                        .ays-pb-modal_".$id.".". $popupbox['animate_out'] ." {
                            animation-duration: ".$ays_pb_close_animation_speed."s !important;
                        }
                        
                        
                        .ays-pb-modal_".$id." .ays_template_head {
                            background-color: {$popupbox['header_bgcolor']};
                        }
                        
                        .ays-pb-modal_".$id." .ays_winxp_content {
                            background-color: ". $popupbox['bgcolor'] ." !important;
                            ". $bgImageStyles .";
                        }
                        
                        .ays-pb-modal_".$id." .ays_win98_head {
                            background-color: ". $popupbox['bgcolor'] .";
                        }
                        .ays-pb-modal_".$id." .ays_lil_head {
                            background-color: ". $popupbox['header_bgcolor'] .";
                        }
                        
                        // .ays-pb-modal_".$id." .ays_template_footer {
                        //     background-color: ". $popupbox['bgcolor'] .";
                        // }
                        .ays-pb-modal_".$id." .ays-pb-modal-close {
                            color: {$popupbox["textcolor"]} !important;
                            font-family: {$popupbox["pb_font_family"]};
                            {$close_button_size};
                        }
                        
                        .ays-pb-modal_".$id." .ays-pb-modal-close_".$id.":hover .close-lil-btn {
                            transform: rotate(180deg) scale(".$close_btn_size.") !important;
                       }

                        
                        .ays-pb-modal_".$id." .ays_pb_title {
                            color: ". $popupbox['textcolor'] ." !important;
                            font-family: ". $popupbox['pb_font_family'] .";
                        }

                        .ays-pb-modal_".$id."{
                            ".$pb_min_height."
                            ".$box_shadow."
                        }

                        .ays-pb-modals_cookie.ays-pb-modals.av_pop_modals_".$id."{
                            ".$cookie_top_percent."
                        }

                        .ays-pb-modals .ays-pb-modal_".$id." .ays-pb-buttons-style, .ays-pb-modals .ays-pb-modal_".$id." #ays_pb_submit{
                            font-size: " . $buttons_font_size . ";
                            padding: " . $buttons_top_bottom_padding . " " . $buttons_left_right_padding . ";
                            border-radius: " . $buttons_border_radius . ";
                            background-color: ".$popupbox['buttons_bg_color'].";
                            color: ".$popupbox['buttons_text_color'].";
                            white-space: nowrap;
                            letter-spacing: 0;
                            box-shadow: unset;
                            width: ".$buttons_width.";
                            max-width: 100%;
                            word-wrap: break-word;
                            line-height: 1;
                            border: unset;
                            transition: 0.5s;
                        }

                        .ays-pb-modals .ays-pb-modal_".$id." input.ays-pb-buttons-style.ays_pb_yes_or_no_live_btn1{
                            background-color: ".$popupbox['buttons_bg_color_1'].";
                        }

                        .ays-pb-modals .ays-pb-modal_".$id." input.ays-pb-buttons-style.ays_pb_yes_or_no_live_btn2{
                            background-color: ".$popupbox['buttons_bg_color_2'].";
                        }

                        @media screen and (max-width: 768px){
                            .ays-pb-modal_".$id."{
                                width: ". $popupbox['mobile_width'] ." !important;
                                max-width: ". $popupbox['mobile_max_width'] ." !important;
                                height : ".$popupbox['mobile_height']."px !important;
                                box-sizing: border-box;
                            }

                            .ays-pb-modal_".$id."  .ays_pb_description > p{
                                font-size: ".$popupbox['pb_font_size_for_mobile']."px !important;
                                word-break: break-word !important;
                                word-wrap: break-word;
                            }

                            .ays-pb-modal_".$id.".ays_template_window p.ays_pb_timer.ays_pb_timer_".$id.",
                            .ays-pb-modal_".$id.".ays-pb-frozen-template-window p.ays_pb_timer.ays_pb_timer_".$id.",
                            .ays-pb-modal_".$id.".ays-pb-food-template-window p.ays_pb_timer.ays_pb_timer_".$id.",
                            .ays-pb-modal_".$id.".ays-pb-forest-template-window p.ays_pb_timer.ays_pb_timer_".$id."
                            {
                                {$ays_pb_image_direction_timer}
                            }
                            .ays-pb-modal_".$id.".ays_template_window footer.ays_template_footer,
                            .ays-pb-modal_".$id.".ays-pb-frozen-template-window footer.ays_template_footer,
                            .ays-pb-modal_".$id.".ays-pb-food-template-window footer.ays_template_footer,
                            .ays-pb-modal_".$id.".ays-pb-forest-template-window footer.ays_template_footer
                            {
                                {$ays_pb_image_direction_footer_alignment}
                            }

                            .ays-pb-modal_".$id.".ays_template_window div.ays_bg_image_box,
                            .ays-pb-modal_".$id.".ays-pb-frozen-template-window div.ays_bg_image_box,
                            .ays-pb-modal_".$id.".ays-pb-food-template-window div.ays_bg_image_box,
                            .ays-pb-modal_".$id.".ays-pb-forest-template-window div.ays_bg_image_box
                            {
                                {$ays_pb_image_direction_image}
                            }

                            .ays-pb-modal_".$id.".ays_template_window .ays_template_content,
                            .ays-pb-modal_".$id.".ays-pb-frozen-template-window .ays_template_content,
                            .ays-pb-modal_".$id.".ays-pb-food-template-window .ays_template_content,
                            .ays-pb-modal_".$id.".ays-pb-forest-template-window .ays_template_content{
                                {$ays_pb_image_direction_position_relative}
                            }

                            .ays-pb-modal_".$id.".ays_template_window .ays_template_content .ays_template_main,
                            .ays-pb-modal_".$id.".ays-pb-frozen-template-window .ays_template_content .ays-pb-frozen-template-main,
                            .ays-pb-modal_".$id.".ays-pb-food-template-window .ays_template_content .ays-pb-food-template-main,
                            .ays-pb-modal_".$id.".ays-pb-forest-template-window .ays_template_content .ays-pb-forest-template-main{
                                {$ays_pb_image_direction_position_absolute}
                            }
                        }

                        .ays-pb-disable-scroll-on-popup,
                        .ays_lil_window.ays-pb-modal_".$id.",
                        .ays-pb-modals .ays-pb-modal_".$id."{
                            ".$disable_scroll_on_popup." 
                            overflow-y: hidden !important;
                        }
                        .ays_lil_window .ays_lil_main,
                        .ays_window.ays-pb-modal_".$id." .ays_pb_description,
                        .ays_win98_window.ays-pb-modal_".$id." .ays_pb_description,
                        .ays_cmd_window.ays-pb-modal_".$id." .ays_pb_description,
                        .ays_winxp_window.ays-pb-modal_".$id." .ays_pb_description,
                        .ays_ubuntu_window.ays-pb-modal_".$id." .ays_pb_description{
                            ".$margin_top."
                        }
                        
                        .ays-pb-modals .ays-pb-modal_".$id." .ays_pb_description + hr{
                            ".$disable_scroll_display_none."
                        }

                        .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_lil_head, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_topBar, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_cmd_window-header, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_ubuntu_topbar, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_ubuntu_tools, .ays-pb-modal_".$id." .ays_winxp_title-bar, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_win98_head, .ays-pb-modal_".$id." .ays_cmd_window-header, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_cmd_window-cursor, .ays-pb-modals.av_pop_modals_".$id." .ays-pb-modal_".$id." .ays_ubuntu_folder-info.ays_pb_timer_".$id.", .ays_cmd_window-content .ays_pb_timer.ays_pb_timer_".$id."{
                            ".$position_absolute_popup_scroll."
                            ".$width_popup_scroll."
                                                     
                        }

                        .ays-pb-modal_".$id." .ays_pb_yes_or_no_live_buttons{
                            ".$col_direction."
                        }
                        .ays-pb-modal_".$id." .ays_pb_yes_or_no_live_btn2{
                            ".$col_direction_margin."
                        }
                    </style>";

            if ( $dismiss_closing && is_user_logged_in()){
            
                $popupbox_view[] .= "<script>
                                        (function($) {
                                            'use strict';
                                            $(document).ready(function() {
                                                jQuery(document).find('.ays-pb-modal-close_".$id."').on('click',function(){
                                                    set_cookies('ays_pb_dismiss_closing_accept_cookie_".$id."', 'ays_pb_dismiss_closing_accept_cookie_".$id."', 10*365*24*60*60*1000);
                                                });
                                            });
                                        })(jQuery);
                                    </script>";
            }

            if ( $popupbox['view_type'] == 'winXP' && $popup_enable_lazy_loading && $bgImageStylesToAppend != '') {
                $popupbox_view[] .= "<script>
                                    (function($) {
                                        'use strict';
                                        $(document).ready(function() {
                                            var styleTag = $('<style>');
                                            styleTag.text(`" . $bgImageStylesToAppend . "`);
                                            $('head').append(styleTag);
                                        });
                                    })(jQuery);
                                   </script>";
            }

            switch ( $ays_pb_yes_button_action ){
                case "closePopup":
                    $popupbox_view[] .= "<script>
                                            (function($) {
                                                'use strict';
                                                $(document).ready(function() {
                                                    jQuery(document).find('.ays_pb_yes_or_no_live_btn1').on('click',function(){
                                                        var lastClass = this.classList[this.classList.length - 1];
                                                        if(lastClass.endsWith('-' + ".$id.")) {
                                                            jQuery('.ays-pb-modal-close_".$id."').trigger('click');
                                                        }
                                                    });
                                                });
                                            })(jQuery);
                                    </script>";
                    break;
                case "redirection":
                    if (wp_http_validate_url($ays_pb_yes_btn_redirect_url)){

                        if($yes_redirect_another_tab){
                            $popupbox_view[] .= "<script>
                                                    (function($) {
                                                        'use strict';
                                                        $(document).ready(function() {
                                                            jQuery(document).find('.ays_pb_yes_or_no_live_btn1').on('click',function(){
                                                                window.open( '{$ays_pb_yes_btn_redirect_url}', '_blank' );
                                                            });
                                                        });
                                                    })(jQuery);
                                                </script>";
                        }else{
                            $popupbox_view[] .= "<script>
                                                    (function($) {
                                                        'use strict';
                                                        $(document).ready(function() {
                                                            jQuery(document).find('.ays_pb_yes_or_no_live_btn1').on('click',function(){
                                                                window.location.href = '{$ays_pb_yes_btn_redirect_url}';
                                                            });
                                                        });
                                                    })(jQuery);
                                        </script>";
                        }
                    }else{
                        $popupbox_view[] .= "<script>
                                                (function($) {
                                                    'use strict';
                                                    $(document).ready(function() {
                                                        jQuery(document).find('.ays_pb_yes_or_no_live_btn1').on('click',function(){
                                                            window.location.reload();
                                                        });
                                                    });
                                                })(jQuery); 
                                            </script>";
                    }
                    break;
                default:
                $popupbox_view[] .= "<script>
                                        (function($) {
                                            'use strict';
                                            $(document).ready(function() {
                                                jQuery(document).find('.ays_pb_yes_or_no_live_btn1').on('click',function(){
                                                    var lastClass = this.classList[this.classList.length - 1];
                                                    if(lastClass.endsWith('-' + ".$id.")) {
                                                        jQuery('.ays-pb-modal-close_".$id."').trigger('click');
                                                    }
                                                });
                                            });
                                        })(jQuery);
                                    </script>";
                    break;
            }                

            switch ( $ays_pb_no_button_action ){

                case "closePopup":
                    $popupbox_view[] .= "<script>
                                            (function($) {
                                                'use strict';
                                                $(document).ready(function() {
                                                    jQuery(document).find('.ays_pb_yes_or_no_live_btn2').on('click',function(){
                                                        var lastClass = this.classList[this.classList.length - 1];
                                                        if(lastClass.endsWith('-' + ".$id.")) {
                                                            jQuery('.ays-pb-modal-close_".$id."').trigger('click');
                                                        }
                                                    });
                                                });
                                            })(jQuery);
                                        </script>";
                    break;
                case "redirection":
                if (wp_http_validate_url($ays_pb_no_btn_redirect_url)){
                    if($no_redirect_another_tab){
                            $popupbox_view[] .= "<script>
                                                    (function($) {
                                                        'use strict';
                                                        $(document).ready(function() {
                                                            jQuery(document).find('.ays_pb_yes_or_no_live_btn2').on('click',function(){
                                                                window.open( '{$ays_pb_no_btn_redirect_url}', '_blank' );
                                                            });
                                                        });
                                                    })(jQuery);
                                                </script>";
                    }else{
                        $popupbox_view[] .= "<script>
                                                (function($) {
                                                    'use strict';
                                                    $(document).ready(function() {
                                                        jQuery(document).find('.ays_pb_yes_or_no_live_btn2').on('click',function(){
                                                            window.location.href = '{$ays_pb_no_btn_redirect_url}';
                                                        });
                                                    });
                                                })(jQuery);
                                            </script>";
                    }
                    }else{
                        $popupbox_view[] .= "<script>
                                                (function($) {
                                                    'use strict';
                                                    $(document).ready(function() {
                                                        jQuery(document).find('.ays_pb_yes_or_no_live_btn2').on('click',function(){
                                                            window.location.reload();
                                                        });
                                                    });
                                                })(jQuery);
                                            </script>";
                    }
                    break;
                default:
                $popupbox_view[] .= "<script>
                                        (function($) {
                                            'use strict';
                                            $(document).ready(function() {
                                                jQuery(document).find('.ays_pb_yes_or_no_live_btn2').on('click',function(){
                                                    var lastClass = this.classList[this.classList.length - 1];
                                                    if(lastClass.endsWith('-' + ".$id.")) {
                                                        jQuery('.ays-pb-modal-close_".$id."').trigger('click');
                                                    }
                                                });
                                            });
                                        })(jQuery);
                                    </script>";
                    break;
            }

            if ( !$enable_pb_fullscreen ) {

                $iscloseButtonOff = $closeButton != 'on' ? true : false;

                $popupbox_view[] .= "<script>";
                if($enable_pb_position_mobile) {
                    $popupbox_view[] .= "if (window.innerWidth < 768) { "
                                            . $this->setPopupPosition($id, $ays_pb_position_mobile, $popupbox['view_type'], $iscloseButtonOff, $ays_pb_margin, $mobile_height) .
                                        " } else { "
                                            . $this->setPopupPosition($id, $ays_pb_position, $popupbox['view_type'], $iscloseButtonOff, $ays_pb_margin, $pb_height_no_px) .
                                        " }";
                } else {
                    $popupbox_view[] .= "if (window.innerWidth < 768) { "
                                            . $this->setPopupPosition($id, $ays_pb_position, $popupbox['view_type'], $iscloseButtonOff, $ays_pb_margin, $mobile_height) .
                                        " } else { "
                                            . $this->setPopupPosition($id, $ays_pb_position, $popupbox['view_type'], $iscloseButtonOff, $ays_pb_margin, $pb_height_no_px) .
                                        " }";
                }
                $popupbox_view[] .= "</script>";

            }

            if( $popupbox['action_button_type'] != 'exitIntent' ){

                //On page load
                if( $popupbox['action_button_type'] != 'clickSelector' && $popupbox['action_button_type'] != 'hover' && $popupbox['action_button_type'] != 'inactivity' && $popupbox['action_button_type'] != 'xpagevisiting' && $popupbox['action_button_type'] != 'scrollingtoelement'){
                    $popupbox_view['popupbox_end_script_1'] = "
                        <script>
                        (function( $ ) {
                            'use strict';
                            $(document).ready(function(){
                                $(document).find('.ays-pb-modals').appendTo($(document.body));
                                let isMobile = false;
                                let closePopupOverlay = " . $close_popup_overlay_flag . ";
                                if (window.innerWidth < 768) {
                                    isMobile = true;
                                    closePopupOverlay = " . $close_popup_overlay_mobile_flag . ";
                                }
                                let ays_pb_delayOpen_".$id." = parseInt($(document).find('.ays_pb_delay_".$id."').val());
                                let ays_pb_scrollTop_".$id." = parseInt($(document).find('.ays_pb_scroll_".$id."').val());
                                let ays_pb_close_btn_delay".$id." = " . $close_button_delay . ";
                                let ays_pb_autoclose_delay".$id."= " . $ays_pb_autoclose . ";
                                if (isMobile) {
                                    ays_pb_autoclose_delay".$id." = " . $pb_autoclose_mobile . ";

                                    if (" . $enable_scroll_top_mobile . ") {
                                        ays_pb_scrollTop_".$id."= parseInt($(document).find('.ays_pb_scroll_mobile_".$id."').val());
                                    }
                                    if (" . $enable_open_delay_mobile . ") {
                                        ays_pb_delayOpen_".$id." = parseInt($(document).find('.ays_pb_delay_mobile_".$id."').val());
                                    }
                                    if (" . $enable_close_button_delay_for_mobile . ") {
                                        ays_pb_close_btn_delay".$id." = " . $close_button_delay_for_mobile . ";
                                    }
                                }
                                let ays_pb_scrollTop_type".$id." = $(document).find('.ays_pb_scroll_".$id."').data('type'),
                                    time_pb_".$id." = $(document).find('.ays_pb_timer_".$id." span').data('seconds'),
                                    ays_pb_effectIn_".$id." = $(document).find('#ays_pb_modal_animate_in_".$id."').val(),
                                    ays_pb_animation_close_speed = $(document).find('#ays_pb_animation_close_speed_".$id."').val(),
                                    ays_pb_close_by_scroll_down_".$id." = parseInt($(document).find('.close_pb_by_scroll_down_".$id."').val()),
                                    ays_pb_animation_close_seconds = (ays_pb_animation_close_speed / 1000),
                                    countdownBox = $(document).find('.ays-pb-countdown-container-".$id."');
                                    ays_pb_animation_close_speed = parseFloat(ays_pb_animation_close_speed) - 50;
                                var currentdate = new Date();
                                var startDate = getCurrentTime ( currentdate );
                                if( ays_pb_delayOpen_".$id." == 0 &&  ays_pb_scrollTop_".$id." == 0){
                                    $(document).find('.av_pop_modals_".$id."').css('display','block');
                                }

                                if (window.innerWidth < 768) {
                                    var mobileTimer = +$(document).find('.ays_pb_timer_".$id." span').attr('data-ays-mobile-seconds');
                                    $(document).find('.ays_pb_timer_".$id." span').html(mobileTimer);
                                    time_pb_".$id." = mobileTimer;
                                }
    
                                var data = {};
                                var action = 'pb_used_coupons';
                                var usedCoupon = $(document).find('.ays-pb-modal_".$id."').find('div.ays_pb_coupon_container').children('div.ays_pb_coupon_type').find('p').text();  
                                data.action = action;
                                data.used_coupon = usedCoupon;
                                
                                data.action = action;
                                data.id = {$id};
                                data.used_coupon = usedCoupon;
                                $.ajax({
                                    url: pb_public.ajax,
                                    method: 'POST',
                                    dataType: 'text',
                                    data: data,
                                    success: function(response) {
                                    }
                                });
                                if(time_pb_".$id." !== undefined){
                                    if(time_pb_".$id." !== 0){
                                        var type = $(document).find('.av_pop_modals_".$id."').find('input#ays_pb_view_type_".$id."').data('type');
                                        $(document).find('#ays-pb-modal-checkbox_".$id."').trigger('click');
                                        if(ays_pb_scrollTop_".$id." == 0){
                                            $(document).find('.ays-pb-modal_".$id."').css({
                                                'animation-duration': ays_pb_animation_close_seconds + 's'
                                            });
                                            $(document).find('.ays-pb-modal_".$id."').css({
                                                'animation-duration': ays_pb_animation_close_seconds + 's'
                                            });
                                            setTimeout(function(){
                                                let timer_pb_".$id." = setInterval(function(){
                                                    let newTime_pb_".$id." = time_pb_".$id."--;
                                                    let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();
                                                    $(document).find('.ays_pb_timer_".$id." span').text(newTime_pb_".$id.");
                                                    if(newTime_pb_".$id." <= 0){
                                                        $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                        $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                        if(ays_pb_effectOut_".$id." != 'none'){
                                                            setTimeout(function(){ 
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                            }, ays_pb_animation_close_speed);
                                                        }else{
                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                        }
                                                        $modal_close_additional_js
                                                        clearInterval(timer_pb_".$id.");
                                                    }
                                                    $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){                                        
                                                        $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                        $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                        $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                            var key = /https:\/\/www.youtube.com/;
                                                            var src = $(this).attr('src');
                                                            if(typeof src != 'undefined'){
                                                                $(this).removeAttr('src');
                                                                $(this).attr('src',src);
                                                            }
                                                        });
                                                        $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                            if(typeof $(this).get(0) != 'undefined'){
                                                                if ( ! $(this).get(0).paused ) {
                                                                    $(this).get(0).pause();
                                                                    $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                                }
    
                                                            }
                                                        });
                                                        $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                            if(typeof $(this).get(0) != 'undefined'){
                                                                if ( ! $(this).get(0).paused ) {
                                                                    $(this).get(0).pause();
                                                                }
    
                                                            }
                                                        });
                                                        var close_sound_src = $(document).find('#ays_pb_close_sound_".$id."').attr('src');
                                                        if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                            if('".$ays_pb_check_anim_speed."' !== 0){
                                                                var playPromise = $(document).find('#ays_pb_close_sound_".$id."').get(0).play();
                                                                if (playPromise !== undefined) {
                                                                    playPromise.then(function() {
                                                                        audio.pause();
                                                                    }).catch(function(error) {
                                                                        
                                                                    });
                                                                }
                                                            }
                                                        }
                                                        if(ays_pb_effectOut_".$id." != 'none'){
                                                            setTimeout(function(){
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                if($('#ays_pb_close_sound_".$id."').get(0) != undefined){
                                                                    if(!$('#ays_pb_close_sound_".$id."').get(0).paused){
                                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                        var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                        audio.pause();
                                                                        audio.currentTime = 0;
                                                                    }
                                                                }
                                                            }, ays_pb_animation_close_speed);  
                                                        }else{
                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                            $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                            if($('#ays_pb_close_sound_".$id."').get(0) != undefined){
                                                                if(!$('#ays_pb_close_sound_".$id."').get(0).paused){
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                    audio.pause();
                                                                    audio.currentTime = 0;
                                                                }
                                                            } 
                                                        }
                                                        $modal_close_additional_js
                                                        $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                        clearInterval(timer_pb_".$id.");
                                                    });
                                                    var ays_pb_flag =  true;
                                                    $(document).on('keydown', function(event) { 
                                                        if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                            if (event.keyCode == 27) {        
                                                                $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                ays_pb_flag = false;
                                                            } 
                                                        }
                                                    });
                                                    
                                                },1000); 
                                            },ays_pb_delayOpen_".$id.");
                                        }
                                        if(closePopupOverlay && '". $popupbox['onoffoverlay'] ."' == 'on'){
                                            $(document).find('.av_pop_modals_".$id."').on('click', function(e) {
                                                var pb_parent = $(this);
                                                var pb_div = $(this).find('.ays-pb-modal_".$id."');
                                                if (!pb_div.is(e.target) && pb_div.has(e.target).length === 0){
                                                    $(document).find('.ays-pb-modal-close_".$id."').click();
                                                }
                                            });
                                        }
    
                                        if('".$enable_content_click_flag."'){
                                            $('.ays-pb-modal_".$id."').one('click',function(e){
                                                var redirect_url = $(document).find('.redirect_url_".$id."').val();
                                                var closeButtonDiv = $(document).find('.ays-pb-modal-close_".$id."');
                                        
                                                if (!closeButtonDiv.is(e.target) && closeButtonDiv.has(e.target).length === 0){
                                                    if('".$enable_redirect_content_click_flag."' && '".$enable_new_tab_content_click_flag."'){
                                                        window.open(redirect_url);
                                                    }else if('".$enable_redirect_content_click_flag."'){
                                                        window.open(redirect_url,'_self');
                                                    }
                                                    if('".$enable_close_content_flag."'){
                                                        $(document).find('.ays-pb-modal-close_".$id."').click();
                                                    }
                                                }
                                            })
                                        }
                                            
                                    } else {
                                         $(document).find('.ays_pb_timer_".$id."').css('display','none');
                                         $(document).find('.ays-pb-modal_".$id."').css({
                                            'animation-duration': ays_pb_animation_close_seconds + 's'
                                         }); 
                                        
                                        if('".$enable_content_click_flag."'){
                                            $('.ays-pb-modal_".$id."').one('click',function(e){
                                                var closeButtonDiv  = $(document).find('.ays-pb-modal-close_".$id."');
    
                                                if (!closeButtonDiv .is(e.target) && closeButtonDiv .has(e.target).length === 0){
    
                                                var redirect_url = $(document).find('.redirect_url_".$id."').val();
                                               
                                                    if('".$enable_redirect_content_click_flag."' && '".$enable_new_tab_content_click_flag."'){
                                                        window.open(redirect_url);
                                                    }else if('".$enable_redirect_content_click_flag."'){
                                                        window.open(redirect_url,'_self');
                                                    }
                                                    if('".$enable_close_content_flag."'){
                                                        $(document).find('.ays-pb-modal-close_".$id."').click();
                                                    }
                                                }
                                            })
                                        }
                                            
                                         
                                       
                                         $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){  
                                            let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();                                      
                                            $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                            $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                            $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                var key = /https:\/\/www.youtube.com/;
                                                var src = $(this).attr('src');
                                                if(typeof src != 'undefined'){
                                                    $(this).removeAttr('src');
                                                    $(this).attr('src',src);
                                                }
                                            });
                                            $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                if(typeof $(this).get(0) != 'undefined'){
                                                    if ( ! $(this).get(0).paused ) {
                                                        $(this).get(0).pause();
                                                        $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                    }
    
                                                }
                                            });
                                            $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                if(typeof $(this).get(0) != 'undefined'){
                                                    if ( ! $(this).get(0).paused ) {
                                                        $(this).get(0).pause();
                                                    }
    
                                                }
                                            });
                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                setTimeout(function(){
                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                    $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                    $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                }, ays_pb_animation_close_speed);  
                                            }else{
                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                            }
                                            $modal_close_additional_js
                                            $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                         });
                                    }
                                }
                                let count = 0;
                                if( ays_pb_scrollTop_".$id." !== 0 ){
                                    if(ays_pb_scrollTop_type".$id." = 'percentage'){
                                        ays_pb_scrollTop_".$id." = ( $(window).height() / 100 ) * ays_pb_scrollTop_".$id.";
                                    }
                                    $(window).scroll(function() {
                                        if(($(this).scrollTop() >= ays_pb_scrollTop_".$id.") && (count === 0)) {
                                            count++;
                                            if( ays_pb_delayOpen_".$id." !== 0 ){                        
                                                $(document).find('.ays-pb-modal_".$id."').css('animation-delay', ays_pb_delayOpen_".$id."/1000);
                                                setTimeout(function(){
                                                    $(document).find('.av_pop_modals_".$id."').css('display','block');
                                                    $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                                    if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                                    $(document).find('.ays-pb-modal-check_".$id."').prop('checked', true);
                                                }, ays_pb_delayOpen_".$id.");
                                            }else{
                                                $(document).find('.av_pop_modals_".$id."').css('display','block');
                                                $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                                if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                                $(document).find('.ays-pb-modal-check_".$id."').prop('checked', true);
                                            }
                                            if (ays_pb_close_btn_delay".$id." != 0 && '".$closeButton."' != 'on') {
                                                let close_button_delay = ays_pb_close_btn_delay".$id.";
                                                if (ays_pb_delayOpen_".$id." != 0) {
                                                   close_button_delay += Math.floor(ays_pb_delayOpen_".$id.");
                                                }
                                                $(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'none'});
                                                
                                                setTimeout(function(){ 
                                                    $(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'block'});
                                                    $(document).find('.ays-pb-modal_".$id." .ays_coral_btn_close.ays-pb-close-button-delay').css({'display': 'flex'});
                                                    $(document).find('.ays-pb-modal_".$id." .ays_cmd_control-item.ays-pb-close-button-delay').css({'display': 'inline-block'});
                                                }, close_button_delay );
                                            }
                                            if(ays_pb_autoclose_delay".$id." != 0){
                                                $(document).find('.ays-pb-modal_".$id."').css({
                                                    'animation-duration': ays_pb_animation_close_seconds + 's'
                                                });
                                                setTimeout(function(){
                                                    let timer_pb_".$id." = setInterval(function(){
                                                        let newTime_pb_".$id." = time_pb_".$id."--;
                                                        let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();
                                                        $(document).find('.ays_pb_timer_".$id." span').text(newTime_pb_".$id.");
                                                        if(newTime_pb_".$id." <= 0){
                                                            $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                setTimeout(function(){ 
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                }, ays_pb_animation_close_speed);
                                                            }else{
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                            }
                                                            $modal_close_additional_js
                                                            clearInterval(timer_pb_".$id.");
                                                        }
                                                        $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){                     
                                                            $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                            $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                                var key = /https:\/\/www.youtube.com/;
                                                                var src = $(this).attr('src');
                                                                if(typeof src != 'undefined'){
                                                                    $(this).removeAttr('src');
                                                                    $(this).attr('src',src);
                                                                }
                                                            });
                                                            $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                                if(typeof $(this).get(0) != 'undefined'){
                                                                    if ( ! $(this).get(0).paused ) {
                                                                        $(this).get(0).pause();
                                                                        $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                                    }
    
                                                                }
                                                            });
                                                            $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                                if(typeof $(this).get(0) != 'undefined'){
                                                                    if ( ! $(this).get(0).paused ) {
                                                                        $(this).get(0).pause();
                                                                    }
    
                                                                }
                                                            });
                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                setTimeout(function(){
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                    $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                }, ays_pb_animation_close_speed);  
                                                            }else{
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                            }
                                                            $modal_close_additional_js
                                                            $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                            clearInterval(timer_pb_".$id.");
                                                        });
                                                        var ays_pb_flag = true;
                                                        $(document).on('keydown', function(event) { 
                                                            if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                                if (event.keyCode == 27) {                                    
                                                                    $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                    ays_pb_flag = false;
                                                                } 
                                                            }
                                                        });
    
                                                    },1000);
                                                },ays_pb_delayOpen_".$id.");
                                            }
                                        }
                                    });
                                }else{
                                    if( ays_pb_delayOpen_".$id." !== 0 ){
                                        $(document).find('.ays-pb-modal_".$id."').css('animation-delay', ays_pb_delayOpen_".$id."/1000);
                                        setTimeout(function(){
                                            $(document).find('.av_pop_modals_".$id."').css('display','block');
                                            $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                            if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                            $(document).find('.ays-pb-modal-check_".$id."').attr('checked', 'checked');
    
                                            if('".$popupbox['disable_scroll']."'){
                                                $(document).find('body').removeClass('pb_enable_scroll');
                                                $(document).find('body').addClass('pb_disable_scroll'); 
    
                                                $(document).find('html').removeClass('pb_enable_scroll');
                                                $(document).find('html').addClass('pb_disable_scroll');   
                                               
                                            }
    
                                        }, ays_pb_delayOpen_".$id.");
                                    } else {
                                        if($(document).find('.ays_pb_abt_".$id."').val() != 'clickSelector'){
                                            $(document).find('.av_pop_modals_".$id."').css('display','block');
                                            $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                            if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                            $(document).find('.ays-pb-modal-check_".$id."').attr('checked', 'checked');
    
                                            if('".$popupbox['disable_scroll']."'){
                                                $(document).find('body').removeClass('pb_enable_scroll');
                                                $(document).find('body').addClass('pb_disable_scroll'); 
    
                                                $(document).find('html').removeClass('pb_enable_scroll');
                                                $(document).find('html').addClass('pb_disable_scroll');   
                                               
                                            }
                                        }
                                    }
                                }
                                if ('".$popupbox['onoffoverlay']."' != 'on'){
                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none !important', 'pointer-events': 'none', 'background': 'none'});
                                    $(document).find('.ays-pb-modal_".$id."').css('pointer-events', 'auto');
                                    $(document).find('.av_pop_modals_".$id."').css('pointer-events','none');
                                };
                                if('".$popupbox['action_button_type']."' == 'pageLoaded' || '".$popupbox['action_button_type']."' == 'both'){
                                    $(document).one('click' ,'.ays-pb-modal-close_".$id."', function() {  
                                        var pb_id = ".$id.";
                                        var d = new Date(); 
                                        var endDate = getCurrentTime ( d ); 
                                        var duration = Math.floor( (d - currentdate) / 1000);
                                        $.ajax({
                                            url: pb_public.ajax,
                                            method: 'POST',
                                            dataType: 'text',
                                            data: {
                                                status   : true,
                                                action   : 'ays_pb_add_reports',
                                                id       : pb_id,
                                                startDate: startDate,
                                                endDate  : endDate,
                                                duration : duration
                                            },
                                        });
                                    }); 
                                };
                                if($(document).find('.ays-pb-modals video').hasClass('wp-video-shortcode')){
                                    var videoWidth  = $(document).find('.ays-pb-modals video.wp-video-shortcode').attr('width');
                                    var videoHeight = $(document).find('.ays-pb-modals video.wp-video-shortcode').attr('height');
                                    setTimeout(function(){
                                        $(document).find('.ays-pb-modals .wp-video').removeAttr('style');
                                        $(document).find('.ays-pb-modals .mejs-container').removeAttr('style');
                                        $(document).find('.ays-pb-modals video.wp-video-shortcode').removeAttr('style');
    
                                        $(document).find('.ays-pb-modals .wp-video').css({'width': '100%'});
                                        $(document).find('.ays-pb-modals .mejs-container').css({'width': '100%','height': videoHeight + 'px'});
                                        $(document).find('.ays-pb-modals video.wp-video-shortcode').css({'width': '100%','height': videoHeight + 'px'});
                                    },1000);
                                }
                                if($(document).find('.ays-pb-modals iframe').attr('style') != ''){
                                    setTimeout(function(){
                                        $(document).find('.ays-pb-modals iframe').removeAttr('style');
                                    },500);
                                }
                                if(ays_pb_close_by_scroll_down_".$id." !== 0){
                                    $(window).scroll(function() {
                                        if($(this).scrollTop() == ays_pb_close_by_scroll_down_".$id."){ 
                                            if($(document).find('.ays-pb-modal_".$id."').css('display') != 'none'){
                                                $(document).find('.ays-pb-modal-close_".$id."').click();
                                                    var close_sound_src = $(document).find('#ays_pb_close_sound_".$id."').attr('src');
                                                    if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                        if('".$ays_pb_check_anim_speed."' !== 0){
                                                            var playPromise = $(document).find('#ays_pb_close_sound_".$id."').get(0).play();
                                                            if (playPromise !== undefined) {
                                                                playPromise.then(function() {
                                                                    audio.pause();
                                                                }).catch(function(error) {
                                                                    
                                                                });
                                                            }
                                                        }
                                                    }
                                            }
                                        }
                                        
                                    })
                                }
                                if('".$close_popup_by_classname_flag."'){
                                   if($('.".$popupbox['close_by_classname_'.$id]."').length){
                                        $('.".$popupbox['close_by_classname_'.$id]."').click(function(){
                                            $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                        })
                                    }
                                }
                                // if(".$popupbox['ays_pb_autoclose']." == 0){
                                    if(closePopupOverlay && '".$popupbox['onoffoverlay']."' == 'on'){
                                        $(document).find('.av_pop_modals_".$id."').on('click', function(e) {
                                            var pb_parent = $(this);
                                            var pb_div = $(this).find('.ays-pb-modal_".$id."');
                                            if (!pb_div.is(e.target) && pb_div.has(e.target).length === 0){
                                                $(document).find('.ays-pb-modal-close_".$id."').click();
                                            }
                                        });
                                    }
                                    var ays_pb_flag = true;
                                    $(document).on('keydown', function(event) { 
                                        if('".$close_popup_esc_flag."' && ays_pb_flag){
                                            if (event.keyCode == 27) {                                    
                                                $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                ays_pb_flag = false;
                                            } 
                                        }
                                    });
                                // }
                                if('".$popupbox['enable_autoclose_on_completion']."' == 'on') {
                                    var video = $(document).find('video.wp-video-shortcode');
                                    for (let i = 0; i < video.length; i++) {
                                        video[i].addEventListener('ended', function() {
                                            if ($(this).next().val() === 'on') {
                                                $(this).parents('.ays_video_window').find('.close-video-btn').trigger('click');
                                            }
                                        });
                                    }
                                }
    
                                jQuery(document).on('click', '.ays-pb-modal-close_".$id."', function() {
                                                    $(document).find('body').removeClass('pb_disable_scroll');
                                                    $(document).find('body').addClass('pb_enable_scroll');
    
                                                    $(document).find('html').removeClass('pb_disable_scroll');
                                                    $(document).find('html').addClass('pb_enable_scroll');
                                });
                                if(typeof countdownBox != 'undefined' && countdownBox.length > 0){
                                    
                                        var second  = 1000,
                                            minute  = second * 60,
                                            hour    = minute * 60,
                                            day     = hour * 24;
                                
                                        
                                        var countDown = new Date('".$countdown_date_format."').getTime();
                                        var countDownDays    = document.getElementById('ays-pb-countdown-days-".$id."');
                                        var countDownHours   = document.getElementById('ays-pb-countdown-hours-".$id."');
                                        var countDownMinutes = document.getElementById('ays-pb-countdown-minutes-".$id."');
                                        var countDownSeconds = document.getElementById('ays-pb-countdown-seconds-".$id."');
                                    
                                        var countdownTimer = setInterval(function() {
                                            countdownBox.removeClass('display_none');
                                            var now = new Date().getTime(),
                                            distance = countDown - now;
                                
                                                if(countDownDays !== null || countDownHours !== null || countDownMinutes !== null || countDownSeconds !== null){
                                                    countDownDays.innerText = Math.floor(distance / (day)),
                                                    countDownHours.innerText = Math.floor((distance % (day)) / (hour)),
                                                    countDownMinutes.innerText = Math.floor((distance % (hour)) / (minute)),
                                                    countDownSeconds.innerText = Math.floor((distance % (minute)) / second);
                                                }
                                                
                                            //do something later when date is reached
                                            if (distance < 0) {
                                                $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                            //     var headline  = document.getElementById('ays-pb-countdown-headline'),
                                            //         countdownBox = document.getElementById('ays-pb-countdown'),
                                            //         content   = document.getElementById('ays-pb-countdown-content');
                                
                                            //     // headline.innerText = 'Sale is over!';
                                                    countdownBox.hide();
                                            //     content.style.display = 'block';
                                
                                                clearInterval(countdownTimer);
                                            }
                                        }, 1000);
                                    
                            
                                }   
                            });
                        })( jQuery );
                    </script>";
                }
                
                //Click and Hover trigger
                if( $popupbox['action_button_type'] != 'pageLoaded' && $popupbox['action_button_type'] != 'inactivity' && $popupbox['action_button_type'] != 'xpagevisiting' && $popupbox['action_button_type'] != 'scrollingtoelement'){
                    if($show_only_once){
                        $cl = 'one';
                    }else{
                        $cl = 'on';
                    }

                    $popupbox_view['popupbox_end_script_2'] = "                
                        <script>
                        (function( $ ) {
                            'use strict';
                                $(document).ready(function(){
                                    let isMobile = false;
                                    let closePopupOverlay = " . $close_popup_overlay_flag . ";
                                    if (window.innerWidth < 768) {
                                        isMobile = true;
                                        closePopupOverlay = " . $close_popup_overlay_mobile_flag . ";
                                    }
                                    var ays_flag = true;
                                    var show_only_once = '{$show_only_once}';
                                    let ays_pb_close_btn_delay".$id." = " . $close_button_delay . ";
                                    if (isMobile) {
                                        if (" . $enable_close_button_delay_for_mobile . ") {
                                            ays_pb_close_btn_delay".$id." = " . $close_button_delay_for_mobile . ";
                                        }
                                    }
                                    $(document).find('".$popupbox['action_button']."').".$cl."('".$ays_pb_action_button_type."', function(){
                                        var data = {};
                                        var action = 'pb_used_coupons';
                                        var usedCoupon = $(document).find('.ays-pb-modal_".$id."').find('div.ays_pb_coupon_container').children('div.ays_pb_coupon_type').find('p').text();  
                                        data.action = action;
                                        data.used_coupon = usedCoupon;
                                        data.action = action;
                                        data.id = {$id};
    
                                        $.ajax({
                                            url: pb_public.ajax,
                                            method: 'POST',
                                            dataType: 'text',
                                            data: data,
                                            success: function(response) {
                                            }
                                        });
    
                                        if(show_only_once){
                                            $.ajax({
                                                url: '".admin_url('admin-ajax.php')."',
                                                method: 'post',
                                                dataType: 'json',
                                                data: {
                                                    action: 'ays_pb_set_cookie_only_once',
                                                    id: ".$popupbox['id'].",
                                                    title: '".htmlentities($popupbox['title'],ENT_QUOTES)."',
                                                },
                                            });
                                        }
    
                                        var dataAttr = $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag');
                                        if(ays_flag && dataAttr == 'true'){
    
                                            ays_flag = false;
                                            $(document).find('.av_pop_modals_".$id."').css('display','block');
                                            $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'auto');
                                            if (window.innerWidth < 768) {
                                                $(document).find('.ays_pb_timer_".$id." span').html($(document).find('.ays_pb_timer_".$id." span').attr('data-ays-mobile-seconds'));
                                            }
                                            else{
                                                $(document).find('.ays_pb_timer_".$id." span').html($(document).find('.ays_pb_timer_".$id." span').attr('data-ays-seconds'));
                                            }            
                                            var type = $(document).find('.av_pop_modals_".$id."').find('input#ays_pb_view_type_".$id."').data('type');
                                            var currentdate = new Date();
                                            var startDate = getCurrentTime ( currentdate );
                                            clearInterval(timer_pb_".$id.");
                                            timer_pb_".$id." = null;
                                            $(document).find('.ays-pb-modal_".$id."').removeClass($(document).find('#ays_pb_modal_animate_out_".$id."').val());
                                            $(document).find('.ays-pb-modal_".$id."').addClass($(document).find('#ays_pb_modal_animate_in_".$id."').val());
                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                            $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."', 'display': 'block'});
                                            $(document).find('.ays-pb-modal-check_".$id."').prop('checked', true);
                                            $(document).find('.ays-pb-modal-check_".$id."').attr('checked', true);
                                            // $(document).find('#ays-pb-modal-checkbox_".$id."').trigger('click');
    
                                            var ays_pb_animation_close_speed = $(document).find('#ays_pb_animation_close_speed_".$id."').val();
                                            var ays_pb_animation_close_seconds = parseFloat(ays_pb_animation_close_speed / 50);
                                            ays_pb_animation_close_speed = parseFloat(ays_pb_animation_close_speed) - 50;
                                            var sound_src = $(document).find('#ays_pb_sound_".$id."').attr('src');
                                            if ('". $ays_pb_check_sound ."' === 'on' && typeof sound_src !== 'undefined'){
                                                $('#ays_pb_sound_".$id."').get(0).play();
                                                $(document).find('.ays_pb_pause_sound_".$id."').on('click',function(){
                                                    var audio = $('#ays_pb_sound_".$id."').get(0);
                                                    audio.pause();
                                                    audio.currentTime = 0;
                                                });
    
                                            }
                                            var close_sound_src = $(document).find('#ays_pb_close_sound_".$id."').attr('src');
                                            if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                if('".$ays_pb_check_anim_speed."' !== 0){
                                                    $(document).find('.ays_pb_pause_sound_".$id."').on('click',function(){
                                                        $('#ays_pb_close_sound_".$id."').get(0).play();
                                                        if(ays_pb_effectOut_".$id." != 'none'){
                                                            setTimeout(function(){
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                    audio.pause();
                                                                    audio.currentTime = 0;
                                                                    clearInterval(timer_pb_".$id.");
                                                            }, ays_pb_animation_close_speed);
                                                        }else{
                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                            var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                            audio.pause();
                                                            audio.currentTime = 0;
                                                            clearInterval(timer_pb_".$id.");
                                                        }
                                                    });
                                                }
                                            }
                                            var time_pb_".$id." = parseInt($(document).find('.ays_pb_timer_".$id." span').attr('data-ays-seconds'));
                                            if(time_pb_".$id." !== undefined){ 
                                                if(parseInt(time_pb_".$id.") !== 0){
                                                    var timer_pb_".$id." = setInterval(function(){
                                                        let newTime_pb_".$id." = time_pb_".$id."--;
                                                        let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();
                                                        $(document).find('.ays_pb_timer_".$id." span').text(newTime_pb_".$id.");
                                                        $(document).find('.ays-pb-modal_".$id."').css({
                                                            'animation-duration': ays_pb_animation_close_seconds + 's'
                                                        });
                                                        if(newTime_pb_".$id." <= 0){
                                                            $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ays-pb-modal_".$id." '+$(document).find('#ays_pb_modal_animate_out_".$id."').val());
                                                            $modal_close_additional_js
                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                setTimeout(function(){ 
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    ays_flag = true;
                                                                }, ays_pb_animation_close_speed);
                                                            }else{
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                ays_flag = true;
                                                            }   
                                                            if ('". $ays_pb_check_sound ."' === 'on' && typeof sound_src !== 'undefined'){
                                                                var audio = $('#ays_pb_sound_".$id."').get(0);
                                                                audio.pause();
                                                                audio.currentTime = 0;
                                                            }
                                                            clearInterval(timer_pb_".$id.");
                                                            if ('". $ays_pb_check_anim_speed ."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                                if('".$ays_pb_check_anim_speed."' !== 0){
                                                                    $('#ays_pb_close_sound_".$id."').get(0).play();
                                                                    if(ays_pb_effectOut_".$id." != 'none'){
                                                                        setTimeout(function(){
                                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                            ays_flag = true;
                                                                                var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                audio.pause();
                                                                                audio.currentTime = 0;
                                                                                clearInterval(timer_pb_".$id.");
                                                                        }, ays_pb_animation_close_speed);
                                                                    }else{
                                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                        ays_flag = true;
                                                                        var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                        audio.pause();
                                                                        audio.currentTime = 0;
                                                                        clearInterval(timer_pb_".$id.");
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){
                                                        $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                            $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                                var key = /https:\/\/www.youtube.com/;
                                                                var src = $(this).attr('src');
                                                                if(typeof src != 'undefined'){
                                                                    $(this).removeAttr('src');
                                                                    $(this).attr('src',src);
                                                                }
                                                            });
                                                            $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                                if(typeof $(this).get(0) != 'undefined'){
                                                                    if ( ! $(this).get(0).paused ) {
                                                                        $(this).get(0).pause();
                                                                        $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                                    }
    
                                                                }
                                                            });
                                                            $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                                if(typeof $(this).get(0) != 'undefined'){
                                                                    if ( ! $(this).get(0).paused ) {
                                                                        $(this).get(0).pause();
                                                                    }
    
                                                                }
                                                            });
                                                            $modal_close_additional_js
                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                setTimeout(function(){ 
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    ays_flag = true;
                                                                }, ays_pb_animation_close_speed);  
                                                            }else{
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                ays_flag = true;
                                                            }
                                                            $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                            clearInterval(timer_pb_".$id.");
                                                        });
                                                        var ays_pb_flag =  true;
                                                        $(document).on('keydown', function(event) { 
                                                            if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                                if (event.keyCode == 27) { 
                                                                    $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                    ays_pb_flag = false;
                                                                    if ('". $ays_pb_check_sound ."' === 'on' && typeof sound_src !== 'undefined'){
                                                                        var audio = $('#ays_pb_sound_".$id."').get(0);
                                                                        audio.pause();
                                                                        audio.currentTime = 0;
                                                                        clearInterval(timer_pb_".$id.");
                                                                    }
                                                                    if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                                        if('".$ays_pb_check_anim_speed."' !== 0){
                                                                            $('#ays_pb_close_sound_".$id."').get(0).play();
                                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                                setTimeout(function(){
                                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                    var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                    audio.pause();
                                                                                    audio.currentTime = 0;
                                                                                    clearInterval(timer_pb_".$id.");
                                                                                }, ays_pb_animation_close_speed);
                                                                            }else{
                                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                audio.pause();
                                                                                audio.currentTime = 0;
                                                                                clearInterval(timer_pb_".$id.");
                                                                            }
                                                                        }
                                                                    }
                                                                } 
                                                            }
                                                        });
                                                        if('".$enable_content_click_flag."'){
                                                            $('.ays-pb-modal_".$id."').one('click',function(e){
                                                                var redirect_url = $(document).find('.redirect_url_".$id."').val();
                                                                var closeButtonDiv = $(document).find('.ays-pb-modal-close_".$id."');
                                                    
                                                                if (!closeButtonDiv.is(e.target) && closeButtonDiv.has(e.target).length === 0){
                                                                    if('".$enable_redirect_content_click_flag."' && '".$enable_new_tab_content_click_flag."'){
                                                                        window.open(redirect_url);
                                                                    }else if('".$enable_redirect_content_click_flag."'){
                                                                        window.open(redirect_url,'_self');
                                                                    }
                                                                    if('".$enable_close_content_flag."'){
                                                                        $(document).find('.ays-pb-modal-close_".$id."').click();
                                                                    }
                                                                }
                                                            })
                                                        }
                                                    }, 1000);
                                                
                                                    if('".$popupbox['action_button_type']."' != 'both'){
                                                        if(closePopupOverlay && '".$popupbox['onoffoverlay']."' == 'on'){
                                                            $(document).find('#ays-pb-screen-shade_".$id."').on('click', function() {
                                                                var pb_parent_div = $(this).find('.ays-pb-modals');
                                                                var pb_div = $(this).parents('.ays-pb-modals').find('.ays-pb-modal_".$id."');
                                                                if (!pb_parent_div.is(pb_div) && pb_parent_div.has(pb_div).length === 0){
                                                                    $(document).find('.ays-pb-modal-close_".$id."').click();
                                                                    if ('". $ays_pb_check_sound ."' === 'on' && typeof sound_src !== 'undefined'){
                                                                        var audio = $('#ays_pb_sound_".$id."').get(0);
                                                                        audio.pause();
                                                                        audio.currentTime = 0;
                                                                    }
                                                                    if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                                        if('".$ays_pb_check_anim_speed."' !== 0){
                                                                            $('#ays_pb_close_sound_".$id."').get(0).play();
                                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                                setTimeout(function(){
                                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                        var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                        audio.pause();
                                                                                        audio.currentTime = 0;
                                                                                }, ays_pb_animation_close_speed);
                                                                            }else{
                                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                audio.pause();
                                                                                audio.currentTime = 0;
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }else{
                                                        if(closePopupOverlay && '".$popupbox['onoffoverlay']."' == 'on'){
                                                            $(document).find('.av_pop_modals_".$id."').on('click', function(e) {
                                                                var pb_parent_div = $(this);
                                                                var pb_div = $(this).find('.ays-pb-modal_".$id."');
                                                                if (!pb_div.is(e.target) && pb_div.has(e.target).length === 0){
                                                                    $(document).find('.ays-pb-modal-close_".$id."').click();
                                                                    if ('". $ays_pb_check_sound ."' === 'on' && typeof sound_src !== 'undefined'){
                                                                        var audio = $('#ays_pb_sound_".$id."').get(0);
                                                                        audio.pause();
                                                                        audio.currentTime = 0;
                                                                    }
                                                                    if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                                        if('".$ays_pb_check_anim_speed."' !== 0){
                                                                            $('#ays_pb_close_sound_".$id."').get(0).play();
                                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                                setTimeout(function(){
                                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                        var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                        audio.pause();
                                                                                        audio.currentTime = 0;
                                                                                        
                                                                                }, ays_pb_animation_close_speed);
                                                                            }else{
                                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                audio.pause();
                                                                                audio.currentTime = 0; 
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            });
                                                        }
                                                    }   
    
                                                } else {
                                                    $(document).find('.av_pop_modals_".$id."').css('inset', '');
                                                    $(document).find('.av_pop_modals_".$id."').css('aniamtion-duration', '');
                                                    $(document).find('.ays_pb_timer_".$id."').css('display','none');
    
                                                    if('".$enable_content_click_flag."'){
                                                        $('.ays-pb-modal_".$id."').one('click',function(e){
                                                            var closeButtonDiv = $(document).find('.ays-pb-modal-close_".$id."');
                                                            
                                                            if (!closeButtonDiv.is(e.target) && closeButtonDiv.has(e.target).length === 0){
                                                                var redirect_url = $(document).find('.redirect_url_".$id."').val();
                                                        
                                                                if('".$enable_redirect_content_click_flag."' && '".$enable_new_tab_content_click_flag."'){
                                                                    window.open(redirect_url);
                                                                }else if('".$enable_redirect_content_click_flag."'){
                                                                    window.open(redirect_url,'_self');
                                                                }
                                                                if('".$enable_close_content_flag."'){
                                                                    $(document).find('.ays-pb-modal-close_".$id."').click();
                                                                }
                                                            }
                                                        })
                                                    }
    
                                                    $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){ 
                                                        let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();                                      
                                                        $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                        $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                        $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                            var key = /https:\/\/www.youtube.com/;
                                                            var src = $(this).attr('src');
                                                            if(typeof src != 'undefined'){
                                                                $(this).removeAttr('src');
                                                                $(this).attr('src',src);
                                                            }
                                                        });
                                                        $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                            if(typeof $(this).get(0) != 'undefined'){
                                                                if ( ! $(this).get(0).paused ) {
                                                                    $(this).get(0).pause();
                                                                    $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                                }
    
                                                            }
                                                        });
                                                        $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                            if(typeof $(this).get(0) != 'undefined'){
                                                                if ( ! $(this).get(0).paused ) {
                                                                    $(this).get(0).pause();
                                                                }
    
                                                            }
                                                        });
                                                        if(ays_pb_effectOut_".$id." != 'none'){
                                                            setTimeout(function(){
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                ays_flag = true;
                                                            }, ays_pb_animation_close_speed);  
                                                        }else{
                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                            $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                            ays_flag = true;
                                                        }
                                                        $modal_close_additional_js
                                                        $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                    });
                                                    // if(".$popupbox['ays_pb_autoclose']." == 0){
                                                        if(closePopupOverlay && '".$popupbox['onoffoverlay']."' == 'on'){
                                                            $(document).find('.av_pop_modals_".$id."').on('click', function(e) {
                                                                var pb_parent = $(this);
                                                                var pb_div = $(this).find('.ays-pb-modal_".$id."');
                                                                if (!pb_div.is(e.target) && pb_div.has(e.target).length === 0){
                                                                    $(document).find('.ays-pb-modal-close_".$id."').click();
                                                                }
                                                            });
                                                        }
                                                        var ays_pb_flag = true;
                                                        $(document).on('keydown', function(event) { 
                                                            if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                                if (event.keyCode == 27) {                                    
                                                                    $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                    ays_pb_flag = false;
                                                                } 
                                                            }
                                                        });
                                                    // }
                                                    if('".$popupbox['enable_autoclose_on_completion']."' == 'on') {
                                                        var video = $(document).find('video.wp-video-shortcode');
                                                        for (let i = 0; i < video.length; i++) {
                                                            video[i].addEventListener('ended', function() {
                                                                if ($(this).next().val() === 'on') {
                                                                    $(this).parents('.ays_video_window').find('.close-video-btn').trigger('click');
                                                                }
                                                            });
                                                        }
                                                    }
                                                }
    
                                                if('".$popupbox['disable_scroll']."'){
                                                    $(document).find('body').removeClass('pb_enable_scroll');
                                                    $(document).find('body').addClass('pb_disable_scroll'); 
    
                                                    $(document).find('html').removeClass('pb_enable_scroll');
                                                    $(document).find('html').addClass('pb_disable_scroll');   
                                                    jQuery(document).on('click', '.ays-pb-modal-close_".$id."', function() {
                                                        $(document).find('body').removeClass('pb_disable_scroll');
                                                        $(document).find('body').addClass('pb_enable_scroll');
    
                                                        $(document).find('html').removeClass('pb_disable_scroll');
                                                        $(document).find('html').addClass('pb_enable_scroll');
                                                    });           
                                                }
    
                                            }
                                            if ('".$popupbox['onoffoverlay']."' != 'on'){
                                                $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none !important', 'pointer-events': 'none'});
                                                $(document).find('.ays-pb-modal_".$id."').css('pointer-events', 'auto');
                                                $(document).find('.av_pop_modals_".$id."').css('pointer-events','none');
                                            };
                                            if ( '".$popupbox['close_button_delay']."' != '0' && '".$closeButton."' != 'on') {
                                                $(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'none'});
                                                setTimeout(function(){ 
                                                    $(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'block'});
                                                    $(document).find('.ays-pb-modal_".$id." .ays_coral_btn_close.ays-pb-close-button-delay').css({'display': 'flex'});
                                                    $(document).find('.ays-pb-modal_".$id." .ays_cmd_control-item.ays-pb-close-button-delay').css({'display': 'inline-block'});
                                                },ays_pb_close_btn_delay".$id.");
                                            }
    
                                            if('".$popupbox['action_button_type']."' == 'clickSelector' || '".$popupbox['action_button_type']."' == 'both'){
                                                $(document).one('click' ,'.ays-pb-modal-close_".$id."', function() {  
                                                    var pb_id = ".$id.";
                                                    var d = new Date(); 
                                                    var endDate = getCurrentTime ( d ); 
                                                    var duration = Math.floor( (d - currentdate) / 1000);
                                                    $.ajax({
                                                        url: pb_public.ajax,
                                                        method: 'POST',
                                                        dataType: 'text',
                                                        data: {
                                                            status   : true,
                                                            action   : 'ays_pb_add_reports',
                                                            id       : pb_id,
                                                            startDate: startDate,
                                                            endDate  : endDate,
                                                            duration : duration
                                                        },
                                                    });
                                                }); 
                                            } 
                                            if('".$popupbox['action_button_type']."' != 'both'){
                                                if($(document).find('.ays-pb-modals video').hasClass('wp-video-shortcode')){
                                                    var videoWidth  = $(document).find('.ays-pb-modals video.wp-video-shortcode').attr('width');
                                                    var videoHeight = $(document).find('.ays-pb-modals video.wp-video-shortcode').attr('height');
                                                    setTimeout(function(){
                                                        $(document).find('.ays-pb-modals .wp-video').removeAttr('style');
                                                        $(document).find('.ays-pb-modals .mejs-container').removeAttr('style');
                                                        $(document).find('.ays-pb-modals video.wp-video-shortcode').removeAttr('style');
    
                                                        $(document).find('.ays-pb-modals .wp-video').css({'width': '100%'});
                                                        $(document).find('.ays-pb-modals .mejs-container').css({'width': '100%','height': videoHeight + 'px'});
                                                        $(document).find('.ays-pb-modals video.wp-video-shortcode').css({'width': '100%','height': videoHeight + 'px'});
                                                    },1000);
                                                }
                                                if($(document).find('.ays-pb-modals iframe').attr('style') != ''){
                                                    setTimeout(function(){
                                                        $(document).find('.ays-pb-modals iframe').removeAttr('style');
                                                    },500);
                                                }
                                            }
                                        }
    
                                        var countdownBox = $(document).find('.ays-pb-countdown-container-".$id."');
                                        if(typeof countdownBox != 'undefined' && countdownBox.length > 0){
                                            var second  = 1000,
                                                minute  = second * 60,
                                                hour    = minute * 60,
                                                day     = hour * 24;
                                    
                                            
                                            var countDown = new Date('".$countdown_date_format."').getTime();
                                            var countDownDays    = document.getElementById('ays-pb-countdown-days-".$id."');
                                            var countDownHours   = document.getElementById('ays-pb-countdown-hours-".$id."');
                                            var countDownMinutes = document.getElementById('ays-pb-countdown-minutes-".$id."');
                                            var countDownSeconds = document.getElementById('ays-pb-countdown-seconds-".$id."');
                                        
                                            var countdownTimer = setInterval(function() {
                                                countdownBox.removeClass('display_none');
                                                var now = new Date().getTime(),
                                                distance = countDown - now;
                                    
                                                    if(countDownDays !== null || countDownHours !== null || countDownMinutes !== null || countDownSeconds !== null){
                                                        countDownDays.innerText = Math.floor(distance / (day)),
                                                        countDownHours.innerText = Math.floor((distance % (day)) / (hour)),
                                                        countDownMinutes.innerText = Math.floor((distance % (hour)) / (minute)),
                                                        countDownSeconds.innerText = Math.floor((distance % (minute)) / second);
                                                    }
                                                    
                                                //do something later when date is reached
                                                if (distance < 0) {
                                                    $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                //     var headline  = document.getElementById('ays-pb-countdown-headline'),
                                                //         countdownBox = document.getElementById('ays-pb-countdown'),
                                                //         content   = document.getElementById('ays-pb-countdown-content');
                                    
                                                //     // headline.innerText = 'Sale is over!';
                                                        countdownBox.hide();
                                                //     content.style.display = 'block';
                                    
                                                    clearInterval(countdownTimer);
                                                }
                                            }, 1000);
                                        }
                                    });
                                    
                                    if ('".$popupbox['onoffoverlay']."' != 'on'){
                                        $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none !important', 'pointer-events': 'none'});
                                        $(document).find('.ays-pb-modal_".$id."').css('pointer-events', 'auto');
                                        $(document).find('.av_pop_modals_".$id."').css('pointer-events','none');
                                    };
                                    var sound_src = $(document).find('#ays_pb_sound_".$id."').attr('src');
                                    var close_sound_src = $(document).find('#ays_pb_close_sound_".$id."').attr('src');
                                    var ays_pb_close_by_scroll_down_".$id." = parseInt($(document).find('.close_pb_by_scroll_down_".$id."').val());
                                    var ays_pb_animation_close_speed = $(document).find('#ays_pb_animation_close_speed_".$id."').val();
                                    
                                    if(ays_pb_close_by_scroll_down_".$id." !== 0 && ays_flag){
                                        $(window).scroll(function() {
                                            if($(this).scrollTop() >= ays_pb_close_by_scroll_down_".$id."){  
                                                if($(document).find('.ays-pb-modal_".$id."').css('display') != 'none' && $(document).find('#ays-pb- -shade_".$id."').css('display') != 'none' ){
                                                    $(document).find('.ays-pb-modal-close_".$id."').click();
                                                    ays_flag = true;
                                                    if ('". $ays_pb_check_sound ."' === 'on' && typeof sound_src !== 'undefined'){
                                                        var audio = $('#ays_pb_sound_".$id."').get(0);
                                                        audio.pause();
                                                        audio.currentTime = 0;
                                                    }
                                                    if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                        if('".$ays_pb_check_anim_speed."' !== 0){
                                                            $('#ays_pb_close_sound_".$id."').get(0).play();
                                                            if(ays_pb_effectOut_".$id." != 'none'){
                                                                setTimeout(function(){
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                    audio.pause();
                                                                    audio.currentTime = 0;
                                                                }, ays_pb_animation_close_speed);
                                                            }else{
                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                audio.pause();
                                                                audio.currentTime = 0;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                            
                                        });
                                    }
    
                                    if('".$close_popup_by_classname_flag."'){
                                        if($('.".$popupbox['close_by_classname_'.$id]."').length){
                                            $('.".$popupbox['close_by_classname_'.$id]."').click(function(){
                                                $(document).find('.ays-pb-modal-close_".$id."').click();
                                            })
                                        }
                                    }
                                });  
                        })( jQuery );
                    </script>";
                }
            }
            else{
                //Exit Intent
                $popupbox_view['popupbox_end_script_5'] = "           
                    <script>
                        (function( $ ) {
                            'use strict';
                            $(document).ready(function(){ 
                                let isMobile = false;
                                let closePopupOverlay = " . $close_popup_overlay_flag . ";
                                if (window.innerWidth < 768) {
                                    isMobile = true;
                                    closePopupOverlay = " . $close_popup_overlay_mobile_flag . ";
                                }
                                let ays_pb_close_btn_delay".$id." = " . $close_button_delay . ";
                                let ays_pb_autoclose_delay".$id." = " . $ays_pb_autoclose . ";
                                if (isMobile) {
                                    ays_pb_autoclose_delay".$id." = " . $pb_autoclose_mobile . ";
                                    if (" . $enable_close_button_delay_for_mobile . ") {
                                        ays_pb_close_btn_delay".$id." = " . $close_button_delay_for_mobile . ";
                                    }
                                }
                                $(document).one('mouseleave', function(event){   
                                    if (event.clientY <= 0 || event.clientX <= 0 || (event.clientX >= window.innerWidth || event.clientY >= window.innerHeight)) {
                                        $(document).find('.ays-pb-modals').appendTo($(document.body));
                                        let ays_pb_scrollTop_".$id." = parseInt($(document).find('.ays_pb_scroll_".$id."').val()),
                                            ays_pb_scrollTop_type".$id." = $(document).find('.ays_pb_scroll_".$id."').data('type'),
                                            ays_pb_delayOpen_".$id." = parseInt($(document).find('.ays_pb_delay_".$id."').val()),
                                            time_pb_".$id." = $(document).find('.ays_pb_timer_".$id." span').data('seconds'),
                                            ays_pb_effectIn_".$id." = $(document).find('#ays_pb_modal_animate_in_".$id."').val(),
                                            ays_pb_animation_close_speed = $(document).find('#ays_pb_animation_close_speed_".$id."').val(),
                                            ays_pb_close_by_scroll_down_".$id." = parseInt($(document).find('.close_pb_by_scroll_down_".$id."').val()),
                                            ays_pb_animation_close_seconds = (ays_pb_animation_close_speed / 1000),
                                            countdownBox = $(document).find('.ays-pb-countdown-container-".$id."');
                                            ays_pb_animation_close_speed = parseFloat(ays_pb_animation_close_speed) - 50;
                                        var currentdate = new Date();
                                        var startDate = getCurrentTime ( currentdate );

                                        if( ays_pb_delayOpen_".$id." == 0 &&  ays_pb_scrollTop_".$id." == 0){
                                            $(document).find('.av_pop_modals_".$id."').css('display','block');
                                        }

                                        var data = {};
                                        var action = 'pb_used_coupons';
                                        var usedCoupon = $(document).find('.ays-pb-modal_".$id."').find('div.ays_pb_coupon_container').children('div.ays_pb_coupon_type').find('p').text();  
                                        data.action = action;
                                        data.used_coupon = usedCoupon;
                                        data.id = {$id};
                                        $.ajax({
                                            url: pb_public.ajax,
                                            method: 'POST',
                                            dataType: 'text',
                                            data: data,
                                            success: function(response) {
                                            }
                                        }); 

                                        if(time_pb_".$id." !== undefined){
                                            if(time_pb_".$id." !== 0){
                                                var type = $(document).find('.av_pop_modals_".$id."').find('input#ays_pb_view_type_".$id."').data('type');

                                                $(document).find('#ays-pb-modal-checkbox_".$id."').trigger('click');

                                                if(ays_pb_scrollTop_".$id." == 0){

                                                    $(document).find('.ays-pb-modal_".$id."').css({
                                                        'animation-duration': ays_pb_animation_close_seconds + 's'
                                                    });

                                                    $(document).find('.ays-pb-modal_".$id."').css({
                                                        'animation-duration': ays_pb_animation_close_seconds + 's'
                                                    });

                                                    setTimeout(function(){
                                                        let timer_pb_".$id." = setInterval(function(){

                                                            let newTime_pb_".$id." = time_pb_".$id."--;
                                                            let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();

                                                            $(document).find('.ays_pb_timer_".$id." span').text(newTime_pb_".$id.");

                                                            if(newTime_pb_".$id." <= 0){
                                                                $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                                if(ays_pb_effectOut_".$id." != 'none'){
                                                                    setTimeout(function(){ 
                                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                        $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                    }, ays_pb_animation_close_speed);
                                                                }else{
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                }
                                                                $modal_close_additional_js
                                                                clearInterval(timer_pb_".$id.");
                                                            }

                                                            $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){ 

                                                                $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                                $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                                $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                                    var key = /https:\/\/www.youtube.com/;
                                                                    var src = $(this).attr('src');
                                                                    if(typeof src != 'undefined'){
                                                                        $(this).removeAttr('src');
                                                                        $(this).attr('src',src);
                                                                    }
                                                                });

                                                                $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                                    if(typeof $(this).get(0) != 'undefined'){
                                                                        if ( ! $(this).get(0).paused ) {
                                                                            $(this).get(0).pause();
                                                                            $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                                        }
                                    
                                                                    }
                                                                });

                                                                $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                                    if(typeof $(this).get(0) != 'undefined'){
                                                                        if ( ! $(this).get(0).paused ) {
                                                                            $(this).get(0).pause();
                                                                        }
                                    
                                                                    }
                                                                });

                                                                var close_sound_src = $(document).find('#ays_pb_close_sound_".$id."').attr('src');

                                                                if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){

                                                                    if('".$ays_pb_check_anim_speed."' !== 0){
                                                                        var playPromise = $(document).find('#ays_pb_close_sound_".$id."').get(0).play();
                                                                        if (playPromise !== undefined) {
                                                                            playPromise.then(function() {
                                                                                audio.pause();
                                                                            }).catch(function(error) {
                                                                                
                                                                            });
                                                                        }
                                                                    }
                                                                }
                                                                if(ays_pb_effectOut_".$id." != 'none'){
                                                                    setTimeout(function(){
                                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                        $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                        $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                        if($('#ays_pb_close_sound_".$id."').get(0) != undefined){
                                                                            if(!$('#ays_pb_close_sound_".$id."').get(0).paused){
                                                                                $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                                var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                                audio.pause();
                                                                                audio.currentTime = 0;
                                                                            }
                                                                        }
                                                                    }, ays_pb_animation_close_speed);  
                                                                }else{
                                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                    $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                    $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                    if($('#ays_pb_close_sound_".$id."').get(0) != undefined){
                                                                        if(!$('#ays_pb_close_sound_".$id."').get(0).paused){
                                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                            var audio = $('#ays_pb_close_sound_".$id."').get(0);
                                                                            audio.pause();
                                                                            audio.currentTime = 0;
                                                                        }
                                                                    }
                                                                }
                                                                $modal_close_additional_js

                                                                $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                                clearInterval(timer_pb_".$id.");

                                                            });

                                                            var ays_pb_flag =  true;
                                                            $(document).on('keydown', function(event) { 
                                                                if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                                    if (event.keyCode == 27) {        
                                                                        $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                        ays_pb_flag = false;
                                                                    } 
                                                                }
                                                            });

                                                            
                                                        },1000); 

                                                    },ays_pb_delayOpen_".$id.");
                                                }

                                                if(closePopupOverlay && '". $popupbox['onoffoverlay'] ."' == 'on'){

                                                    $(document).find('.av_pop_modals_".$id."').on('click', function(e) {
                                                        var pb_parent = $(this);
                                                        var pb_div = $(this).find('.ays-pb-modal_".$id."');

                                                        if (!pb_div.is(e.target) && pb_div.has(e.target).length === 0){
                                                            $(document).find('.ays-pb-modal-close_".$id."').click();
                                                        }
                                                    });

                                                }
                                    
                                                if('".$enable_content_click_flag."'){
                                                    
                                                    $('.ays-pb-modal_".$id."').one('click',function(e){

                                                        var redirect_url = $(document).find('.redirect_url_".$id."').val();
                                                        var closeButtonDiv = $(document).find('.ays-pb-modal-close_".$id."');
                                                
                                                        if (!closeButtonDiv.is(e.target) && closeButtonDiv.has(e.target).length === 0){
                                                            if('".$enable_redirect_content_click_flag."' && '".$enable_new_tab_content_click_flag."'){
                                                                window.open(redirect_url);
                                                            }else if('".$enable_redirect_content_click_flag."'){
                                                                window.open(redirect_url,'_self');
                                                            }
                                                            if('".$enable_close_content_flag."'){
                                                                $(document).find('.ays-pb-modal-close_".$id."').click();
                                                            }
                                                        }

                                                    })
                                                }
                                                    
                                            } else {

                                                $(document).find('.ays_pb_timer_".$id."').css('display','none');
                                                $(document).find('.ays-pb-modal_".$id."').css({
                                                'animation-duration': ays_pb_animation_close_seconds + 's'
                                                }); 
                                                
                                                if('".$enable_content_click_flag."'){

                                                    $('.ays-pb-modal_".$id."').one('click',function(e){

                                                        var closeButtonDiv  = $(document).find('.ays-pb-modal-close_".$id."');
                                                        if (!closeButtonDiv .is(e.target) && closeButtonDiv .has(e.target).length === 0){
                                                            var redirect_url = $(document).find('.redirect_url_".$id."').val();
                                                        
                                                            if('".$enable_redirect_content_click_flag."' && '".$enable_new_tab_content_click_flag."'){
                                                                window.open(redirect_url);
                                                            }else if('".$enable_redirect_content_click_flag."'){
                                                                window.open(redirect_url,'_self');
                                                            }

                                                            if('".$enable_close_content_flag."'){
                                                                $(document).find('.ays-pb-modal-close_".$id."').click();
                                                            }
                                                        }
                                                    })
                                                }
                                                $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){  
                                                    let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();           

                                                    $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                    $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");

                                                    $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                        var key = /https:\/\/www.youtube.com/;
                                                        var src = $(this).attr('src');
                                                        if(typeof src != 'undefined'){
                                                            $(this).removeAttr('src');
                                                            $(this).attr('src',src);
                                                        }
                                                    });

                                                    $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                        if(typeof $(this).get(0) != 'undefined'){
                                                            if ( ! $(this).get(0).paused ) {
                                                                $(this).get(0).pause();
                                                                $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                            }
                                    
                                                        }
                                                    });

                                                    $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                        if(typeof $(this).get(0) != 'undefined'){
                                                            if ( ! $(this).get(0).paused ) {
                                                                $(this).get(0).pause();
                                                            }
                                    
                                                        }
                                                    });
                                                    if(ays_pb_effectOut_".$id." != 'none'){
                                                        setTimeout(function(){
                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                            $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                            $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                        }, ays_pb_animation_close_speed);  
                                                    }else{
                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                        $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                        $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                    }
                                                    $modal_close_additional_js

                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                });
                                            }
                                        }
                                        let count = 0;
                                        if( ays_pb_scrollTop_".$id." !== 0 ){
                                            if(ays_pb_scrollTop_type".$id." = 'percentage'){
                                                ays_pb_scrollTop_".$id." = ( $(window).height() /100 ) * ays_pb_scrollTop_".$id.";
                                            }
                                            $(window).scroll(function() {
                                                if(($(this).scrollTop() >= ays_pb_scrollTop_".$id.") && (count === 0)) {
                                                    count++;
                                                    if( ays_pb_delayOpen_".$id." !== 0 ){                        
                                                        $(document).find('.ays-pb-modal_".$id."').css('animation-delay', ays_pb_delayOpen_".$id."/1000);
                                                        setTimeout(function(){
                                                            $(document).find('.av_pop_modals_".$id."').css('display','block');
                                                            $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                                            if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                                            $(document).find('.ays-pb-modal-check_".$id."').prop('checked', true);
                                                        }, ays_pb_delayOpen_".$id.");
                                                    }else{
                                                        $(document).find('.av_pop_modals_".$id."').css('display','block');
                                                        $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                                        if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                                        $(document).find('.ays-pb-modal-check_".$id."').prop('checked', true);
                                                    }
                                                    if (ays_pb_close_btn_delay".$id." != 0 && '".$closeButton."' != 'on') {
                                                        let close_button_delay = ays_pb_close_btn_delay".$id.";
                                                        if (ays_pb_delayOpen_".$id." != 0) {
                                                            close_button_delay += Math.floor(ays_pb_delayOpen_".$id.");
                                                        }
                                                        $(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'none'});
                                                        
                                                        setTimeout(function(){ 
                                                            $(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'block'});
                                                            $(document).find('.ays-pb-modal_".$id." .ays_coral_btn_close.ays-pb-close-button-delay').css({'display': 'flex'});
                                                            $(document).find('.ays-pb-modal_".$id." .ays_cmd_control-item.ays-pb-close-button-delay').css({'display': 'inline-block'});
                                                        }, close_button_delay );
                                                    }
                                                    if(ays_pb_autoclose_delay".$id." != 0){
                                                        $(document).find('.ays-pb-modal_".$id."').css({
                                                            'animation-duration': ays_pb_animation_close_seconds + 's'
                                                        });
                                                        setTimeout(function(){
                                                            let timer_pb_".$id." = setInterval(function(){
                                                                
                                                                let newTime_pb_".$id." = time_pb_".$id."--;
                                                                let ays_pb_effectOut_".$id." = $(document).find('#ays_pb_modal_animate_out_".$id."').val();
                                                                $(document).find('.ays_pb_timer_".$id." span').text(newTime_pb_".$id.");
                                                                if(newTime_pb_".$id." <= 0){
                                                                    $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                    $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                                    if(ays_pb_effectOut_".$id." != 'none'){
                                                                        setTimeout(function(){ 
                                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                            $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                        }, ays_pb_animation_close_speed);
                                                                    }else{
                                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                        $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                    }
                                                                    $modal_close_additional_js
                                                                    clearInterval(timer_pb_".$id.");
                                                                }
                                                                $(document).find('.ays-pb-modal-close_".$id."').one('click', function(){                     
                                                                    $(document).find('.av_pop_modals_".$id."').css('pointer-events', 'none');
                                                                    $(document).find('.ays-pb-modal_".$id."').attr('class', '".$container_classes['main_class']." ".$ays_pb_show_scrollbar_class." ays-pb-modal_".$id." '+ays_pb_effectOut_".$id.");
                                                                    $(this).parents('.ays-pb-modals').find('iframe').each(function(){
                                                                        var key = /https:\/\/www.youtube.com/;
                                                                        var src = $(this).attr('src');
                                                                        if(typeof src != 'undefined'){
                                                                            $(this).removeAttr('src');
                                                                            $(this).attr('src',src);
                                                                        }
                                                                    });
                                                                    $(this).parents('.ays-pb-modals').find('video.wp-video-shortcode').each(function(){
                                                                        if(typeof $(this).get(0) != 'undefined'){
                                                                            if ( ! $(this).get(0).paused ) {
                                                                                $(this).get(0).pause();
                                                                                $(document).find('.ays-pb-modal_".$id." .wp-video-shortcode').get(0).currentTime = 0;
                                                                            }

                                                                        }
                                                                    });
                                                                    $(this).parents('.ays-pb-modals').find('audio.wp-audio-shortcode').each(function(){
                                                                        if(typeof $(this).get(0) != 'undefined'){
                                                                            if ( ! $(this).get(0).paused ) {
                                                                                $(this).get(0).pause();
                                                                            }

                                                                        }
                                                                    });
                                                                    if(ays_pb_effectOut_".$id." != 'none'){
                                                                        setTimeout(function(){
                                                                            $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                            $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                            $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true');
                                                                        }, ays_pb_animation_close_speed);  
                                                                    }else{
                                                                        $(document).find('.ays-pb-modal_".$id."').css('display', 'none');
                                                                        $(document).find('.av_pop_modals_".$id."').css('display', 'none');
                                                                        $(document).find('.ays-pb-modal_".$id."').attr('data-ays-flag','true'); 
                                                                    }
                                                                    $modal_close_additional_js
                                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none'});
                                                                    clearInterval(timer_pb_".$id.");
                                                                });
                                                                var ays_pb_flag = true;
                                                                $(document).on('keydown', function(event) { 
                                                                    if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                                        if (event.keyCode == 27) {                                    
                                                                            $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                                            ays_pb_flag = false;
                                                                        } 
                                                                    }
                                                                });

                                                            },1000);
                                                        },ays_pb_delayOpen_".$id.");
                                                    }
                                                }
                                            });
                                        }
                                        else{
                                            if( ays_pb_delayOpen_".$id." !== 0 ){
                                                $(document).find('.ays-pb-modal_".$id."').css('animation-delay', ays_pb_delayOpen_".$id."/1000);
                                                setTimeout(function(){
                                                    $(document).find('.av_pop_modals_".$id."').css('display','block');
                                                    $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                                    if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                                    $(document).find('.ays-pb-modal-check_".$id."').attr('checked', 'checked');
                                    
                                                    if('".$popupbox['disable_scroll']."'){
                                                        $(document).find('body').removeClass('pb_enable_scroll');
                                                        $(document).find('body').addClass('pb_disable_scroll'); 
                                    
                                                        $(document).find('html').removeClass('pb_enable_scroll');
                                                        $(document).find('html').addClass('pb_disable_scroll');   
                                                        
                                                    }
                                    
                                                }, ays_pb_delayOpen_".$id.");
                                            } else {
                                                if($(document).find('.ays_pb_abt_".$id."').val() != 'clickSelector'){
                                                    $(document).find('.av_pop_modals_".$id."').css('display','block');
                                                    $(document).find('.ays-pb-modal_".$id."').addClass(ays_pb_effectIn_".$id.");
                                                    $(document).find('.ays-pb-modal_".$id."').css('display', 'block');
                                                    if (window.innerWidth < 768 && $(document).find('#ays-pb-screen-shade_".$id."').attr('data-mobile-overlay') == 'true') {
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_mobile_opacity."'});
                                                }
                                                else{
                                                    $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '".$overlay_opacity."'});
                                                }
                                                    $(document).find('.ays-pb-modal-check_".$id."').attr('checked', 'checked');
                                    
                                                    if('".$popupbox['disable_scroll']."'){
                                                        $(document).find('body').removeClass('pb_enable_scroll');
                                                        $(document).find('body').addClass('pb_disable_scroll'); 
                                    
                                                        $(document).find('html').removeClass('pb_enable_scroll');
                                                        $(document).find('html').addClass('pb_disable_scroll');   
                                                        
                                                    }
                                                }
                                            }
                                        }
                                        if ('".$popupbox['onoffoverlay']."' != 'on'){
                                            $(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none !important', 'pointer-events': 'none', 'background': 'none'});
                                            $(document).find('.ays-pb-modal_".$id."').css('pointer-events', 'auto');
                                            $(document).find('.av_pop_modals_".$id."').css('pointer-events','none');
                                        };
                                        if('".$popupbox['action_button_type']."' == 'pageLoaded' || '".$popupbox['action_button_type']."' == 'both' || '".$popupbox['action_button_type']."' == 'exitIntent'){
                                            $(document).one('click' ,'.ays-pb-modal-close_".$id."', function() {  
                                                var pb_id = ".$id.";
                                                var d = new Date(); 
                                                var endDate = getCurrentTime ( d ); 
                                                var duration = Math.floor( (d - currentdate) / 1000);
                                                $.ajax({
                                                    url: pb_public.ajax,
                                                    method: 'POST',
                                                    dataType: 'text',
                                                    data: {
                                                        status   : true,
                                                        action   : 'ays_pb_add_reports',
                                                        id       : pb_id,
                                                        startDate: startDate,
                                                        endDate  : endDate,
                                                        duration : duration
                                                    },
                                                });
                                            }); 
                                        };
                                        if($(document).find('.ays-pb-modals video').hasClass('wp-video-shortcode')){
                                            var videoWidth  = $(document).find('.ays-pb-modals video.wp-video-shortcode').attr('width');
                                            var videoHeight = $(document).find('.ays-pb-modals video.wp-video-shortcode').attr('height');
                                            setTimeout(function(){
                                                $(document).find('.ays-pb-modals .wp-video').removeAttr('style');
                                                $(document).find('.ays-pb-modals .mejs-container').removeAttr('style');
                                                $(document).find('.ays-pb-modals video.wp-video-shortcode').removeAttr('style');
                                    
                                                $(document).find('.ays-pb-modals .wp-video').css({'width': '100%'});
                                                $(document).find('.ays-pb-modals .mejs-container').css({'width': '100%','height': videoHeight + 'px'});
                                                $(document).find('.ays-pb-modals video.wp-video-shortcode').css({'width': '100%','height': videoHeight + 'px'});
                                            },1000);
                                        }
                                        if($(document).find('.ays-pb-modals iframe').attr('style') != ''){
                                            setTimeout(function(){
                                                $(document).find('.ays-pb-modals iframe').removeAttr('style');
                                            },500);
                                        }
                                        if(ays_pb_close_by_scroll_down_".$id." !== 0){
                                            $(window).scroll(function() {
                                                if($(this).scrollTop() == ays_pb_close_by_scroll_down_".$id."){ 
                                                    if($(document).find('.ays-pb-modal_".$id."').css('display') != 'none'){
                                                        $(document).find('.ays-pb-modal-close_".$id."').click();
                                                            var close_sound_src = $(document).find('#ays_pb_close_sound_".$id."').attr('src');
                                                            if('".$ays_pb_check_anim_speed."' && typeof close_sound_src !== 'undefined' && '". $ays_pb_check_sound ."' === 'on'){
                                                                if('".$ays_pb_check_anim_speed."' !== 0){
                                                                    var playPromise = $(document).find('#ays_pb_close_sound_".$id."').get(0).play();
                                                                    if (playPromise !== undefined) {
                                                                        playPromise.then(function() {
                                                                            audio.pause();
                                                                        }).catch(function(error) {
                                                                            
                                                                        });
                                                                    }
                                                                }
                                                            }
                                                    }
                                                }
                                                
                                            })
                                        }

                                        if('".$close_popup_by_classname_flag."'){
                                            if($('.".$popupbox['close_by_classname_'.$id]."').length){
                                                $('.".$popupbox['close_by_classname_'.$id]."').click(function(){
                                                    $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                })
                                            }
                                        }
                                        // if(".$popupbox['ays_pb_autoclose']." == 0){
                                            if(closePopupOverlay && '".$popupbox['onoffoverlay']."' == 'on'){
                                                $(document).find('.av_pop_modals_".$id."').on('click', function(e) {
                                                    var pb_parent = $(this);
                                                    var pb_div = $(this).find('.ays-pb-modal_".$id."');
                                                    if (!pb_div.is(e.target) && pb_div.has(e.target).length === 0){
                                                        $(document).find('.ays-pb-modal-close_".$id."').click();
                                                    }
                                                });
                                            }
                                            var ays_pb_flag = true;
                                            $(document).on('keydown', function(event) { 
                                                if('".$close_popup_esc_flag."' && ays_pb_flag){
                                                    if (event.keyCode == 27) {                                    
                                                        $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                        ays_pb_flag = false;
                                                    } 
                                                }
                                            });
                                        // }
                                        if('".$popupbox['enable_autoclose_on_completion']."' == 'on') {
                                            var video = $(document).find('video.wp-video-shortcode');
                                            for (let i = 0; i < video.length; i++) {
                                                video[i].addEventListener('ended', function() {
                                                    if ($(this).next().val() === 'on') {
                                                        $(this).parents('.ays_video_window').find('.close-video-btn').trigger('click');
                                                    }
                                                });
                                            }
                                        }            
                                    
                                        jQuery(document).on('click', '.ays-pb-modal-close_".$id."', function() {
                                                            $(document).find('body').removeClass('pb_disable_scroll');
                                                            $(document).find('body').addClass('pb_enable_scroll');
                                    
                                                            $(document).find('html').removeClass('pb_disable_scroll');
                                                            $(document).find('html').addClass('pb_enable_scroll');
                                        });
                                        if(typeof countdownBox != 'undefined' && countdownBox.length > 0){
                                            
                                                var second  = 1000,
                                                    minute  = second * 60,
                                                    hour    = minute * 60,
                                                    day     = hour * 24;
                                        
                                                
                                                var countDown = new Date('".$countdown_date_format."').getTime();
                                                var countDownDays    = document.getElementById('ays-pb-countdown-days-".$id."');
                                                var countDownHours   = document.getElementById('ays-pb-countdown-hours-".$id."');
                                                var countDownMinutes = document.getElementById('ays-pb-countdown-minutes-".$id."');
                                                var countDownSeconds = document.getElementById('ays-pb-countdown-seconds-".$id."');
                                            
                                                var countdownTimer = setInterval(function() {
                                                    countdownBox.removeClass('display_none');
                                                    var now = new Date().getTime(),
                                                    distance = countDown - now;
                                        
                                                        if(countDownDays !== null || countDownHours !== null || countDownMinutes !== null || countDownSeconds !== null){
                                                            countDownDays.innerText = Math.floor(distance / (day)),
                                                            countDownHours.innerText = Math.floor((distance % (day)) / (hour)),
                                                            countDownMinutes.innerText = Math.floor((distance % (hour)) / (minute)),
                                                            countDownSeconds.innerText = Math.floor((distance % (minute)) / second);
                                                        }
                                                        
                                                    //do something later when date is reached
                                                    if (distance < 0) {
                                                        $(document).find('.ays-pb-modal-close_".$id."').trigger('click');
                                                    //     var headline  = document.getElementById('ays-pb-countdown-headline'),
                                                    //         countdownBox = document.getElementById('ays-pb-countdown'),
                                                    //         content   = document.getElementById('ays-pb-countdown-content');
                                        
                                                    //     // headline.innerText = 'Sale is over!';
                                                            countdownBox.hide();
                                                    //     content.style.display = 'block';
                                        
                                                        clearInterval(countdownTimer);
                                                    }
                                                }, 1000);
                                            
                                    
                                        } 
                                    }
                                });  
                            });
                        })( jQuery );
                    </script>";
            }
            
            if ($popupbox['onoffoverlay'] != 'on'){
                $popupbox_view['popupbox_end_script_6'] = "
                <script>
                    (function($) {
                        'use strict';
                        $(document).ready(function() {
                            jQuery(document).find('#ays-pb-screen-shade_".$id."').css({'opacity': '0', 'display': 'none !important', 'pointer-events': 'none'});
                            jQuery(document).find('.ays-pb-modal_".$id."').css('pointer-events', 'auto');
                            jQuery(document).find('.av_pop_modals_".$id."').css('pointer-events','none');
                        });
                    })(jQuery);
                </script>";
            }

            if ( $popupbox['close_button_delay'] != 0 && $closeButton != 'on') {
                $popupbox_view['popupbox_end_script_7'] = "
                <script>
                    (function($) {
                        'use strict';
                        $(document).ready(function() {
                            var closeBtnDelay = ".$close_button_delay.";
                            var openDelay = ".$ays_pb_delay.";
                            var scrollTop = ".$ays_pb_scroll_top.";
                            if (window.innerWidth < 768) {
                                if (" . $enable_open_delay_mobile . ") {
                                    openDelay = ".$ays_pb_open_delay_mobile.";
                                }
                                if (" . $enable_scroll_top_mobile . ") {
                                    scrollTop = ".$ays_pb_scroll_top_mobile.";
                                }
                            }
                            closeBtnDelay += Math.floor(openDelay);
                            if (!scrollTop) {
                                jQuery(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'none'});
                                setTimeout(function(){
                                    jQuery(document).find('.ays-pb-modal_".$id." .ays-pb-close-button-delay').css({'display': 'block'});
                                    jQuery(document).find('.ays-pb-modal_".$id." .ays_coral_btn_close.ays-pb-close-button-delay').css({'display': 'flex'});
                                    jQuery(document).find('.ays-pb-modal_".$id." .ays_cmd_control-item.ays-pb-close-button-delay').css({'display': 'inline-block'});
                                }, closeBtnDelay);
                            }
                        });
                    })(jQuery);
                </script>";
            }

            $popupbox_view['popupbox_end_script_8'] = "
            <script>
                function getCurrentTime( currentdate ){  
                    var month  = currentdate.getMonth()+1;
                    var day    = currentdate.getDate();
                    var second = currentdate.getSeconds();
                    var hour   = currentdate.getHours();
                    var date   = currentdate.getFullYear() +  '-'
                        + ( month < 10 ? '0' : '') + month + '-' 
                        + ( day < 10 ? '0' : '') + day  + ' '
                        + ( hour < 10 ? '0' : '') + hour + ':'  
                        + currentdate.getMinutes() + ':' 
                        + ( second < 10 ? '0' : '') + second;
                    
                    return date;
                }
            </script>";

            if($popupbox['ays_pb_hover_show_close_btn']){
                $popupbox_view['popupbox_end_script_9'] = "
                <script>
                    (function($) {
                        'use strict';
                        $(document).ready(function() {
                            jQuery(document).ready(function() {
                                jQuery(document).find('.ays_image_window .close-image-btn').css('padding-bottom','4px');
                                jQuery(document).find('.ays_minimal_window .close-image-btn').css('padding-bottom','5px');
                                    jQuery(document).find('.ays-pb-modal-close_".$id."').hide();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_win98_btn-close').hide();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_winxp_title-bar-close').hide();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_ubuntu_close').hide();
                                    jQuery(document).find('.ays-pb-modal_".$id."').on('mouseover',function(){
                                        jQuery(document).find('.ays-pb-modal-close_".$id."').show();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_win98_btn-close').show();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_winxp_title-bar-close').show();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_ubuntu_close').show();
                                    });
                                    jQuery(document).find('.ays-pb-modal_".$id."').on('mouseleave',function(){
                                        jQuery(document).find('.ays-pb-modal-close_".$id."').hide();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_win98_btn-close').hide();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_winxp_title-bar-close').hide();
                                        jQuery(document).find('.ays-pb-modal_".$id." .ays_ubuntu_close').hide();
                                    });
                            })
                        });
                    })(jQuery);
                </script>";
            }

            if( $enable_recaptcha ){
                $popupbox_view['popupbox_end_script_10'] = "
                <script defer>
                    (function( $ ) {
                        'use strict';
                        jQuery(document).ready(function () {
                            
                            setTimeout(function(){
                                jQuery(document).find('.ays-pb-modals').AysPopupRecaptcha();

                                var ays_popup_container = jQuery(document).find('.ays-pb-modal_". $id ."').each(function(e){
                                    var _this = jQuery(this);
                                    var parent = _this.parents('.ays-pb-modals');
                                    var form = _this.find('form');
                                    var submitButton = form.find('input[type=submit]')

                                    var quizRecaptcha = true;

                                    var formCaptchaValidation = null;
                                    if( quizRecaptcha ){
                                        if( form.attr('data-recaptcha-validate') ){
                                            formCaptchaValidation = form.attr('data-recaptcha-validate') == 'true' ? true : false;
                                        }
                                    }

                                    if( quizRecaptcha && formCaptchaValidation === null){
                                        var cEvent = new CustomEvent('afterPopupSubmission', {
                                            detail: {
                                                _this: form,
                                                thisButton: submitButton
                                            }
                                        });
                                        form.get(0).dispatchEvent(cEvent);
                                    }

                                    if( quizRecaptcha === false ){
                                        //formCaptchaValidation = true;
                                    }

                                    if ( formCaptchaValidation !== true ) {
                                        //return;
                                    }
                                });
                            },1000);

                        });
    
                    })( jQuery );
                </script>";
            }
            $popupbox_view[] = '<script>';

                $popupbox_view[] = " if(typeof aysPopupOptions === 'undefined'){
                                            var aysPopupOptions = [];
                                        }
                                        aysPopupOptions['" . $popupbox['id'] . "']  = '" . base64_encode( json_encode( array(
                                            'popupbox'       => $popupbox,
                            ) ) ) . "';";
            $popupbox_view[] = '</script>';

            return implode( $popupbox_view );
        }

    }

    public function pb_used_coupons(){
        if(isset($_REQUEST['action']) && $_REQUEST['action'] == 'pb_used_coupons'){
            global $wpdb;

            //Popup Id
            $pb_id = isset($_REQUEST['id']) && $_REQUEST['id'] != '' ? intval($_REQUEST['id']) : null;

            //Used coupon
            $used_coupon = isset($_REQUEST['used_coupon']) && $_REQUEST['used_coupon'] != '' ? sanitize_text_field($_REQUEST['used_coupon']) : '';

            if($pb_id == null){
                return;
            }
            
            $pb_table = esc_sql( $wpdb->prefix . 'ays_pb' );
            
            $sql = "SELECT options FROM {$pb_table} WHERE id = ".$pb_id;
            $results = $wpdb->get_var($sql);
            
            $options = json_decode($results);
            
            //Active/Inactive coupons
            $active_inactive_coupons = (isset($options->pb_coupons_array) && $options->pb_coupons_array != '') ? $options->pb_coupons_array : array();
            
            if(! empty( $active_inactive_coupons ) ){
                
                $pb_active_coupons = (isset( $active_inactive_coupons->pb_active_coupons) && !empty( $active_inactive_coupons->pb_active_coupons)) ?  $active_inactive_coupons->pb_active_coupons : array();
                
                $pb_inactive_coupons = (isset( $active_inactive_coupons->pb_inactive_coupons) && !empty( $active_inactive_coupons->pb_inactive_coupons)) ?  $active_inactive_coupons->pb_inactive_coupons : array();
                
                $active_coupons_array = (array)$pb_active_coupons;
                $inactive_coupons_array = (array)$pb_inactive_coupons;
                $active_inactive_coupons_array = (array)$active_inactive_coupons;
            }
            
            
            //Shuffle Active Coupons
            if(! empty( $active_coupons_array ) ){
                
                if (($key = array_search($used_coupon, $active_coupons_array)) !== false) {
                    unset($active_coupons_array[$key]);
                }
                
                $inactive_coupons_array[] = $used_coupon;
                
                $active_inactive_coupons_array['pb_active_coupons'] = $active_coupons_array;
                $active_inactive_coupons_array['pb_inactive_coupons'] = $inactive_coupons_array;
                
                $options->pb_coupons_array = $active_inactive_coupons_array;
                
                if(isset($options->pb_coupons_array)){
                    
                    $pb_result = $wpdb->update(
                        $pb_table,
                        array(
                            'options' => json_encode( $options ),
                        ),
                        array( 'id' => $pb_id ),
                        array( '%s' ),
                        array( '%d' )
                    );
                }

                if($pb_result){
                    ob_end_clean();
                    $ob_get_clean = ob_get_clean();
                    echo json_encode(array(
                        'status' => true,
                    ));
                    wp_die();
                }else{
                    ob_end_clean();
                    $ob_get_clean = ob_get_clean();
                    echo json_encode(array(
                        'status' => false,
                    ));
                    wp_die();
                }

            }else{
                ob_end_clean();
                    $ob_get_clean = ob_get_clean();
                    echo json_encode(array(
                        'status' => false,
                        'result' => '',
                    ));
                    wp_die();
            }

        }
    }

    public function ays_has_shortcode_in_posts($id){

	    if (isset(get_post()->post_content)) {
            $ays_has_shortcode = strpos(get_post()->post_content, '[ays_pb id=' . $id . '');
            if ($ays_has_shortcode !== false) {
                return true;
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function ays_shortcodes_show_all(){
        global $wpdb;
        global $wp;
        global $wp_query;
        
        $woo = in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')));
        if ($woo) {
            //For woocommerce shop page
            if(is_shop()){
                $post_id = woocommerce_get_page_id('shop');
            }else{
                $post_id = isset($wp_query->post->ID) && $wp_query->post->ID != "" ? $wp_query->post->ID : null;
            }
        }else{
            $post_id = isset($wp_query->post->ID) && $wp_query->post->ID != "" ? $wp_query->post->ID : null;
        }

        $page_url = home_url(add_query_arg(array($_GET), $wp->request));
        $home_url = get_site_url();

        $sql2 = "SELECT * FROM {$wpdb->prefix}ays_pb";
        $result2 = $wpdb->get_results($sql2, "ARRAY_A");
           
        if(!empty($result2)){
            foreach($result2 as $key => $i){
                $show_all = $i['show_all'];
                switch($show_all){
                    case 'no':
                    $show_popup = false;
                    break;
                    case 'yes':
                    $show_popup = true;
                    break;
                    case 'all':
                    $show_popup = true;
                    break;
                    case 'selected':
                    $show_popup = false;
                    break;
                    case 'except':
                    $show_popup = true;
                    break;
                    default:
                    $show_popup = true;
                    $show_all = 'all';
                }
                $show = array('no', 'selected');

                $options = array();
                if ($i['options'] != '' || $i['options'] != null) {
                    $options = json_decode($i['options'], true);
                }

                $ays_pb_view_place = array();
                if($show_all != 'all'){
                    if($post_id != false){
                        if (!empty($i["view_place"])) {
                            $ays_pb_view_place  = explode( '***', $i["view_place"] );
                            if(in_array($post_id."", $ays_pb_view_place)){
                                if(in_array($show_all, $show)){
                                    $show_popup = true;
                                }else{
                                    $show_popup = false;
                                }
                            }
                        }else{
                            $post = get_post($post_id);
                            $this_post_title = strval($post->post_title);
                            $except_posts = array();
                            $except_post_types = array();
                            $postType = $post->post_type;                            
                            
                            if (isset($options['except_posts']) && !empty($options['except_posts'])) {
                                $except_posts = $options['except_posts'];
                            }
                            if (isset($options['except_post_types']) && !empty($options['except_post_types'])) {
                                $except_post_types = $options['except_post_types'];
                            }
                            
                            $except_all_post_types  = ( isset( $options['all_posts'] ) && ! empty( $options['all_posts'] ) ) ?  $options['all_posts']  : array();
                            
                            if(in_array($post_id."", $except_posts)){
                                if(in_array($show_all, $show)){
                                    $show_popup = true;
                                }else{
                                    $show_popup = false;
                                }
                            }
                            elseif (!in_array( $this_post_title, $except_posts ) && in_array( $postType, $except_all_post_types )) {
                                if(in_array($show_all, $show)){
                                    $show_popup = true;
                                }else{
                                    $show_popup = false;
                                }
                            }

                            if ( $page_url == $home_url ) {
                                if(isset($options['show_on_home_page']) && $options['show_on_home_page'] == 'on'){
                                    $show_popup = true;
                                }else{
                                    $show_popup = false;
                                }
                            }
                        }

                        if( is_404() || is_category() || is_search() ) {
                            $show_popup = false;
                        }
                    }   
                }
                if ($show_popup) {
                    $current_url = $_SERVER['REQUEST_URI'];
                    $elementor_editor_slug = 'elementor';

                    if (strpos($current_url, $elementor_editor_slug) === false) {
                        $shortcode2 = "[ays_pb id={$i['id']} w={$i['width']} h={$i['height']} ]";
                        $ays_search_shortcode = $this->ays_has_shortcode_in_posts($i['id']);
                        if ($ays_search_shortcode !== true){
                            echo do_shortcode($shortcode2);
                        }
                    }
                }

            }
        }
    }

    public function ays_shortcodes_category_show_all(){
        global $wpdb;

        $woo = in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')));
        if ($woo) {
            //For woocommerce shop page
            if(is_shop()){
                $post_id = woocommerce_get_page_id('shop');
            }else{
                $post_id = get_the_ID();
            }
        }else{
            $post_id = get_the_ID();
        }

        $sql = "SELECT * FROM {$wpdb->prefix}ays_pb_categories WHERE `published` = 1";
        $results = $wpdb->get_results($sql, "ARRAY_A");
           
        if(!empty($results)){
            foreach($results as $key => $category_data){

                $show_all = sanitize_text_field( $category_data['show_all'] );
                switch($show_all){
                    case 'no':
                        $show_popup = false;
                    break;
                    case 'yes':
                        $show_popup = true;
                    break;
                    case 'all':
                        $show_popup = true;
                    break;
                    case 'selected':
                        $show_popup = false;
                    break;
                    case 'except':
                        $show_popup = true;
                    break;
                    default:
                        $show_popup = true;
                        $show_all = 'all';
                }
                $show = array('no', 'selected');

                $options = array();
                if ( $category_data['options'] != '' ||  $category_data['options'] != null) {
                    $options = json_decode( $category_data['options'], true);
                }

                if ( isset($options['show_random_posts_category']) && $options['show_random_posts_category'] == 'on') {
                    $ays_pb_view_place = array();

                    $sql_cat = "SELECT `id`,`width`,`height` FROM {$wpdb->prefix}ays_pb WHERE `category_id`=". $category_data['id'];
                    $popupboxes_data = $wpdb->get_results($sql_cat, "ARRAY_A");

                    if ( !is_null( $popupboxes_data ) && !empty( $popupboxes_data ) ) {

                        $random_popupbox_key = array_rand( $popupboxes_data, 1 );

                        $popupbox = $popupboxes_data[ $random_popupbox_key ];

                        // $popup_options = array();
                        // if ( isset($popupbox['options']) && $popupbox['options'] != '' || $popupbox['options'] != null) {
                        //     $popup_options = json_decode($popupbox['options'], true);
                        // }

                        if($show_all != 'all'){
                            if($post_id != false){
                                $post = get_post($post_id);
                                $this_post_title = strval($post->post_title);
                                $except_posts = array();
                                $except_post_types = array();
                                $postType = $post->post_type;
                                
                                if (isset($options['except_posts']) && !empty($options['except_posts'])) {
                                    $except_posts = $options['except_posts'];
                                }
                                if (isset($options['except_post_types']) && !empty($options['except_post_types'])) {
                                    $except_post_types = $options['except_post_types'];
                                }
                                
                                $except_all_post_types  = ( isset( $options['all_posts'] ) && ! empty( $options['all_posts'] ) ) ?  $options['all_posts']  : array();
                                
                                if(in_array($post_id."", $except_posts)){
                                    if(in_array($show_all, $show)){
                                        $show_popup = true;
                                    }else{
                                        $show_popup = false;
                                    }
                                }
                                elseif (!in_array( $this_post_title, $except_posts ) && in_array( $postType, $except_all_post_types )) {
                                    if(in_array($show_all, $show)){
                                        $show_popup = true;
                                    }else{
                                        $show_popup = false;
                                    }
                                }

                                if ( is_front_page() ) {
                                    if(isset($options['show_on_home_page']) && $options['show_on_home_page'] == 'on'){
                                        $show_popup = true;
                                    }else{
                                        $show_popup = false;
                                    }
                                }

                                if( is_404() || is_category() || is_search() ) {
                                    $show_popup = false;
                                }
                            }
                        }
                    } else {
                        $show_popup = false;
                    }
                }else{
                    $show_popup = false;
                }
                
                if ($show_popup) {
                    $current_url = $_SERVER['REQUEST_URI'];
                    $elementor_editor_slug = 'elementor';

                    if (strpos($current_url, $elementor_editor_slug) === false) {
                        if ( isset( $popupbox ) && !empty( $popupbox ) ) {
                            $shortcode2 = "[ays_pb id={$popupbox['id']} w={$popupbox['width']} h={$popupbox['height']} ]";
                            $ays_search_shortcode = $this->ays_has_shortcode_in_posts($popupbox['id']);
                            if ($ays_search_shortcode !== true){
                                echo do_shortcode($shortcode2);
                            }
                        }
                    }
                }
            }
        }
    }

    public function get_user_ip(){
        $ipaddress = '';
        if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        elseif (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public function ays_pb_get_input_fields($fields, $popup_id, $popup_type){
        $popupbox_content = '';
        foreach($fields as $attr_slug => $attr_value){
            $popup_custom_field_input = "";
            $attr_enable = (isset($attr_value['enable']) && $attr_value['enable'] == 'on') ? esc_attr($attr_value['enable']) : 'off';
            $attr_name = (isset($attr_value['name']) && $attr_value['name'] != '') ? esc_attr($attr_value['name']) : '';
            $attr_type = (isset($attr_value['type']) && $attr_value['type'] != '') ? esc_attr($attr_value['type']) : '';
            $attr_placeholder = (isset($attr_value['placeholder']) && $attr_value['placeholder'] != '') ? esc_attr($attr_value['placeholder']) : '';
            $attr_required = (isset($attr_value['required']) && $attr_value['required'] == 'on') ? 'required' : '';
            $attr_options  = (isset($attr_value['options']) && $attr_value['options'] != '') ? esc_attr($attr_value['options']) : '';
            
            if($attr_enable == "on"){
                switch($attr_type){
                    case "textarea":
                        $popup_custom_field_input = "<textarea class='ays-pb-inputs ays_pb_form_input ays_pb_animated_x5ms' name='popup_attributes[".$attr_slug."]' placeholder='".$attr_placeholder."' ".$attr_required."></textarea>";
                        break;
                    case "select":
                        $popup_custom_field_options = '';
                        if($attr_options != ''){
                            $attr_options = explode(';' , $attr_options);
                        }
                        else{
                            $attr_options = array();
                        }
                        foreach($attr_options as $attr_options_key => $attr_options_value){
                            $popup_custom_field_options .= "<option value='".$attr_options_value."'>".$attr_options_value."</option>";
                        }
                        $popup_custom_field_input = "<select name='popup_attributes[".$attr_slug."]' ".$attr_required." class='ays_pb_form_input ays_pb_animated_x5ms'>".$popup_custom_field_options."</select>";
                        break;
                    case "tel":
                        $popup_custom_field_input = "<input type='number' class='ays_pb_".$popup_type."_type_".$attr_name." ays-pb-inputs ays_pb_form_input ays_pb_animated_x5ms' name='popup_attributes[".$attr_slug."]' placeholder='".$attr_placeholder."' ".$attr_required.">";
                        break;
                    case "checkbox":

                        $popup_custom_field_input = "<div class='ays-pb-custom-fields-checkbox-box'>";
                            $popup_custom_field_input .= "<div class='ays-pb-custom-fields-checkbox-elements'>";
                                $popup_custom_field_input .= "<label for='ays_pb_".$attr_slug."_".$popup_id."'>";
                                    $popup_custom_field_input .= "<span for='ays_pb_".$attr_slug."_".$popup_id."'>".$attr_name."</span>";
                                    $popup_custom_field_input .= "<input type='checkbox' class='ays_pb_form_input ays_pb_animated_x5ms' id='ays_pb_".$attr_slug."_".$popup_id."' name='popup_attributes[".$attr_slug."]' placeholder='".$attr_placeholder."' ".$attr_required.">";
                            $popup_custom_field_input .= "</div>";
                            $popup_custom_field_input .= "<div>";
                                $popup_custom_field_input .= "<span for='ays_pb_".$attr_slug."_".$popup_id."'>".$attr_options."</span>";
                            $popup_custom_field_input .= "</div>";
                        $popup_custom_field_input .= "</div>";
                        break;
                    default:
                        $popup_custom_field_input = "<input type='".$attr_type."' class='ays_pb_".$popup_type."_type_".$attr_name." ays-pb-inputs ays_pb_form_input ays_pb_animated_x5ms' name='popup_attributes[".$attr_slug."]' placeholder='".$attr_placeholder."' ".$attr_required.">";
                        break;
                }
                $popupbox_content .= "<div class='ays_pb_".$popup_type."_live'>".$popup_custom_field_input."</div>";
            }
        }
        return $popupbox_content;
    }

    public function ays_pb_subscribe_get_file($attr) {
        global $wpdb;
        $ays_pb_popup_attributes = isset($_REQUEST['popup_attributes']) && !empty($_REQUEST['popup_attributes']) ? $_REQUEST['popup_attributes'] : array();
        $ays_pb_send_mail = isset($_REQUEST['popup_attributes']['ays_pb_form_email']) && $_REQUEST['popup_attributes']['ays_pb_form_email'] != '' ? $_REQUEST['popup_attributes']['ays_pb_form_email'] : null;
        $ays_pb_current_popup_id = isset($_REQUEST['current_popup_id']) && $_REQUEST['current_popup_id'] != '' ? $_REQUEST['current_popup_id'] : null;
        $ays_pb_send_file_name = isset($_REQUEST['ays_pb_send_file_name']) && $_REQUEST['ays_pb_send_file_name'] != '' ? $_REQUEST['ays_pb_send_file_name'] : __("No uploaded file", $this->plugin_name);
        $ays_pb_send_file_content = isset($_REQUEST['ays_pb_send_file_content']) && $_REQUEST['ays_pb_send_file_content'] != '' ? stripslashes( $_REQUEST['ays_pb_send_file_content'] ) : '';
        $ays_pb_send_file_attachment_id = isset($_REQUEST['send_file_attachment_id']) && $_REQUEST['send_file_attachment_id'] != '' ? $_REQUEST['send_file_attachment_id'] : null;
        $popupbox = Ays_Pb_Data::get_pb_by_id( $ays_pb_current_popup_id );
        $attachment_path = false;
            if($ays_pb_send_file_attachment_id){
                $attachment_path = get_attached_file(intval($_REQUEST['send_file_attachment_id']));
            }
            $nsite_url_base = parse_url( get_site_url(), PHP_URL_HOST );
            $nsite_url = trim( $nsite_url_base, '/' );

            $to = '';
            $nfrom = '';

            $message_content = array();
            if($ays_pb_send_file_content != ''){
                $message_content[] = '<p>';
                    $message_content[] = $ays_pb_send_file_content;
                    $message_content[] = '<strong>'. $ays_pb_send_file_name . '</strong>';
                $message_content[] = '<p/>';
            }else{
                $message_content[] = __("You have received this file ", $this->plugin_name) . '<strong>'. $ays_pb_send_file_name . '</strong>';
            }
            
            $message_content = implode( '', $message_content );

            $user_display_name = '';
            $sub_send_file_options = array();
            if($ays_pb_current_popup_id){
                if($ays_pb_send_mail){
                    if (!isset($_COOKIE['ays_popupbox_hide_after_subscribe_cookie_name_'.$ays_pb_current_popup_id])) {
                        
                        $user_id = get_current_user_id();
                        $current_user_data = get_userdata( $user_id );

                        if ( ! is_null( $current_user_data ) && $current_user_data ) {
                            $user_display_name = ( isset( $current_user_data->data->display_name ) && $current_user_data->data->display_name != '' ) ? sanitize_text_field( $current_user_data->data->display_name ) : "";
                            $user_last_name = ( isset( $current_user_data->data->user_last_name ) && $current_user_data->data->user_last_name != '' ) ? sanitize_text_field( $current_user_data->data->user_last_name ) : "";
                        }
                        
                        foreach($ays_pb_popup_attributes as $attr_key => &$attr_value){
                            $attr_value = sanitize_text_field($attr_value);
                        }
                        
                        $user_data = wp_get_current_user();
                        
                        $subscribes_table = esc_sql($wpdb->prefix."ays_pb_subscribes");
                        $sub_send_file_options['popup_attributes'] = $ays_pb_popup_attributes;
                        
                        $x = $wpdb->insert(
                            $subscribes_table,
                            array(
                                'pb_id'             => $ays_pb_current_popup_id,
                                'user_id'           => get_current_user_id(),
                                'user_ip'           => $this->get_user_ip(),
                                'subscribe_email'   => $ays_pb_send_mail,
                                'user_name'         => $user_display_name,
                                'date'              => current_time( 'mysql' ),
                                'options'           => json_encode($sub_send_file_options),
                                'read'              => 0,
                            ),
                            array('%d','%s','%s', '%s', '%s', '%s','%s','%d')
                        );
                         
                        $to = $ays_pb_send_mail;
                        $subject = isset($_REQUEST['popupbox_title']) && $_REQUEST['popupbox_title'] != '' ? $_REQUEST['popupbox_title'] : "Popup Box";

                        $prefix = $wpdb->prefix;
                        $query = "SELECT options FROM {$prefix}ays_pb WHERE id = {$_REQUEST['current_popup_id']}"; 
                        
                        $result = $wpdb->get_var($query);
                        $pb_option['author'] = json_decode($result, true);
                        $pb_option = json_decode($result, true);
                        $current_popup_author = json_decode($pb_option['author']);
                        $message = $message_content;
                        $message_data = array(
                            'user_name'              => $user_display_name,
                            'user_email'             => $ays_pb_send_mail,
                            'user_first_name'        => $user_data->user_firstname,
                            'user_last_name'         => $user_data->user_lastname,
                            'current_popup_author'   => $current_popup_author->name,
                            'user_wordpress_roles'   => $user_data->roles[0],
                        );
                        
                        $message = Ays_Pb_Data::replace_message_variables( $message, $message_data );
                        
                        $nfrom = 'From: <noreply@'.$nsite_url.'>' . "\r\n";
                        $nreply = 'Reply-To:' .'<noreply@'.$nsite_url.'>'."\r\n";
                        
                        $headers = $nfrom; 
                        $headers .= "MIME-Version: 1.0\r\n";
                        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";   
                        $headers .= $nreply;  

                        if ($attachment_path) {
                            $mail_send_file = wp_mail($to, $subject, $message, $headers, $attachment_path) ? true : false;
                            $integrations_args = apply_filters( 'ays_pb_front_end_integrations_options', array(),json_decode($popupbox['options'], true) );
                            do_action( 'ays_pb_front_end_integrations', $integrations_args, json_decode($popupbox['options'], true), $message_data );
                        }

                        $cookie_name = 'ays_popupbox_hide_after_subscribe_cookie_name_'.$ays_pb_current_popup_id;
                        $cookie_value = 'ays_popupbox_hide_after_subscribe_cookie_value'.$ays_pb_current_popup_id;
                        $cookie_expiration = time() + (30 * 24 * 60 * 60);
                        setcookie($cookie_name, $cookie_value, $cookie_expiration, '/');

                        return false;
                    }  
                }
            }

    }

    public function setPopupPosition( $id, $position, $view_type, $isCloseBtnOff, $pb_margin, $pb_height ) {
        $popupbox_view = "";
        switch ( $position){

            case "center-center":
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({'top': '0', 'right': '0', 'bottom': '0', 'left': '0'});";
                break;
            case "left-top":
                if(($view_type === 'image' || $view_type === 'minimal')  && $isCloseBtnOff){
                    $ays_pb_conteiner_pos = "35px";
                }else{
                    $ays_pb_conteiner_pos = 0;
                }
                $popupbox_view  = "jQuery(document).find('.ays-pb-modal_".$id."').css({'top': '".$ays_pb_conteiner_pos."',  'left': '0','right': 'unset','bottom':'unset', 'margin': '".$pb_margin."px'});";
                break;
            case "top-center":
                if(($view_type === 'image' || $view_type === 'minimal') && $isCloseBtnOff){
                    $ays_pb_conteiner_pos = "35px";
                }else{
                    $ays_pb_conteiner_pos = 0;
                }
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({'top': '".$ays_pb_conteiner_pos."',  'left': '0','right': '0','bottom':'unset', 'margin': '".$pb_margin."px auto'});";
                break;    
            case "right-top":
                if(($view_type === 'image' || $view_type === 'minimal') && $isCloseBtnOff){
                    $ays_pb_conteiner_pos = "35px";
                }else{
                    $ays_pb_conteiner_pos = 0;
                }
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({'top': '".$ays_pb_conteiner_pos."', 'right': '0','left':'unset','bottom':'unset', 'margin': '".$pb_margin."px'});";
                break;
            case "left-center":
                $popupbox_view = "var popupHeight = ".($pb_height).";
                                    var userScreenHeight = (jQuery(window).height());
                                    var result = (userScreenHeight - popupHeight)/2 + 'px';
                                    jQuery(document).find('.ays-pb-modal_".$id."').css({'top': result,  'left': '0','right': 'unset','bottom':'unset', 'margin': '".$pb_margin."px'});";
                break; 
            case "right-center":
                $popupbox_view = "var popupHeight = ".($pb_height/2).";
                                    var userScreenHeight = (jQuery(window).height()/2);
                                    var result = (userScreenHeight - popupHeight) + 'px';
                                    jQuery(document).find('.ays-pb-modal_".$id."').css({'top': result,  'left': 'unset','right': '0','bottom':'unset', 'margin': '".$pb_margin."px'});";
                break;       
            case "right-bottom":
                if($view_type === 'image' || $view_type === 'minimal'){
                    $ays_pb_conteiner_pos = "35px";
                }else{
                    $ays_pb_conteiner_pos = 0;
                }
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({'right': '0', 'bottom': '".$ays_pb_conteiner_pos."', 'left': 'unset','top':'unset', 'margin': '".$pb_margin."px'});";
                break;
            case "center-bottom":
                if($view_type === 'image' || $view_type === 'minimal'){
                    $ays_pb_conteiner_pos = "35px";
                }else{
                    $ays_pb_conteiner_pos = 0;
                }
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({'top': 'unset',  'left': '0','right': '0','bottom':'".$ays_pb_conteiner_pos."', 'margin': '".$pb_margin."px auto'});";
                break;    
            case "left-bottom":
                if($view_type === 'image' || $view_type === 'minimal'){
                    $ays_pb_conteiner_pos = "35px";
                }else{
                    $ays_pb_conteiner_pos = 0;
                }
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({ 'bottom': '".$ays_pb_conteiner_pos."', 'left': '0', 'top':'unset','right':'unset', 'margin': '".$pb_margin."px'});";
                break;
            default:
                $popupbox_view = "jQuery(document).find('.ays-pb-modal_".$id."').css({'top': '0', 'right': '0', 'bottom': '0', 'left': '0'});";
                break;
        }

        return $popupbox_view;
    }
}
