<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Ays_Pb
 * @subpackage Ays_Pb/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Ays_Pb
 * @subpackage Ays_Pb/includes
 * @author     AYS Pro LLC <info@ays-pro.com>
 */
class Ays_Pb {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Ays_Pb_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'AYS_PB_NAME_VERSION' ) ) {
			$this->version = AYS_PB_NAME_VERSION;
		} else {
			$this->version = '1.0.1';
		}
		$this->plugin_name = 'ays-pb';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();
		$this->define_integrations_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Ays_Pb_Loader. Orchestrates the hooks of the plugin.
	 * - Ays_Pb_i18n. Defines internationalization functionality.
	 * - Ays_Pb_Admin. Defines all hooks for the admin area.
	 * - Ays_Pb_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

    if ( ! class_exists( 'WP_List_Table' ) ) {
    	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
    }

		/**
		 * The class responsible for defining all finctions for using anywhere.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-ays-pb-data.php';

		/**
		 * The class responsible for defining all functions for getting all survey integrations
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-ays-pb-integrations.php';

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-ays-pb-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-ays-pb-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-ays-pb-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-ays-pb-public.php';

		/*
	   * The class is responsible for showing popup boxes in wordpress default WP_LIST_TABLE style
	   */
  	require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-list-table.php';

    /**
		 * The class is responsible for showing popup box categories
 		 */
    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-popup-categories-list-table.php';

    /*
    * The class is responsible for showing popup boxes custom fields in wordpress default WP_LIST_TABLE style
    */
    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-popup-attributes-list-table.php';


    /*
     * The class is responsible for showing popup boxes results in wordpress default WP_LIST_TABLE style
     */
    require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-reports-list-table.php';

    /*
    * The class is responsible for showing popup boxes results in wordpress default WP_LIST_TABLE style
    */
    // require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-subscribes-list-table.php';

	require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-submissions-list-table.php';

	/*
	* The class is responsible for showing each popup submissions in wordpress default WP_LIST_TABLE style
	*/
	require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/lists/class-ays-pb-each-submission-list-table.php';


    /**
		 * The class is responsible for showing popup box settings
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/partials/settings/popup-box-settings-actions.php';

		/**
		 * The class is responsible for showing User Information Shortdodes
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/class-ays-pb-user-information-shortcodes.php';

		/**
		 * The class is responsible for showing PB Categories Shortdodes
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/partials/class-pb-category-shortcode.php';

		
		$this->loader = new Ays_Pb_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Ays_Pb_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Ays_Pb_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Ays_Pb_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_head', $plugin_admin, 'admin_menu_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'disable_scripts', 100 );

    // Add menu item
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_admin_menu' );

    // Add Popups submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_popups_submenu', 75 );

    // Add Popup categories
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_categories_submenu', 80 );

    // Add Popup attributes
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_custom_fields_submenu', 85 );

    // Add Reports submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_reports_submenu', 90 );

    // Add Export/Import submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_export_import_submenu', 95 );

    // Add Subscribes submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_submissions_submenu', 100 );

    //Add Settings submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_settings_submenu', 105 );

    // Add Affiliate submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_affiliate_submenu', 110 );

    //Add Our Products submenu
    $this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_featured_plugins_submenu', 115 );

		
		// Add Settings link to the plugin
    $plugin_basename = plugin_basename( plugin_dir_path( __DIR__ ) . $this->plugin_name . '.php' );
    $this->loader->add_filter( 'plugin_action_links_' . $plugin_basename, $plugin_admin, 'add_action_links' );

    $this->loader->add_action( 'wp_ajax_deactivate_plugin_option_pb', $plugin_admin, 'deactivate_plugin_option');
    $this->loader->add_action( 'wp_ajax_nopriv_deactivate_plugin_option_pb', $plugin_admin , 'deactivate_plugin_option');
    $this->loader->add_action( 'wp_ajax_get_selected_options_pb', $plugin_admin, 'get_selected_options_pb');
    $this->loader->add_action( 'wp_ajax_ays_pb_add_reports', $plugin_admin, 'ays_pb_add_reports');
    $this->loader->add_action( 'wp_ajax_nopriv_ays_pb_add_reports', $plugin_admin, 'ays_pb_add_reports');
		$this->loader->add_action( 'wp_ajax_ays_pb_export_json', $plugin_admin, 'ays_pb_export_json' );
		$this->loader->add_action( 'wp_ajax_nopriv_ays_pb_export_json', $plugin_admin, 'ays_pb_export_json' );

		//Code Mirror
    $this->loader->add_action('admin_enqueue_scripts', $plugin_admin, 'codemirror_enqueue_scripts');
		
		//Generate Coupon
		$this->loader->add_action( 'wp_ajax_generate_coupons', $plugin_admin, 'generate_coupons' );
    $this->loader->add_action( 'wp_ajax_nopriv_generate_coupons', $plugin_admin, 'generate_coupons' );

	// Update database tables
	$this->loader->add_action( 'wp_ajax_ays_pb_update_database_tables', $plugin_admin, 'ays_pb_update_database_tables' );
	$this->loader->add_action( 'wp_ajax_nopriv_ays_pb_update_database_tables', $plugin_admin, 'ays_pb_update_database_tables' );

	// Admin AJAX action
    $this->loader->add_action( 'wp_ajax_ays_popup_admin_ajax', $plugin_admin, 'ays_popup_admin_ajax' );
    $this->loader->add_action( 'wp_ajax_nopriv_ays_popup_admin_ajax', $plugin_admin, 'ays_popup_admin_ajax' );

    $this->loader->add_action( 'wp_ajax_ays_pb_show_results', $plugin_admin, 'ays_pb_show_results' );
    $this->loader->add_action( 'wp_ajax_nopriv_ays_pb_show_results', $plugin_admin, 'ays_pb_show_results' );

    $this->loader->add_action( 'in_admin_footer', $plugin_admin, 'popup_box_admin_footer', 1 );

	$this->loader->add_action( 'wp_ajax_ays_pb_results_export_file', $plugin_admin, 'ays_pb_results_export_file' );
    $this->loader->add_action( 'wp_ajax_nopriv_ays_pb_results_export_file', $plugin_admin, 'ays_pb_results_export_file' );

	$this->loader->add_action( 'wp_ajax_ays_pb_create_author', $plugin_admin, 'ays_pb_create_author' );
	$this->loader->add_action( 'wp_ajax_nopriv_ays_pb_create_author', $plugin_admin, 'ays_pb_create_author' );

	$this->loader->add_action( 'wp_ajax_close_warning_note_permanently', $plugin_admin, 'close_warning_note_permanently' );
	$this->loader->add_action( 'wp_ajax_nopriv_close_warning_note_permanently', $plugin_admin, 'close_warning_note_permanently' );
  }

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Ays_Pb_Public( $this->get_plugin_name(), $this->get_version() );
		$plugin_public_user_information = new Ays_Popup_Box_User_Information_Public( $this->get_plugin_name(), $this->get_version() );
		$plugin_public_category = new Popup_Box_Popup_Category( $this->get_plugin_name(), $this->get_version() );
		/*
		 * Generating shortcode on init action
		 */
		$this->loader->add_action( 'init', $plugin_public, 'ays_generate_shortcode');
		$this->loader->add_action( 'wp_footer', $plugin_public, 'ays_shortcodes_show_all');
		$this->loader->add_action( 'wp_footer', $plugin_public, 'ays_shortcodes_category_show_all');
    $this->loader->add_action( 'ays_pb_template_mac', $plugin_public, 'ays_pb_template_macos');
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		$this->loader->add_action( 'wp_footer', $plugin_public, 'enqueue_styles_footer' );

		$this->loader->add_action( 'wp_ajax_ays_pb_set_cookie_only_once', $plugin_public, 'ays_pb_set_cookie_only_once');
    $this->loader->add_action( 'wp_ajax_nopriv_ays_pb_set_cookie_only_once', $plugin_public , 'ays_pb_set_cookie_only_once');

		//Get Coupon
		$this->loader->add_action( 'wp_ajax_get_pb_coupons', $plugin_public, 'get_pb_coupons' );
    $this->loader->add_action( 'wp_ajax_nopriv_get_pb_coupons', $plugin_public, 'get_pb_coupons' );
		
		//Used Coupon
		$this->loader->add_action( 'wp_ajax_pb_used_coupons', $plugin_public, 'pb_used_coupons' );
    $this->loader->add_action( 'wp_ajax_nopriv_pb_used_coupons', $plugin_public, 'pb_used_coupons' );

		//Subscribe and get file
		$this->loader->add_action( 'wp_ajax_ays_pb_subscribe_get_file', $plugin_public, 'ays_pb_subscribe_get_file' );
		$this->loader->add_action( 'wp_ajax_nopriv_ays_pb_subscribe_get_file', $plugin_public, 'ays_pb_subscribe_get_file' );


	}

		/**
	 * Register all of the hooks related to the integrations functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_integrations_hooks() {

		$plugin_integrations = new Popup_Box_Integrations( $this->get_plugin_name(), $this->get_version() );

		// Popup Box Integrations / popup page
		$this->loader->add_action( 'ays_pb_popup_page_integrations', $plugin_integrations, 'ays_popup_page_integrations_content' );		
		
		// Popup Box Integrations / settings page
		$this->loader->add_action( 'ays_pb_settings_page_integrations', $plugin_integrations, 'ays_settings_page_integrations_content' );

		// ===== MailChimp integration ====
			// MailChimp integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_mailchimp_content', 1, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_mailchimp_save', 1, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_mailchimp_options', 1, 2 );

			// MailChimp integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_mailchimp_content', 1, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_mailchimp_save', 1, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_mailchimp_options', 1, 2 );

			// MailChimp integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_mailchimp_options', 1, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_mailchimp_functional', 1, 3 );
		// ===== MailChimp integration ====

		// ===== Campaign Monitor integration =====
			// Campaign Monitor integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_camp_monitor_content', 20, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_camp_monitor_save', 20, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_camp_monitor_options', 20, 2 );

			// Campaign Monitor integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_campaign_monitor_content', 20, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_campaign_monitor_save', 20, 2 );
			
			// Campaign Monitor integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_campaign_monitor_options', 20, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_campaign_monitor_functional', 20, 3 );
		// ===== Campaign Monitor integration =====

		// ===== Active Campaign integration =====
			// Active Campaign integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_active_camp_content', 30, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_active_camp_save', 30, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_active_camp_options', 30, 2 );

			// Active Campaign integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_active_camp_content', 30, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_active_camp_save', 30, 2 );

			// Active Campaign integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_active_camp_options', 30, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_active_camp_functional', 30, 3 );
		// ===== Active Campaign integration =====
		
		// ===== GetResponse integration ====
			// GetResponse integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_get_response_content', 100, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_get_response_save', 100, 2 );

			// GetResponse integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_get_response_content', 100, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_get_response_options', 100, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_get_response_save', 100, 2 );

			// GetResponse integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_get_response_options', 100, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_get_response_functional', 100, 3 );
		// ===== GetResponse integration ====

		// ===== ConvertKit integration ====
			// ConvertKit integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_convert_kit_content', 110, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_convert_kit_save', 110, 2 );

			// ConvertKit integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_convert_kit_content', 110, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_convert_kit_options', 110, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_convert_kit_save', 110, 2 );

			// ConvertKit integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_convert_kit_options', 110, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_convert_kit_functional', 110, 3 );
		// ===== ConvertKit integration ====

		// ===== Sendinblue integration ====
			// Sendinblue integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_sendinblue_content', 115, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_sendinblue_save', 115, 2 );

			// Sendinblue integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_sendinblue_content', 115, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_sendinblue_options', 115, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_sendinblue_save', 115, 2 );

			// Sendinblue integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_sendinblue_options', 115, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_sendinblue_functional', 115, 3 );
		// ===== Sendinblue integration ====

		// ===== MailerLite integration ====
			// MailerLite integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_mailerLite_content', 120, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_mailerLite_save', 120, 2 );

			// MailerLite integration / popup page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_mailerLite_content', 120, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_mailerLite_options', 120, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_mailerLite_save', 120, 2 );

			// MailerLite integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_mailerLite_options', 120, 2 );
			$this->loader->add_action( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_mailerLite_functional', 120, 3 );
		// ===== MailerLite integration ====

		// ===== reCAPTCHA integration ====
			// reCAPTCHA integration / settings page
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_contents', $plugin_integrations, 'ays_settings_page_recaptcha_content', 135, 2 );
			$this->loader->add_filter( 'ays_pb_settings_page_integrations_saves', $plugin_integrations, 'ays_settings_page_recaptcha_save', 125, 2 );

			// reCAPTCHA integration / survey page
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_contents', $plugin_integrations, 'ays_popup_page_recaptcha_content', 125, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_options', $plugin_integrations, 'ays_popup_page_recaptcha_options', 125, 2 );
			$this->loader->add_filter( 'ays_pb_popup_page_integrations_saves', $plugin_integrations, 'ays_popup_page_recaptcha_save', 125, 2 );

			// reCAPTCHA integration / front-end
			$this->loader->add_filter( 'ays_pb_front_end_integrations_options', $plugin_integrations, 'ays_front_end_recaptcha_options', 125, 2 );
			$this->loader->add_filter( 'ays_pb_front_end_integrations', $plugin_integrations, 'ays_front_end_recaptcha_functional', 125, 3 );
		// ===== reCAPTCHA integration ====
	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Ays_Pb_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
