<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Popup_Box
 * @subpackage Popup_Box/includes
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Popup_Box
 * @subpackage Popup_Box/includes
 * @author     AYS Pro LLC <info@ays-pro.com>
 */
class Popup_Box_Integrations
{

    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $plugin_name The ID of this plugin.
     */
    private $plugin_name;

    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string $version The current version of this plugin.
     */
    private $version;

    private $settings_obj;

    private $capability;

    private $blockquote_content;

    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string $plugin_name The name of this plugin.
     * @param      string $version The version of this plugin.
     */
    public function __construct($plugin_name, $version){
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        $this->settings_obj = new Ays_PopupBox_Settings_Actions($this->plugin_name);

        $settings_url = sprintf(
            __( "For enabling this option, please go to %s page and fill all options.", $this->plugin_name ),
            "<a style='color:blue;text-decoration:underline;font-size:20px;' href='?page=".$this->plugin_name."-settings&ays_pb_tab=tab3' target='_blank'>". __( "this", $this->plugin_name ) ."</a>"
        );
        $blockquote_content = '<blockquote class="error_message">'. $settings_url .'</blockquote>';
        $this->blockquote_content = $blockquote_content;
    }

    // ===== INTEGRATIONS HOOKS =====

    // Integrations popup page action hook
    public function ays_popup_page_integrations_content( $args ){

        // if( ! Ays_Pb_Data::popup_box_capabilities_for_editing() ){
        //     $settings_url = __( "This functionality is disabled.", $this->plugin_name );
        //     $blockquote_content = '<blockquote class="error_message">'. $settings_url .'</blockquote>';
        //     $this->blockquote_content = $blockquote_content;
        // }

        $integrations_contents = apply_filters( 'ays_pb_popup_page_integrations_contents', array(), $args );
        
        $integrations = array();

        foreach ($integrations_contents as $key => $integrations_content) {
            $content = '<fieldset>';
            if(isset($integrations_content['title'])){
                $content .= '<legend>';
                if(isset($integrations_content['icon'])){
                    $content .= '<img class="ays_integration_logo" src="'. $integrations_content['icon'] .'" alt="">';
                }
                $content .= '<h5>'. $integrations_content['title'] .'</h5></legend>';
            }
            $content .= $integrations_content['content'];

            $content .= '</fieldset>';

            $integrations[] = $content;
        }

        echo implode('<hr/>', $integrations);

    }

    // Integrations settings page action hook
    public function ays_settings_page_integrations_content( $args ){

        $integrations_contents = apply_filters( 'ays_pb_settings_page_integrations_contents', array(), $args );
        
        $integrations = array();

        foreach ($integrations_contents as $key => $integrations_content) {
            $content = '<fieldset>';
            if(isset($integrations_content['title'])){
                $content .= '<legend>';
                if(isset($integrations_content['icon'])){
                    $content .= '<img class="ays_integration_logo" src="'. $integrations_content['icon'] .'" alt="">';
                }
                $content .= '<h5>'. $integrations_content['title'] .'</h5></legend>';
            }
            if(isset($integrations_content['content'])){
                $content .= $integrations_content['content'];
            }

            $content .= '</fieldset>';

            $integrations[] = $content;
        }

        echo implode('<hr/>', $integrations);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== MailChimp integration start =====

        // MailChimp integration / popup page

        // MailChimp integration in popup page content
        public function ays_popup_page_mailchimp_content( $integrations, $args ){
            
            $popup_settings = $this->settings_obj;
            $mailchimp_res = ($popup_settings->ays_get_setting('mailchimp') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('mailchimp');
            $mailchimp = json_decode($mailchimp_res, true);
            $mailchimp_username = isset($mailchimp['username']) ? $mailchimp['username'] : '' ;
            $mailchimp_api_key = isset($mailchimp['apiKey']) ? $mailchimp['apiKey'] : '' ;
            $mailchimp_lists = $this->ays_get_mailchimp_lists($mailchimp_username, $mailchimp_api_key);
            $enable_mailchimp = $args['enable_mailchimp'];
            $mailchimp_list = $args['mailchimp_list'];
            // $enable_mailchimp = isset($args['enable_mailchimp']) && $args['enable_mailchimp'] == "on" ? true : false;
            // $mailchimp_list = isset($args['mailchimp_list']) && $args['mailchimp_list'] != '' ? $args['mailchimp_list'] : '';


            $mailchimp_select = array();
            if(isset($mailchimp_lists['total_items']) && $mailchimp_lists['total_items'] > 0){
                foreach($mailchimp_lists['lists'] as $list){
                    $mailchimp_select[] = array(
                        'listId' => $list['id'],
                        'listName' => $list['name']
                    );
                }
            }else{
                $mailchimp_select = __( "There are no lists", $this->plugin_name );
            }

            $icon = AYS_PB_ADMIN_URL .'/images/integrations/mailchimp_logo.png';
            $title = __('MailChimp Settings',$this->plugin_name);

            $content = '';
            if(count($mailchimp) > 0){
                if($mailchimp_username == "" || $mailchimp_api_key == ""){
                    $content .= $this->blockquote_content;
                }else{
                    $disabled = ($mailchimp_username == "" || $mailchimp_api_key == "") ? "disabled" : '';
                    $checked = ($enable_mailchimp == true) ? "checked" : '';
                
                    $content .= '<div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_enable_mailchimp">'. __('Enable MailChimp',$this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_enable_mailchimp" name="ays_enable_mailchimp" value="on" '.$checked.' '.$disabled.'>';
                    $content .= '
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_mailchimp_list">'. __('MailChimp list',$this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-8">';
                    if(is_array($mailchimp_select)){
                        $content .= '<select name="ays_mailchimp_list" id="ays_mailchimp_list" '.$disabled.'>';
                        $content .= '<option value="" disabled selected>'. __( "Select list", $this->plugin_name ) .'</option>';
                        foreach($mailchimp_select as $mlist){
                            $mselected = ($mailchimp_list == $mlist['listId']) ? 'selected' : '';
                            $content .= '<option '. $mselected .' value="'. $mlist['listId'] .'">'. $mlist['listName'] .'</option>';
                        }
                        $content .= '</select>';
                    }else{
                        $content .= '<span>'. $mailchimp_select .'</span>';
                    }
                    $content .= '</div>
                    </div>';
                }
            }else{
                $content .= $this->blockquote_content;
            }

            $integrations['mailchimp'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title,
            );

            return $integrations;        
        }

        // MailChimp integration in popup page options
        public function ays_popup_page_mailchimp_options( $args, $options ){

            // MailChimp
            $args['enable_mailchimp'] = ( isset( $options['enable_mailchimp'] ) && $options['enable_mailchimp'] == 'on' ) ? true : false;
            $args['mailchimp_list'] = ( isset( $options['mailchimp_list'] ) ) ? $options['mailchimp_list'] : '';

            return $args;
        }

        // MailChimp integration in popup page data saver
        public function ays_popup_page_mailchimp_save( $options, $data ){

            // MailChimp
            $options['enable_mailchimp'] = ( isset( $data['ays_enable_mailchimp'] ) && $data['ays_enable_mailchimp'] == 'on' ) ? 'on' : 'off';
            $options['mailchimp_list'] = !isset( $data['ays_mailchimp_list'] ) ? "" : $data['ays_mailchimp_list'];

            return $options;
        }

        // MailChimp integration / settings page

        // MailChimp integration in General settings page content
        public function ays_settings_page_mailchimp_content( $integrations, $args ){

            $actions = $this->settings_obj;

            $mailchimp_res = ( $actions->ays_get_setting( 'mailchimp' ) === false ) ? json_encode(array()) : $actions->ays_get_setting( 'mailchimp' );
            $mailchimp = json_decode( $mailchimp_res, true );
            $mailchimp_username = isset($mailchimp['username']) ? $mailchimp['username'] : '' ;
            $mailchimp_api_key = isset($mailchimp['apiKey']) ? $mailchimp['apiKey'] : '' ;

            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/mailchimp_logo.png';
            $title = __( 'MailChimp', $this->plugin_name );

            $content = '';
            $content .= '<div class="form-group row">
                <div class="col-sm-12">
                    <div class="form-group row" aria-describedby="aaa">
                        <div class="col-sm-3">
                            <label for="ays_mailchimp_username">'. __( 'MailChimp Username', $this->plugin_name ) .'</label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" 
                                class="ays-text-input" 
                                id="ays_mailchimp_username" 
                                name="ays_mailchimp_username"
                                value="'. $mailchimp_username .'"
                            />
                        </div>
                    </div>
                    <hr/>
                    <div class="form-group row" aria-describedby="aaa">
                        <div class="col-sm-3">
                            <label for="ays_mailchimp_api_key">'. __( 'MailChimp API Key', $this->plugin_name ) .'</label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" 
                                class="ays-text-input" 
                                id="ays_mailchimp_api_key" 
                                name="ays_mailchimp_api_key"
                                value="'. $mailchimp_api_key .'"
                            />
                        </div>
                    </div>
                    <blockquote>';
            $content .= sprintf( __( "You can get your API key from your ", $this->plugin_name ) . "<a href='%s' target='_blank'> %s.</a>", "https://us20.admin.mailchimp.com/account/api/", "Account Extras menu" );
            $content .= '</blockquote>
                </div>
            </div>';

            $integrations['mailchimp'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;        
        }

        // MailChimp integration in General settings page data saver
        public function ays_settings_page_mailchimp_save( $fields, $data ){

            $mailchimp_username = isset($data['ays_mailchimp_username']) ? $data['ays_mailchimp_username'] : '';
            $mailchimp_api_key = isset($data['ays_mailchimp_api_key']) ? $data['ays_mailchimp_api_key'] : '';
            $mailchimp = array(
                'username' => $mailchimp_username,
                'apiKey'   => $mailchimp_api_key
            );

            // MailChimp
            $fields['mailchimp'] = $mailchimp;

            return $fields;
        }

        // MailChimp integration / front-end
        
        // MailChimp integration in front-end functional
        public function ays_front_end_mailchimp_functional( $arguments, $options, $data ){
            if( isset( $arguments['enable_mailchimp'] ) && $arguments['enable_mailchimp'] ){
                if( !empty( $data['user_email'] ) ){

                    $mailchimp_fname = "";
                    $mailchimp_lname = "";
                    if( !empty( $data['user_name'] ) ){
                        $user_name = explode( " ", $data['user_name'] );
                        $mailchimp_fname = (isset($user_name[0]) && $user_name[0] != "") ? $user_name[0] : "";
                        $mailchimp_lname = (isset($user_name[1]) && $user_name[1] != "") ? $user_name[1] : "";
                    }
                    
                    $args = array(
                        "email" => $data['user_email'],
                        "fname" => $mailchimp_fname,
                        "lname" => $mailchimp_lname
                    );

                    $popup_settings = $this->settings_obj;
                    $mailchimp_list = $arguments['mailchimp_list'];
                    $mailchimp_res = ($popup_settings->ays_get_setting('mailchimp') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('mailchimp');
                    $mailchimp = json_decode($mailchimp_res, true);
                    $mailchimp_username = isset($mailchimp['username']) ? $mailchimp['username'] : '' ;
                    $mailchimp_api_key = isset($mailchimp['apiKey']) ? $mailchimp['apiKey'] : '' ;
                    
                    $mresult = $this->ays_add_mailchimp_transaction($mailchimp_username, $mailchimp_api_key, $mailchimp_list, $args);
                }
            }
        }

        // MailChimp integration in front-end options
        public function ays_front_end_mailchimp_options( $args, $settings ){
            // MailChimp
            $args['enable_mailchimp'] = ( isset($settings['enable_mailchimp'] ) && $settings['enable_mailchimp'] == 'on') ? true : false;
            $args['mailchimp_list'] = (isset($settings['mailchimp_list'])) ? $settings['mailchimp_list'] : '';

            return $args;
        }

    // ===== MailChimp integration end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Campaign Monitor start =====

        // Campaign Monitor integration / popup page

        // Campaign Monitor integration in popup page content
        public function ays_popup_page_camp_monitor_content($integrations, $args){

            $popup_settings = $this->settings_obj;
            $monitor_res     = ($popup_settings->ays_get_setting('monitor') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('monitor');
            $monitor         = json_decode($monitor_res, true);
            $monitor_client  = isset($monitor['client']) ? $monitor['client'] : '';
            $monitor_api_key = isset($monitor['apiKey']) ? $monitor['apiKey'] : '';
            $monitor_lists   = $this->ays_get_monitor_lists($monitor_client, $monitor_api_key);
            $monitor_select  = !isset($monitor_lists['Code']) ? $monitor_lists : __("There are no lists", $this->plugin_name);

            // $saved_options = apply_filters("ays_sm_popup_page_integrations_options", $integrations, $args);
            // $monitor_list = isset($saved_options['monitor_list']) && $saved_options['monitor_list'] != '' ? $saved_options['monitor_list'] : '';

            $enable_monitor  = isset($args['enable_monitor']) && $args['enable_monitor'] == "on" ? true : false;  
            $monitor_list    = isset($args['monitor_list']) && $args['monitor_list'] != '' ? $args['monitor_list'] : '';

            $enable_disabled = '';
            $enable_checked  = '';
            $icon = AYS_PB_ADMIN_URL .'/images/integrations/campaignmonitor_logo.png';
            $title = __('Campaign Monitor Settings',$this->plugin_name);
            $content = '';

            if(count($monitor) > 0){
                if($monitor_client == "" || $monitor_api_key == ""){
                    $content .= $this->blockquote_content;
                }else{
                    $enable_disabled = ($monitor_client == "" || $monitor_api_key == "") ? "disabled" : '';
                    $checked = (isset($enable_monitor) && $enable_monitor) ? "checked" : '';
                    $enable_checked  = (isset($enable_disabled) && $enable_disabled != "disabled") ? $checked : ''; 
                    $content .= '<hr/>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_enable_monitor">'.__('Enable Campaign Monitor', $this->plugin_name).'</label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_enable_monitor"
                                    name="ays_enable_monitor" value="on" '.$enable_disabled.' '.$enable_checked.'/>
                            </div>
                        </div>
                        <hr>
                        <div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_monitor_list">'.__('Campaign Monitor list', $this->plugin_name).'</label>
                            </div>
                            <div class="col-sm-8">';
                        if(is_array($monitor_select)){
                            $content .= '<select name="ays_monitor_list" id="ays_monitor_list" '.$enable_disabled.'>
                            <option disabled>'.__("Select List", $this->plugin_name).'</option>';
                            $selected_list = '';
                            foreach($monitor_select as $mlist){
                                $selected_list = ($monitor_list == $mlist['ListID']) ? "seleted" : '';
                                $content .= '<option '.$selected_list.' value='.$mlist["ListID"].'>'.$mlist["Name"].'</option>';
                            }
                            $content .= '</select>';
                        }else{
                            $content .= '<span>'.$monitor_select.'</span>';
                        }
                    $content .= '</div>';    
                }
            }else{
                $content .= $this->blockquote_content;
            }
            
            $integrations['monitor'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title,
            );

            return $integrations;
        }

        // Campaign Monitor integration in popup page data saver
        public function ays_popup_page_camp_monitor_save( $options, $data ){
            $options['enable_monitor'] = ( isset( $data['ays_enable_monitor'] ) && $data['ays_enable_monitor'] == 'on' ) ? 'on' : 'off';
            $options['monitor_list'] = !isset( $data['ays_monitor_list'] ) ? "" : $data['ays_monitor_list'];

            return $options;
        }

        // Campaign Monitor integration in popup page options
        public function ays_popup_page_camp_monitor_options($args, $options){
            $args['enable_monitor'] = (isset($options['enable_monitor']) && $options['enable_monitor'] == 'on') ? true : false;
            $args['monitor_list'] = (isset($options['monitor_list'])) ? $options['monitor_list'] : '';

            return $args;
        }
        
        // Campaign Monitor integration / settings page

        // Campaign Monitor integration in General settings page
        public function ays_settings_page_campaign_monitor_content( $integrations, $args ){
            $actions = $this->settings_obj;
            
            $monitor_res     = ($actions->ays_get_setting('monitor') === false) ? json_encode(array()) : $actions->ays_get_setting('monitor');
            $monitor         = json_decode($monitor_res, true);
            $monitor_client  = isset($monitor['client']) ? $monitor['client'] : '';
            $monitor_api_key = isset($monitor['apiKey']) ? $monitor['apiKey'] : '';
            
            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/campaignmonitor_logo.png';
            $title = __( 'Campaign Monitor', $this->plugin_name );

            $content = '';
            $content .= '<div class="form-group row">
                <div class="col-sm-12">
                    <div class="form-group row" aria-describedby="aaa">
                        <div class="col-sm-3">
                            <label for="ays_monitor_client">'. __( 'Campaign Monitor Client ID', $this->plugin_name ) .'</label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" 
                                class="ays-text-input" 
                                id="ays_monitor_client" 
                                name="ays_monitor_client"
                                value="'. $monitor_client .'"
                            />
                        </div>
                    </div>
                    <hr/>
                    <div class="form-group row" aria-describedby="aaa">
                        <div class="col-sm-3">
                            <label for="ays_monitor_api_key">'. __( 'Campaign Monitor API Key', $this->plugin_name ) .'</label>
                        </div>
                        <div class="col-sm-9">
                            <input type="text" 
                                class="ays-text-input" 
                                id="ays_monitor_api_key" 
                                name="ays_monitor_api_key"
                                value="'. $monitor_api_key .'"
                            />
                        </div>
                    </div>
                    <blockquote>';
            $content .= __( "You can get your API key and Client ID from your Account Settings page.");
            $content .= '</blockquote>
                </div>
            </div>';

            $integrations['monitor'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title
            );

            return $integrations;
        }

        // Campaign Monitor integration in General settings data saver
        public function ays_settings_page_campaign_monitor_save( $fields, $data ){

            $monitor_client  = isset($data['ays_monitor_client']) ? $data['ays_monitor_client'] : '';
            $monitor_api_key = isset($data['ays_monitor_api_key']) ? $data['ays_monitor_api_key'] : '';
            $monitor         = array(
                'client' => $monitor_client,
                'apiKey' => $monitor_api_key
            );
                
            $fields['monitor'] = $monitor;

            return $fields;
        }

        // Campaign Monitor integration / front-end
        
        // Campaign Monitor integration in front-end functional
        public function ays_front_end_campaign_monitor_functional( $arguments, $options, $data ){
            
            if( isset( $arguments['enable_monitor'] ) && $arguments['enable_monitor'] ){
                if( !empty( $data['user_email'] ) ){

                    $mailchimp_fname = "";
                    $mailchimp_lname = "";
                    
                    $args = array(
                        "EmailAddress" => $data['user_email'],
                        "Name" => $data['user_name']
                    );

                    $monitor_list  = $arguments['monitor_list'];
                    $popup_settings = $this->settings_obj;
                    $monitor_res     = ($popup_settings->ays_get_setting('monitor') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('monitor');
                    $monitor         = json_decode($monitor_res, true);
                    $monitor_client  = isset($monitor['client']) ? $monitor['client'] : '';
                    $monitor_api_key = isset($monitor['apiKey']) ? $monitor['apiKey'] : '';

                    $mresult = $this->ays_add_monitor_transaction($monitor_client, $monitor_api_key, $monitor_list, $args);
                }
            }
        }

        // Campaign Monitor integration in front-end options
        public function ays_front_end_campaign_monitor_options( $args, $settings ){
            // Campaign Monitor
            $args['enable_monitor'] = ( isset($settings['enable_monitor'] ) && $settings['enable_monitor'] == 'on') ? true : false;
            $args['monitor_list'] = (isset($settings['monitor_list'])) ? $settings['monitor_list'] : '';

            return $args;
        }

    // ===== Campaign Monitor end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Active Campaign start =====

        // Active Campaign integration / popup page
        
        // Active Campaign integration in popup page content
        public function ays_popup_page_active_camp_content($integrations, $args){

            $popup_settings = $this->settings_obj;
            $active_camp_res               = ($popup_settings->ays_get_setting('active_camp') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('active_camp');
            $active_camp                   = json_decode($active_camp_res, true);
            $active_camp_url               = isset($active_camp['url']) ? $active_camp['url'] : '';
            $active_camp_api_key           = isset($active_camp['apiKey']) ? $active_camp['apiKey'] : '';
            $active_camp_lists             = $this->ays_get_active_camp_data('lists', $active_camp_url, $active_camp_api_key);
            $active_camp_automations       = $this->ays_get_active_camp_data('automations', $active_camp_url, $active_camp_api_key);
            
            $icon = AYS_PB_ADMIN_URL .'/images/integrations/activecampaign_logo.png';
            $title = __('ActiveCampaign Settings', $this->plugin_name);

            if ( isset($active_camp_lists['errors']) && ! empty($active_camp_lists['errors']) ) {
                // Your account has been expired for over a month.
                $integrations['active_camp'] = array(
                    'content' => $active_camp_lists['errors'][0]['title'], // Account expired
                    'icon'    => $icon,
                    'title'   => $title,
                );

                return $integrations;
            }

            $active_camp_list_select       = !isset($active_camp_lists['Code']) && isset( $active_camp_lists['lists'] ) ? $active_camp_lists['lists'] : __("There are no lists", $this->plugin_name);
            $active_camp_automation_select = !isset($active_camp_automations['Code']) && isset( $active_camp_automations['automations'] ) ? $active_camp_automations['automations'] : __("There are no automations", $this->plugin_name);
            $enable_disabled = '';
            $enable_checked  = '';
            $content = '';
            
            // $saved_options = apply_filters("ays_sm_popup_page_integrations_options",$integrations,$args);
            $enable_active_camp = (isset($args['enable_active_camp']) && $args['enable_active_camp'] == 'on') ? true : false;
            $active_camp_list = isset($args['active_camp_list']) && $args['active_camp_list'] != '' ? $args['active_camp_list'] : '';
            $active_camp_automation = isset($args['active_camp_automation']) && $args['active_camp_automation'] != '' ? $args['active_camp_automation'] : '';

            $content = '';
            if (count($active_camp) > 0){
                if ($active_camp_url == "" || $active_camp_api_key == ""){
                    $content .= $this->blockquote_content;
                }else{
                    $enable_disabled = ($active_camp_api_key != '' && $active_camp_url == "") ? "disabled" : '';
                    $checked = ($enable_active_camp) ? 'checked' : '';
                    $enable_checked  = isset($enable_disabled) && $enable_disabled != "disabled" ? $checked : ''; 
                    $content .= '<hr/>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_enable_active_camp">'. __('Enable ActiveCampaign', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_enable_active_camp" name="ays_enable_active_camp" value="on" '.$enable_disabled.' '.$enable_checked.'>
                        </div>
                    </div>
                    <hr/>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_active_camp_list">'.__('ActiveCampaign list', $this->plugin_name).'</label>
                        </div>
                        <div class="col-sm-8">';
                        if(is_array($active_camp_list_select)){
                            $content .= '<select name="ays_active_camp_list" id="ays_active_camp_list" '.$enable_disabled.'>
                                            <option value="" disabled selected>'. __("Select List", $this->plugin_name) .'</option>
                                            <option value="">'.__("Just create contact", $this->plugin_name).'</option>';
                                            $selected = '';
                                            foreach( $active_camp_list_select as $list ){
                                                $selected = ($active_camp_list == $list["id"]) ? "selected" : '';
                                                $content .= '<option  '.$selected.' value='.$list["id"].'>'.$list["name"].'</option>';
                                            }
                                            $content .= '</select></div>';
                        }else{
                            $content .= '<span>'.$active_camp_list_select.'</span></div>';
                        }
                        $content .= '</div><hr>';
                    $content .= '
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_active_camp_automation">'.__("ActiveCampaign automation", $this->plugin_name).'</label>
                        </div>
                        <div class="col-sm-8">';
                            
                    if(is_array($active_camp_automation_select)){
                        $content .= '<select name="ays_active_camp_automation" id="ays_active_camp_automation" '.$enable_disabled.'>
                            <option value="" disabled selected>'.__("Select List", $this->plugin_name).'</option>
                            <option value="">'.__("Just create contact", $this->plugin_name).'</option>';
                            $selected_auto = '';
                                foreach ( $active_camp_automation_select as $automation ){
                                    $selected_auto = ($active_camp_automation == $automation['id']) ? 'selected' : '';
                                    $content .= '<option '.$selected_auto.' value='.$automation["id"].'>'.$automation["name"].'</option>';
                                }
                                $content .= '</select></div>';
                    }else{
                        $content .= '<span>'.$active_camp_automation_select.'</span></div>';
                    }
                    $content .= '</div>';
                }
            
            }else{
                $content .= $this->blockquote_content;
            }
            $integrations['active_camp'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title,
            );

            return $integrations;
        }

        // Active Campaign integration in popup page options
        public function ays_popup_page_active_camp_options($args, $options){

            $args['enable_active_camp']     = (isset($options['enable_active_camp']) && $options['enable_active_camp'] == 'on') ? true : false;
            $args['active_camp_list']       = (isset($options['active_camp_list'])) ? $options['active_camp_list'] : '';
            $args['active_camp_automation'] = (isset($options['active_camp_automation'])) ? $options['active_camp_automation'] : '';

            return $args;
        }

        // Active Campaign integration in popup page data saver
        public function ays_popup_page_active_camp_save( $options, $data){
            $options['enable_active_camp']     = ( isset( $data['ays_enable_active_camp'] ) && $data['ays_enable_active_camp'] == 'on' ) ? 'on' : 'off';
            $options['active_camp_list']       = !isset( $data['ays_active_camp_list'] ) ? "" : $data['ays_active_camp_list'];
            $options['active_camp_automation'] = !isset( $data['ays_active_camp_automation'] ) ? "" : $data['ays_active_camp_automation'];

            return $options;
        }

        
        // Active Campaign integration / settings page

        // Active Campaign integration in Gengeral settings page content
        public function ays_settings_page_active_camp_content( $integrations, $args ){
            $actions = $this->settings_obj;
            
            $active_camp_res     = ($actions->ays_get_setting('active_camp') === false) ? json_encode(array()) : $actions->ays_get_setting('active_camp');
            $active_camp         = json_decode($active_camp_res, true);
            $active_camp_url     = isset($active_camp['url']) ? $active_camp['url'] : '';
            $active_camp_api_key = isset($active_camp['apiKey']) ? $active_camp['apiKey'] : '';
            
            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/activecampaign_logo.png';
            $title = __( 'ActiveCampaign', $this->plugin_name );

            $content = '';
            $content .= '<div class="form-group row">
                            <div class="col-sm-12">
                            <div class="form-group row" aria-describedby="aaa">
                                <div class="col-sm-3">
                                    <label for="ays_active_camp_url">'. __( 'API Access URL', $this->plugin_name ) .'</label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" 
                                        class="ays-text-input" 
                                        id="ays_active_camp_url" 
                                        name="ays_active_camp_url"
                                        value="'. $active_camp_url .'"
                                    />
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row" aria-describedby="aaa">
                                <div class="col-sm-3">
                                    <label for="ays_active_camp_api_key">'. __( 'API Access Key', $this->plugin_name ) .'</label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" 
                                        class="ays-text-input" 
                                        id="ays_active_camp_api_key" 
                                        name="ays_active_camp_api_key"
                                        value="'. $active_camp_api_key .'"
                                    />
                                </div>
                            </div>
                    <blockquote>';
            $content .= __( "Your API URL and Key can be found in your account on the My Settings page under the “Developer” tab.");
            $content .= '</blockquote>
                </div>
            </div>';

            $integrations['active_camp'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title
            );

            return $integrations;
        }

        // Active Campaign integration in Gengeral settings page data saver
        public function ays_settings_page_active_camp_save( $fields, $data ){
            $active_camp_url     = isset($data['ays_active_camp_url']) ? $data['ays_active_camp_url'] : '';
            $active_camp_api_key = isset($data['ays_active_camp_api_key']) ? $data['ays_active_camp_api_key'] : '';
            $active_camp         = array(
                'url'    => $active_camp_url,
                'apiKey' => $active_camp_api_key
            );
                
            $fields['active_camp'] = $active_camp;

            return $fields;
        }

        // Active Campaign integration / front-end
        
        // Active Campaign integration in front-end functional
        public function ays_front_end_active_camp_functional( $arguments, $options, $data ){
            
            if( isset( $arguments['enable_active_camp'] ) && $arguments['enable_active_camp'] ){
                if( !empty( $data['user_email'] ) ){

                    $active_camp_fname = "";
                    $active_camp_lname = "";
                    if( !empty( $data['user_name'] ) ){
                        $user_name = explode( " ", $data['user_name'] );
                        $active_camp_fname = (isset($user_name[0]) && $user_name[0] != "") ? $user_name[0] : "";
                        $active_camp_lname = (isset($user_name[1]) && $user_name[1] != "") ? $user_name[1] : "";
                    }

                    $active_camp_list  = $arguments['active_camp_list'];
                    $active_camp_automation  = $arguments['active_camp_automation'];
                    $popup_settings = $this->settings_obj;

                    $active_camp_res     = ($popup_settings->ays_get_setting('active_camp') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('active_camp');
                    $active_camp         = json_decode($active_camp_res, true);
                    $active_camp_url     = isset($active_camp['url']) ? $active_camp['url'] : '';
                    $active_camp_api_key = isset($active_camp['apiKey']) ? $active_camp['apiKey'] : '';
                    
                    $args = array(
                        "email"     => $data['user_email'],
                        "firstName" => $active_camp_fname,
                        "lastName"  => $active_camp_lname
                    );
                    $mresult = $this->ays_add_active_camp_transaction($active_camp_url, $active_camp_api_key, $args, $active_camp_list, $active_camp_automation);
                }
            }
        }

        // Active Campaign integration in front-end options
        public function ays_front_end_active_camp_options( $args, $settings ){
            // Active Campaign
            
            $args['enable_active_camp'] = ( isset($settings['enable_active_camp'] ) && $settings['enable_active_camp'] == 'on') ? true : false;
            $args['active_camp_list'] = (isset($settings['active_camp_list'])) ? $settings['active_camp_list'] : '';
            $args['active_camp_automation'] = (isset($settings['active_camp_automation'])) ? $settings['active_camp_automation'] : '';

            return $args;
        }

    // ===== Active Campaign end =====
    
    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////


    // ===== GetResponse start =====

        // GetResponse integration

        // GetResponse integration in popup page content
        public function ays_popup_page_get_response_content( $integrations, $args ){

            $popup_settings = $this->settings_obj;

            // GetResponse
            $getResponse_res = ($popup_settings->ays_get_setting('get_response') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('get_response');
            $getResponse = json_decode($getResponse_res, true);
            $getResponse_api_key = isset($getResponse['api_key']) ? $getResponse['api_key'] : '';
            $getResponse_lists = $this->ays_popup_getResposne_lists($getResponse_api_key);
            $getResponse_status  = isset($getResponse_lists['status']) && $getResponse_lists['status'] ? true : false;
            $getResponse_message = isset($getResponse_lists['message']) && $getResponse_lists['message'] ? esc_attr($getResponse_lists['message']) : __("Something went wrong", $this->plugin_name);

            $enable_getResponse = $args['enable_getResponse'];
            $getResponse_db_list = $args['getResponse_list'];

            $icon = AYS_PB_ADMIN_URL .'/images/integrations/get_response.png';
            $title = __('GetResponse Settings',$this->plugin_name);

            $content = '';
            if(count($getResponse) > 0){
                if( $getResponse_api_key == "" ){
                    $content .= $this->blockquote_content;
                }else{
                    $disabled = !$getResponse_status ? "disabled" : '';
                    $checked = ($enable_getResponse == true) ? "checked" : '';

                    $content .= '<div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_enable_getResponse">'. __('Enable GetResponse', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_popup_enable_getResponse" name="ays_popup_enable_getResponse" value="on" '.$checked.' '.$disabled.'/>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_getResponse_list">'. __('GetResponse List', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-8">';
                            if( isset( $getResponse_lists ) && !empty( $getResponse_lists ) ){
                                if( $getResponse_status ){
                                    $getResponse_select  = "<select name='ays_popup_getResponse_list' id='ays_popup_getResponse_list'>";
                                    $getResponse_select .= "<option value='' disabled>Select list</option>";
                                    foreach($getResponse_lists as $key => $getResponse_list){
                                        if(isset($getResponse_list) && is_array($getResponse_list)){
                                            $list_id   = isset($getResponse_list['campaignId']) && $getResponse_list['campaignId'] != "" ? esc_attr($getResponse_list['campaignId']) : "";
                                            $list_name = isset($getResponse_list['name']) && $getResponse_list['name'] != "" ? esc_attr($getResponse_list['name']) : "";
                                            $selected_list = ($list_id == $getResponse_db_list) ? "selected" : "";
                                            $getResponse_select .= "<option value='".$list_id."' ".$selected_list.">".$list_name."</option>";
                                        }
                                    }
                                    $getResponse_select .= "</select>";
                                    $content .= $getResponse_select;
                                }else{
                                    $content .= "<blockquote style='border-left:2px solid red;font-size: 16px;'>" . $getResponse_message . "</blockquote>";
                                }
                            }else{
                                $content .= __("There are no forms" , $this->plugin_name);
                            }
                    $content .= '</div>
                    </div>';
                }
            }else{
                $content .= $this->blockquote_content;
            }

            $integrations['get_response'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;
        }

        // GetResponse integration in popup page options
        public function ays_popup_page_get_response_options( $args, $options ){

            // GetResponse options
            $args['enable_getResponse']  = (isset($options['enable_getResponse']) && $options['enable_getResponse'] == 'on') ? true : false;
            $args['getResponse_list'] = (isset($options['getResponse_list'])) ? esc_attr( $options['getResponse_list'] ) : '';

            return $args;
        }

        // GetResponse integration in popup page data saver
        public function ays_popup_page_get_response_save( $options, $data ){

            $options['enable_getResponse'] = ( isset( $_POST['ays_popup_enable_getResponse'] ) && $_POST['ays_popup_enable_getResponse'] == 'on' ) ? 'on' : 'off';
            $options['getResponse_list'] = !isset( $_POST['ays_popup_getResponse_list'] ) ? "" : sanitize_text_field( $_POST['ays_popup_getResponse_list'] );

            return $options;
        }

        // GetResponse integration / settings page

        // GetResponse integration in General settings page content
        public function ays_settings_page_get_response_content( $integrations, $args ){

            $actions = $this->settings_obj;

            // GetResponse
            $getResponse_res  = ($actions->ays_get_setting('get_response') === false) ? json_encode(array()) : $actions->ays_get_setting('get_response');
            $getResponse      = json_decode($getResponse_res, true);
            $getResponse_api_key = isset($getResponse['api_key']) ? $getResponse['api_key'] : '';



            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/get_response.png';
            $title = __( 'GetResponse', $this->plugin_name );

            $content = '';
            $content .= '
                <div class="form-group row">
                    <div class="col-sm-12">
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_popup_getresponse_api_key">'. __('GetResponse API Key', $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_popup_getresponse_api_key" name="ays_popup_getresponse_api_key" value="'. $getResponse_api_key .'" >
                            </div>
                        </div>';
            $content .= '<blockquote>';
            $content .= sprintf( __( "You can get your API key from your ", $this->plugin_name ) . "<a href='%s' target='_blank'> %s.</a>", "https://app.getresponse.com/api", "account" );
            $content .= '</blockquote>';
            $content .= '<blockquote>';
            $content .= __( "For security reasons, unused API keys expire after 90 days. When that happens, you’ll need to generate a new key.", $this->plugin_name );
            $content .= '</blockquote>';
            $content .= '
                </div>
            </div>';

            $integrations['get_response'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;
        }

        // GetResponse integration in General settings page data saver
        public function ays_settings_page_get_response_save( $fields, $data ){

            $getResponse_api_key = isset($data['ays_popup_getresponse_api_key']) && $data['ays_popup_getresponse_api_key'] != "" ? sanitize_text_field($data['ays_popup_getresponse_api_key']) : '';
            $getResponse_options = array(
                "api_key" => $getResponse_api_key
            );

            $fields['get_response'] =  $getResponse_options;

            return $fields;
        }


        // GetResponse integration / front-end

        // GetResponse integration in front-end functional
        public function ays_front_end_get_response_functional( $arguments, $options, $data ){

            if( isset( $arguments['enable_getResponse'] ) && $arguments['enable_getResponse'] ){
                if( !empty( $data['user_email'] ) ){

                    $popup_settings = $this->settings_obj;

                    $getResponse_res = ($popup_settings->ays_get_setting('get_response') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('get_response');
                    $getResponse     = json_decode($getResponse_res, true);

                    $getResponse_api_key    = isset($getResponse['api_key']) ? $getResponse['api_key'] : '';
                    $getResponse_new_email  = (isset($data['user_email']) && $data['user_email'] != "") ? sanitize_email($data['user_email']) : "";
                    $getResponse_user_name  = isset($data['user_name']) ? explode(" ", $data['user_name'], 2) : array();
                    $getResponse_fname      = (isset($getResponse_user_name[0]) && $getResponse_user_name[0] != "") ? $getResponse_user_name[0] : "";
                    $getResponse_lname      = (isset($getResponse_user_name[1]) && $getResponse_user_name[1] != "") ? $getResponse_user_name[1] : "";
                    $getResponse_data = array(
                        "api_key" => $getResponse_api_key,
                        "list_id" => $arguments['getResponse_list'],
                        "email"   => $getResponse_new_email,
                        "fname"   => $getResponse_fname,
                        "lname"   => $getResponse_lname,
                    );
                    $mresult = $this->ays_popup_add_getResponse_contact( $getResponse_data );
                }
            }
        }

        // GetResponse integration in front-end options
        public function ays_front_end_get_response_options( $args, $settings ){
            // ConvertKit Settings
            $args['enable_getResponse'] = ( isset($settings['enable_getResponse'] ) && $settings['enable_getResponse'] == 'on') ? true : false;
            $args['getResponse_list'] = (isset($settings['getResponse_list'])) ? $settings['getResponse_list'] : '';

            return $args;
        }

    // ===== GetResponse end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== ConvertKit Settings start =====

        // ConvertKit Settings integration

        // ConvertKit Settings integration in popup page content
        public function ays_popup_page_convert_kit_content( $integrations, $args ){

            $popup_settings = $this->settings_obj;

            // ConvertKit Settings
            $convertKit_res      = ($popup_settings->ays_get_setting('convertKit') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('convertKit');
            $convertKit          = json_decode($convertKit_res, true);
            $convertKit_api_key  = isset($convertKit['api_key']) && $convertKit['api_key'] != "" ? esc_attr($convertKit['api_key']) : '';
            $convertKit_forms    = $this->ays_get_convertKit_forms($convertKit_api_key);

            $convertKit_forms_list      = isset($convertKit_forms['forms']) && !empty($convertKit_forms['forms']) ? $convertKit_forms['forms'] : array();
            $convertKit_response_status = isset($convertKit_forms['status']) && $convertKit_forms['status'] ? true : false;

            $enable_convertKit  = $args['enable_convertKit'];
            $convertKit_form_id = $args['convertKit_form_id'];

            $icon  = AYS_PB_ADMIN_URL .'/images/integrations/convertkit_logo.png';
            $title = __('ConvertKit Settings',$this->plugin_name);

            $content = '';
            if(count($convertKit) > 0){
                if( $convertKit_api_key == "" ){
                    $content .= $this->blockquote_content;
                }else{
                    $disabled = !$convertKit_response_status ? "disabled" : '';
                    $checked = ($enable_convertKit == true) ? "checked" : '';

                    $content .= '<div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_enable_convertkit">'. __('Enable ConvertKit', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_popup_enable_convertkit" name="ays_popup_enable_convertkit" value="on" '.$checked.' '.$disabled.'/>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_convertKit_list">'. __('ConvertKit List', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-8">';
                            if(isset($convertKit_forms) && !empty($convertKit_forms)){
                                if( $convertKit_response_status ){
                                    $convertKit_select  = "<select name='ays_popup_convertKit_list' id='ays_popup_convertKit_list'>";
                                    $convertKit_select .= "<option value='' disabled>Select list</option>";
                                    foreach($convertKit_forms_list as $key => $convertKit_form){
                                        $response_form_id = isset($convertKit_form['id']) && $convertKit_form['id'] != "" ? $convertKit_form['id'] : "";
                                        $response_form_name = isset($convertKit_form['name']) && $convertKit_form['name'] != "" ? $convertKit_form['name'] : "";

                                        $selected = ($convertKit_form_id == $response_form_id) ? 'selected' : '';
                                        $convertKit_select .= "<option value='".$response_form_id."' ".$selected.">".$response_form_name."</option>";
                                    }
                                    $convertKit_select .= "</select>";
                                    $content .= $convertKit_select;
                                }else{
                                    $content .= __("There are no forms" , $this->plugin_name);
                                }
                            }else{
                                $content .= __("There are no forms" , $this->plugin_name);
                            }
                    $content .= '</div>
                    </div>';
                }
            }else{
                $content .= $this->blockquote_content;
            }

            $integrations['convertKit'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;
        }

        // ConvertKit Settings integration in popup page options
        public function ays_popup_page_convert_kit_options( $args, $options ){

            // ConvertKit Settings
            $args['enable_convertKit']  = (isset($options['enable_convertKit']) && $options['enable_convertKit'] == 'on') ? true : false;
            $args['convertKit_form_id'] = (isset($options['convertKit_form_id'])) ? esc_attr( $options['convertKit_form_id'] ) : '';

            return $args;
        }

        // ConvertKit Settings integration in popup page data saver
        public function ays_popup_page_convert_kit_save( $options, $data ){

            $options['enable_convertKit'] = ( isset( $_POST['ays_popup_enable_convertkit'] ) && $_POST['ays_popup_enable_convertkit'] == 'on' ) ? 'on' : 'off';
            $options['convertKit_form_id'] = !isset( $_POST['ays_popup_convertKit_list'] ) ? "" : sanitize_text_field( $_POST['ays_popup_convertKit_list'] );

            return $options;
        }

        // ConvertKit Settings integration / settings page

        // ConvertKit Settings integration in General settings page content
        public function ays_settings_page_convert_kit_content( $integrations, $args ){

            $actions = $this->settings_obj;

            // ConvertKit Settings
            $convertKit_res         = ($actions->ays_get_setting('convertKit') === false) ? json_encode(array()) : $actions->ays_get_setting('convertKit');
            $convertKit             = json_decode($convertKit_res, true);
            $convertKit_account_id  = isset($convertKit['api_key']) ? esc_attr($convertKit['api_key']) : '';

            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/convertkit_logo.png';
            $title = __( 'ConvertKit', $this->plugin_name );

            $content = '';
            $content .= '
                <div class="form-group row">
                    <div class="col-sm-12">
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_popup_convert_kit">'. __('API Key', $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_popup_convert_kit" name="ays_popup_convert_kit" value="'. $convertKit_account_id .'" >
                            </div>
                        </div>';
            $content .= '<blockquote>';
            $content .= sprintf( __( "You can get your API key from your ", $this->plugin_name ) . "<a href='%s' target='_blank'> %s.</a>", "https://app.convertkit.com/account/edit", "Account" );
            $content .= '</blockquote>';
            $content .= '
                </div>
            </div>';

            $integrations['convertKit'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;
        }

        // ConvertKit Settings integration in General settings page data saver
        public function ays_settings_page_convert_kit_save( $fields, $data ){

            $convertKit_account_id = isset($data['ays_popup_convert_kit']) && $data['ays_popup_convert_kit'] != "" ? sanitize_text_field($data['ays_popup_convert_kit']) : '';

            $convertKit_options = array(
                "api_key" => $convertKit_account_id,
            );

            $fields['convertKit'] = $convertKit_options;

            return $fields;
        }


        // ConvertKit Settings integration / front-end

        // ConvertKit Settings integration in front-end functional
        public function ays_front_end_convert_kit_functional( $arguments, $options, $data ){
            
            if( isset( $arguments['enable_convertKit'] ) && $arguments['enable_convertKit'] ){
                if( !empty( $data['user_email'] ) ){

                    $popup_settings = $this->settings_obj;

                    $convertKit_data     = array();

                    $covertKit_res       = ($popup_settings->ays_get_setting('convertKit') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('convertKit');
                    $covertKit           = json_decode($covertKit_res, true);
                    $convertKit_api_key  = isset($covertKit['api_key']) && $covertKit['api_key'] != "" ? $covertKit['api_key'] : '';
                    $covertKit_email     = (isset($data['user_email']) && $data['user_email'] != "") ? sanitize_email( $data['user_email'] ) : "";
                    $covertKit_name      = isset($data['user_name']) && $data['user_name'] != "" ? explode(" ", sanitize_text_field( $data['user_name'] ), 2 ) : array();
                    
                    $covertKit_fname = (isset($covertKit_name[0]) && $covertKit_name[0] != "") ? $covertKit_name[0] : "";
                    $covertKit_lname = (isset($covertKit_name[1]) && $covertKit_name[1] != "") ? $covertKit_name[1] : "";

                    $convertKit_data = array(
                        "api_key" => $convertKit_api_key,
                        "form_id" => $arguments['convertKit_form_id'],
                        "email"   => $covertKit_email,
                        "fname"   => $covertKit_fname,
                        "lname"   => $covertKit_lname
                    );
                    $mresult = $this->ays_popup_convertKit_add_user( $convertKit_data );
                }
            }
        }

        // ConvertKit Settings integration in front-end options
        public function ays_front_end_convert_kit_options( $args, $settings ){
            // ConvertKit Settings
            $args['enable_convertKit']  = (isset($settings['enable_convertKit'] ) && $settings['enable_convertKit'] == 'on') ? true : false;
            $args['convertKit_form_id'] = (isset($settings['convertKit_form_id'])) ? $settings['convertKit_form_id'] : '';

            return $args;
        }

    // ===== ConvertKit Settings end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Sendinblue Settings start =====

        // Sendinblue Settings integration

        // Sendinblue Settings integration in popup page content
        public function ays_popup_page_sendinblue_content( $integrations, $args ){

            $popup_settings = $this->settings_obj;

            // Sendinblue Settings
            $sendinblue_res      = ($popup_settings->ays_get_setting('sendinblue') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('sendinblue');
            $sendinblue          = json_decode($sendinblue_res, true);
            $sendinblue_api_key  = isset($sendinblue['api_key']) && $sendinblue['api_key'] != "" ? esc_attr($sendinblue['api_key']) : '';
            $sendinblue_lists    = $this->ays_popup_get_sendinblue_lists($sendinblue_api_key);

            $sendinblue_get_lists = isset($sendinblue_lists['lists']) && !empty($sendinblue_lists['lists']) ? $sendinblue_lists['lists'] : array();
            $sendinblue_response_status = isset($sendinblue_lists['status']) && $sendinblue_lists['status'] ? true : false;

            $enable_sendinblue  = $args['enable_sendinblue'];
            $sendinblue_list_id = $args['sendinblue_list_id'];

            $icon  = AYS_PB_ADMIN_URL .'/images/integrations/sendinblue.png';
            $title = __('Sendinblue Settings',$this->plugin_name);

            $content = '';
            if(count($sendinblue) > 0){
                if( $sendinblue_api_key == "" ){
                    $content .= $this->blockquote_content;
                }else{
                    $disabled = !$sendinblue_response_status ? "disabled" : '';
                    $checked = ($enable_sendinblue == true) ? "checked" : '';

                    $content .= '<div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_enable_sendinblue">'. __('Enable Sendinblue', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_popup_enable_sendinblue" name="ays_popup_enable_sendinblue" value="on" '.$checked.' '.$disabled.'/>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_sendinblue_list_id">'. __('Sendinblue Lists', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-8">';
                            if(isset($sendinblue_get_lists) && !empty($sendinblue_get_lists)){
                                if( $sendinblue_response_status ){
                                    $sendinblue_select  = "<select name='ays_popup_sendinblue_list_id' id='ays_popup_sendinblue_list_id'>";
                                    $sendinblue_select .= "<option value='' disabled>Select list</option>";
                                    foreach($sendinblue_get_lists as $key => $sendinblue_list){
                                        $response_form_id = isset($sendinblue_list['id']) && $sendinblue_list['id'] != "" ? $sendinblue_list['id'] : "";
                                        $response_form_name = isset($sendinblue_list['name']) && $sendinblue_list['name'] != "" ? $sendinblue_list['name'] : "";

                                        $selected = ($sendinblue_list_id == $response_form_id) ? 'selected' : '';
                                        $sendinblue_select .= "<option value='".$response_form_id."' ".$selected.">".$response_form_name."</option>";
                                    }
                                    $sendinblue_select .= "</select>";
                                    $content .= $sendinblue_select;
                                }else{
                                    $content .= __("There are no forms" , $this->plugin_name);
                                }
                            }else{
                                $content .= __("There are no forms" , $this->plugin_name);
                            }
                    $content .= '</div>
                    </div>';
                }
            }else{
                $content .= $this->blockquote_content;
            }

            $integrations['sendinblue'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title
            );

            return $integrations;
        }

        // Sendinblue Settings integration in popup page options
        public function ays_popup_page_sendinblue_options( $args, $options ){

            // Sendinblue Settings
            $args['enable_sendinblue']  = (isset($options['enable_sendinblue']) && $options['enable_sendinblue'] == 'on') ? true : false;
            $args['sendinblue_list_id'] = (isset($options['sendinblue_list_id'])) ? esc_attr( $options['sendinblue_list_id'] ) : '';

            return $args;
        }

        // Sendinblue Settings integration in popup page data saver
        public function ays_popup_page_sendinblue_save( $options, $data ){

            $options['enable_sendinblue']  = (isset( $_POST['ays_popup_enable_sendinblue'] ) && $_POST['ays_popup_enable_sendinblue'] == 'on') ? 'on' : 'off';
            $options['sendinblue_list_id'] = (isset( $_POST['ays_popup_sendinblue_list_id'] ) && $_POST['ays_popup_sendinblue_list_id'] != "") ? sanitize_text_field( $_POST['ays_popup_sendinblue_list_id'] ) : "";

            return $options;
        }

        // Sendinblue Settings integration / settings page

        // Sendinblue Settings integration in General settings page content
        public function ays_settings_page_sendinblue_content( $integrations, $args ){

            $actions = $this->settings_obj;

            // Sendinblue Settings
            $sendinblue_res         = ($actions->ays_get_setting('sendinblue') === false) ? json_encode(array()) : $actions->ays_get_setting('sendinblue');
            $sendinblue             = json_decode($sendinblue_res, true);
            $sendinblue_api_key     = isset($sendinblue['api_key']) && $sendinblue['api_key'] != "" ? esc_attr($sendinblue['api_key']) : '';

            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/sendinblue.png';
            $title = __( 'Sendinblue', $this->plugin_name );

            $content = '';
            $content .= '
                <div class="form-group row">
                    <div class="col-sm-12">
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_popup_sendinblue">'. __('API Key', $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_popup_sendinblue" name="ays_popup_sendinblue" value="'. $sendinblue_api_key .'" >
                            </div>
                        </div>';
            $content .= '<blockquote>';
                $content .= sprintf( __( "You can get your API key from your ", $this->plugin_name ) . "<a href='%s' target='_blank'> %s.</a>", "https://app.brevo.com/settings/keys/api", "Account" );
            $content .= '</blockquote>';
            $content .= '
                </div>
            </div>';

            $integrations['sendinblue'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title
            );

            return $integrations;
        }

        // Sendinblue Settings integration in General settings page data saver
        public function ays_settings_page_sendinblue_save( $fields, $data ){

            $sendinblue_api_key = isset($data['ays_popup_sendinblue']) && $data['ays_popup_sendinblue'] != "" ? sanitize_text_field($data['ays_popup_sendinblue']) : '';

            $sendinblue_options = array(
                "api_key" => $sendinblue_api_key,
            );

            $fields['sendinblue'] = $sendinblue_options;

            return $fields;
        }


        // Sendinblue Settings integration / front-end

        // Sendinblue Settings integration in front-end functional
        public function ays_front_end_sendinblue_functional( $arguments, $options, $data ){
            
            if( isset( $arguments['enable_sendinblue'] ) && $arguments['enable_sendinblue'] ){
                if( !empty( $data['user_email'] ) ){

                    $popup_settings = $this->settings_obj;

                    $sendinblue_data     = array();

                    $sendinblue_res       = ($popup_settings->ays_get_setting('sendinblue') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('sendinblue');
                    $sendinblue           = json_decode($sendinblue_res, true);
                    $sendinblue_api_key   = isset($sendinblue['api_key']) && $sendinblue['api_key'] != "" ? $sendinblue['api_key'] : '';
                    $sendinblue_email     = (isset($data['user_email']) && $data['user_email'] != "") ? sanitize_email( $data['user_email'] ) : "";
                    $sendinblue_name      = isset($data['user_name']) && $data['user_name'] != "" ? explode(" ", sanitize_text_field( $data['user_name'] ), 2 ) : array();
                    
                    $sendinblue_fname = (isset($sendinblue_name[0]) && $sendinblue_name[0] != "") ? $sendinblue_name[0] : "";
                    $sendinblue_lname = (isset($sendinblue_name[1]) && $sendinblue_name[1] != "") ? $sendinblue_name[1] : "";

                    $sendinblue_data = array(
                        "api_key" => $sendinblue_api_key,
                        "list_id" => $arguments['sendinblue_list_id'],
                        "email"   => $sendinblue_email,
                        "fname"   => $sendinblue_fname,
                        "lname"   => $sendinblue_lname
                    );
                    $mresult = $this->ays_popup_sendinblue_add_contact_to_list( $sendinblue_data );
                }
            }
        }

        // Sendinblue Settings integration in front-end options
        public function ays_front_end_sendinblue_options( $args, $settings ){
            // Sendinblue Settings
            $args['enable_sendinblue']  = (isset($settings['enable_sendinblue'] ) && $settings['enable_sendinblue'] == 'on') ? true : false;
            $args['sendinblue_list_id'] = (isset($settings['sendinblue_list_id'])) ? $settings['sendinblue_list_id'] : '';

            return $args;
        }

    // ===== Sendinblue Settings end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== MailerLite Settings start =====

        // MailerLite Settings integration

        // MailerLite Settings integration in popup page content
        public function ays_popup_page_mailerLite_content( $integrations, $args ){

            $popup_settings = $this->settings_obj;

            // MailerLite Settings
            $mailerLite_res     = ($popup_settings->ays_get_setting('mailerLite') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('mailerLite');
            $mailerLite         = json_decode($mailerLite_res, true);
            $mailerLite_api_key = isset($mailerLite['api_key']) && $mailerLite['api_key'] != "" ? esc_attr($mailerLite['api_key']) : '';
            $mailerLite_groups  = $this->ays_popup_get_mailerLite_groups($mailerLite_api_key);
            
            $mailerLite_get_groups      = isset($mailerLite_groups['groups']) && !empty($mailerLite_groups['groups']) ? $mailerLite_groups['groups'] : array();
            $mailerLite_response_status = isset($mailerLite_groups['status']) && $mailerLite_groups['status'] ? true : false;

            $enable_mailerLite  = $args['enable_mailerLite'];
            $mailerLite_group_id = $args['mailerLite_group_id'];

            $icon  = AYS_PB_ADMIN_URL .'/images/integrations/mailerlite.png';
            $title = __('MailerLite Settings',$this->plugin_name);

            $content = '';
            if(count($mailerLite) > 0){
                if( $mailerLite_api_key == "" ){
                    $content .= $this->blockquote_content;
                }else{
                    $disabled = !$mailerLite_response_status ? "disabled" : '';
                    $checked = ($enable_mailerLite == true) ? "checked" : '';

                    $content .= '<div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_enable_mailerLite">'. __('Enable MailerLite', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-1">
                            <input type="checkbox" class="ays-enable-timer1" id="ays_popup_enable_mailerLite" name="ays_popup_enable_mailerLite" value="on" '.$checked.' '.$disabled.'/>
                        </div>
                    </div>
                    <hr>
                    <div class="form-group row">
                        <div class="col-sm-4">
                            <label for="ays_popup_mailerLite_group_id">'. __('MailerLite Lists', $this->plugin_name) .'</label>
                        </div>
                        <div class="col-sm-8">';
                            if(isset($mailerLite_get_groups) && !empty($mailerLite_get_groups)){
                                if( $mailerLite_response_status ){
                                    $mailerLite_select  = "<select name='ays_popup_mailerLite_group_id' id='ays_popup_mailerLite_group_id'>";
                                    $mailerLite_select .= "<option value='' disabled>Select list</option>";
                                    foreach($mailerLite_get_groups as $key => $mailerLite_group){
                                        $response_form_id   = isset($mailerLite_group['id'])   && $mailerLite_group['id'] != ""   ? $mailerLite_group['id'] : "";
                                        $response_form_name = isset($mailerLite_group['name']) && $mailerLite_group['name'] != "" ? $mailerLite_group['name'] : "";

                                        $selected = ($mailerLite_group_id == $response_form_id) ? 'selected' : '';
                                        $mailerLite_select .= "<option value='".$response_form_id."' ".$selected.">".$response_form_name."</option>";
                                    }
                                    $mailerLite_select .= "</select>";
                                    $content .= $mailerLite_select;
                                }else{
                                    $content .= __("There are no forms" , $this->plugin_name);
                                }
                            }else{
                                $content .= __("There are no forms" , $this->plugin_name);
                            }
                    $content .= '</div>
                    </div>';
                }
            }else{
                $content .= $this->blockquote_content;
            }

            $integrations['mailerLite'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title
            );

            return $integrations;
        }

        // MailerLite Settings integration in popup page options
        public function ays_popup_page_mailerLite_options( $args, $options ){

            // MailerLite Settings
            $args['enable_mailerLite']  = (isset($options['enable_mailerLite']) && $options['enable_mailerLite'] == 'on') ? true : false;
            $args['mailerLite_group_id'] = (isset($options['mailerLite_group_id'])) ? esc_attr( $options['mailerLite_group_id'] ) : '';

            return $args;
        }

        // MailerLite Settings integration in popup page data saver
        public function ays_popup_page_mailerLite_save( $options, $data ){

            $options['enable_mailerLite']  = (isset( $_POST['ays_popup_enable_mailerLite'] ) && $_POST['ays_popup_enable_mailerLite'] == 'on') ? 'on' : 'off';
            $options['mailerLite_group_id'] = (isset( $_POST['ays_popup_mailerLite_group_id'] ) && $_POST['ays_popup_mailerLite_group_id'] != "") ? sanitize_text_field( $_POST['ays_popup_mailerLite_group_id'] ) : "";

            return $options;
        }

        // MailerLite Settings integration / settings page

        // MailerLite Settings integration in General settings page content
        public function ays_settings_page_mailerLite_content( $integrations, $args ){

            $actions = $this->settings_obj;

            // MailerLite Settings
            $mailerLite_res     = ($actions->ays_get_setting('mailerLite') === false) ? json_encode(array()) : $actions->ays_get_setting('mailerLite');
            $mailerLite         = json_decode($mailerLite_res, true);
            $mailerLite_api_key = isset($mailerLite['api_key']) && $mailerLite['api_key'] != "" ? esc_attr($mailerLite['api_key']) : '';

            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/mailerlite.png';
            $title = __( 'MailerLite', $this->plugin_name );

            $content = '';
            $content .= '
                <div class="form-group row">
                    <div class="col-sm-12">
                        <div class="form-group row">
                            <div class="col-sm-3">
                                <label for="ays_popup_mailerLite">'. __('API Key', $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-9">
                                <input type="text" class="ays-text-input" id="ays_popup_mailerLite" name="ays_popup_mailerLite" value="'. $mailerLite_api_key .'" >
                            </div>
                        </div>';
            $content .= '<blockquote>';
                $content .= sprintf( __( "You can get your API key from your ", $this->plugin_name ) . "<a href='%s' target='_blank'> %s.</a>", "https://app.mailerlite.com/integrations/api", "Account" );
            $content .= '</blockquote>';
            $content .= '
                </div>
            </div>';

            $integrations['mailerLite'] = array(
                'content' => $content,
                'icon'    => $icon,
                'title'   => $title
            );

            return $integrations;
        }

        // MailerLite Settings integration in General settings page data saver
        public function ays_settings_page_mailerLite_save( $fields, $data ){

            $mailerLite_api_key = isset($data['ays_popup_mailerLite']) && $data['ays_popup_mailerLite'] != "" ? sanitize_text_field($data['ays_popup_mailerLite']) : '';

            $mailerLite_options = array(
                "api_key" => $mailerLite_api_key
            );

            $fields['mailerLite'] = $mailerLite_options;

            return $fields;
        }


        // MailerLite Settings integration / front-end

        // MailerLite Settings integration in front-end functional
        public function ays_front_end_mailerLite_functional( $arguments, $options, $data ){
            
            if( isset( $arguments['enable_mailerLite'] ) && $arguments['enable_mailerLite'] ){
                if( !empty( $data['user_email'] ) ){
                    $popup_settings = $this->settings_obj;

                    $mailerLite_data     = array();

                    $mailerLite_res     = ($popup_settings->ays_get_setting('mailerLite') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('mailerLite');
                    $mailerLite         = json_decode($mailerLite_res, true);
                    $mailerLite_api_key = isset($mailerLite['api_key']) && $mailerLite['api_key'] != "" ? $mailerLite['api_key'] : '';
                    $mailerLite_email   = (isset($data['user_email']) && $data['user_email'] != "") ? sanitize_email( $data['user_email'] ) : "";
                    $mailerLite_name    = isset($data['user_name']) && $data['user_name'] != "" ? $data['user_name']  : array();

                    $mailerLite_data = array(
                        "api_key"  => $mailerLite_api_key,
                        "group_id" => $arguments['mailerLite_group_id'],
                        "email"    => $mailerLite_email,
                        "name"     => $mailerLite_name
                    );
                    $mresult = $this->ays_popup_malerLite_add_contact_to_group( $mailerLite_data );
                }
            }
        }

        // MailerLite Settings integration in front-end options
        public function ays_front_end_mailerLite_options( $args, $settings ){
            // MailerLite Settings
            $args['enable_mailerLite']   = (isset($settings['enable_mailerLite'] ) && $settings['enable_mailerLite'] == 'on') ? true : false;
            $args['mailerLite_group_id'] = (isset($settings['mailerLite_group_id'])) ? $settings['mailerLite_group_id'] : '';

            return $args;
        }

    // ===== MailerLite Settings end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Integration calls for admin dashboard start =====

        // Mailchimp - Get mailchimp lists
        public function ays_get_mailchimp_lists($username, $api_key){
            if($username == ""){
                return array(
                    'total_items' => 0
                );
            }
            if($api_key == ""){
                return array(
                    'total_items' => 0
                );
            }

            $explode = explode("-",$api_key);
            $api_prefix = isset( $explode[1] ) ? $explode[1] : '';
            
            if(! $api_prefix ){
                return array(
                    'total_items' => 0
                );
            }
            $headers = array(
                "headers" => array(
                    "Authorization" => 'Basic ' . base64_encode( $username.':'.$api_key ),            
                    "Content-Type"  => "application/json",
                    "cache-control" => "no-cache",
                ),
            );
            $headers['sslverify'] = false;

            $url = "https://".$api_prefix.".api.mailchimp.com/3.0/lists";
            $response = wp_remote_get($url, $headers);        
            $body     = wp_remote_retrieve_body( $response );
            
            if( empty( $body ) ){
                return array(
                    'total_items' => 0
                );
            }else{
                $body = json_decode($body,true);
            }
            return $body;


            // $curl = curl_init();

            // curl_setopt_array($curl, array(
            //     CURLOPT_URL => "https://".$api_prefix.".api.mailchimp.com/3.0/lists",
            //     CURLOPT_RETURNTRANSFER => true,
            //     CURLOPT_ENCODING => "",
            //     CURLOPT_MAXREDIRS => 10,
            //     CURLOPT_TIMEOUT => 30,
            //     CURLOPT_SSL_VERIFYPEER => false,
            //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            //     CURLOPT_CUSTOMREQUEST => "GET",
            //     CURLOPT_USERPWD => "$username:$api_key",
            //     CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
            //     CURLOPT_HTTPHEADER => array(
            //         "Content-Type: application/json",
            //         "cache-control: no-cache"
            //     ),
            // ));

            // $response = curl_exec($curl);
            // $err = curl_error($curl);

            // curl_close($curl);

            // if ($err) {
            //     return array(
            //         'Code'       => 0,
            //         'cURL Error' => $err
            //     );
            // } else {
            //     return json_decode($response, true);
            // }
        }
        
        // Campaign Monitor - Get subscribe lists
        public function ays_get_monitor_lists($client, $api_key){
            if ($client == "" || $api_key == "") {
                return array(
                    'Code' => 0
                );
            }

            $body = '';
            $headers = array(
                "headers" => array(    
                    "Authorization" => 'Basic ' . base64_encode( $api_key.":x" ),            
                    "Content-Type"  => "application/json",
                    "cache-control" => "no-cache",
                )
            );

            $headers['sslverify'] = false;

            $url = "https://api.createsend.com/api/v3.2/clients/".$client."/lists.json";
            $response = wp_remote_get($url, $headers);
            $body     = wp_remote_retrieve_body( $response );
            
            if( empty( $body ) ){
                return array(
                    'Code' => 0
                );
            }else{
                $body = json_decode($body,true);
            }
            return $body;


            // $curl = curl_init();

            // curl_setopt_array($curl, array(
            //     CURLOPT_URL => "https://api.createsend.com/api/v3.2/clients/$client/lists.json",
            //     CURLOPT_RETURNTRANSFER => true,
            //     CURLOPT_ENCODING => "",
            //     CURLOPT_MAXREDIRS => 10,
            //     CURLOPT_TIMEOUT => 30,
            //     CURLOPT_SSL_VERIFYPEER => false,
            //     CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            //     CURLOPT_CUSTOMREQUEST => "GET",
            //     CURLOPT_USERPWD => "$api_key:x",
            //     CURLOPT_HTTPAUTH => CURLAUTH_BASIC,
            //     CURLOPT_HTTPHEADER => array(
            //         "Content-Type: application/json",
            //         "cache-control: no-cache"
            //     ),
            // ));

            // $response = curl_exec($curl);
            // $err = curl_error($curl);

            // curl_close($curl);

            // if ($err) {
            //     return array(
            //         'Code'       => 0,
            //         'cURL Error' => $err
            //     );
            // } else {
            //     return json_decode($response,true);
            // }
        }

        // ActiveCampaign - Get subscribe lists
        public function ays_get_active_camp_data( $data, $url, $api_key ) {
            if(empty($data) || $url == '' || $api_key == ''){
                return array(
                    "Code" => 0
                );
            }

            $url = $url."/api/3/".$data;

            // $body = '';

            // $headers = array(
            //     "headers" => array(
            //         "Content-Type"  => "application/json",
            //         "cache-control" => "no-cache",
            //         "Api-Token"     => $api_key
            //     )
            // );
            // $headers['sslverify'] = true;


            // $response = wp_remote_get($url, $headers);
            // $body     = wp_remote_retrieve_body( $response );

            // if( empty( $body )){
            //     return array(
            //         "Code" => 0
            //     );
            // }else{
            //     $body = json_decode($body,true);
            // }
            // return $body;


            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL            => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING       => "",
                CURLOPT_MAXREDIRS      => 10,
                CURLOPT_TIMEOUT        => 30,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST  => "GET",
                CURLOPT_HTTPAUTH       => CURLAUTH_BASIC,
                CURLOPT_HTTPHEADER     => array(
                    "Content-Type: application/json",
                    "cache-control: no-cache",
                    "Api-Token: $api_key"
                ),
            ));

            $response = curl_exec($curl);
            $err      = curl_error($curl);

            curl_close($curl);

            if ($err) {
                return array(
                    'Code'       => 0,
                    'cURL Error' => $err
                );
            } else {
                return json_decode($response, true);
            }
        }

        // GetResponse
        public function ays_popup_getResposne_lists($api_key){
            $bad_request = array();
            if($api_key == ""){
                return $bad_request;
            }

            $url = "https://api.getresponse.com/v3/campaigns";
            // $headers = array(
            //     "headers" => array(
            //         "X-Auth-Token" => "api-key ".$api_key,
            //     )
            // );
            // $api_call = wp_remote_get($url , $headers);
            // $response = wp_remote_retrieve_body( $api_call );
            // $new_response = array();
            // if($response != ""){
            //     $new_response = json_decode($response , true);
            // }
            // if(wp_remote_retrieve_response_code( $api_call ) == 200){
            //     $new_response['status'] = true;
            // }
            // else{
            //     $new_response['status'] = false;
            // }
            // return $new_response;


            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL            => $url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING       => "",
                CURLOPT_MAXREDIRS      => 10,
                CURLOPT_TIMEOUT        => 30,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST  => "GET",
                CURLOPT_HTTPAUTH       => CURLAUTH_BASIC,
                CURLOPT_HTTPHEADER     => array(
                    "Content-Type: application/json",
                    "cache-control: no-cache",
                    "X-Auth-Token: api-key ".$api_key
                ),
            ));

            $response = curl_exec($curl);
            $httpcode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            $err      = curl_error($curl);

            curl_close($curl);

            if ($err) {
                return array(
                    'Code'       => 0,
                    'cURL Error' => $err
                );
            } else {
                if($response != ""){
                    $new_response = json_decode($response , true);
                }
                if($httpcode == 200){
                    $new_response['status'] = true;
                }
                else{
                    $new_response['status'] = false;
                }
                return $new_response;
            }

        }
        
        // ConvertKit Lists
        public function ays_get_convertKit_forms( $api_key ) {
            if ($api_key == "") {
                return array();
            }

            $url = "https://api.convertkit.com/v3/forms?api_key=".$api_key;
            $api_call = wp_remote_get($url);
            $body = array();
            $response = array();
            if ( wp_remote_retrieve_response_code( $api_call ) === 200 ){
                $body = wp_remote_retrieve_body( $api_call );
                if($body != ""){
                    $body = json_decode($body , true);
                    $response['forms'] = isset($body['forms']) && !empty($body['forms']) ? $body['forms'] : array();
                    $response['status'] = true;
                }else{
                    $response['forms'] = array();
                    $response['status'] = false;
                }
            }else{
                $response['forms'] = array();
                $response['status'] = false;
            }
            return $response;

        }
        
        // Sendinblue Lists
        public function ays_popup_get_sendinblue_lists( $api_key ) {
            if ($api_key == "") {
                return array();
            }

            $url = "https://api.sendinblue.com/v3/contacts/lists";

            $settings = array(
                'headers'     => array(
                    "content-type" => "application/json",
                    "api-key"      => $api_key
                ),
                'sslverify'   => true,
            );

            $api_call = wp_remote_get($url, $settings);
            $body = array();
            $response = array();
            
            
            if ( wp_remote_retrieve_response_code( $api_call ) === 200 ){
                $body = wp_remote_retrieve_body( $api_call );
                if($body != ""){
                    $body = json_decode($body , true);
                    $response['lists'] = isset($body['lists']) && !empty($body['lists']) ? $body['lists'] : array();
                    $response['status'] = true;
                }else{
                    $response['lists'] = array();
                    $response['status'] = false;
                }
            }else{
                $response['lists'] = array();
                $response['status'] = false;
            }
            return $response;

        }    
        
        // MailerLite Lists
        public function ays_popup_get_mailerLite_groups( $api_key ) {
            if ($api_key == "") {
                return array();
            }

            $url = "https://api.mailerlite.com/api/v2/groups";

            $settings = array(
                'headers'     => array(
                    "content-type"        => "application/json",
                    "X-MailerLite-ApiKey" => $api_key
                ),
                'sslverify'   => true,
            );

            $api_call = wp_remote_get($url, $settings);
            $body = array();
            $response = array();
            if ( wp_remote_retrieve_response_code( $api_call ) === 200 ){
                $body = wp_remote_retrieve_body( $api_call );
                if($body != ""){
                    $body = json_decode($body , true);
                    $response['groups'] = isset($body) && !empty($body) ? $body : array();
                    $response['status'] = true;
                }else{
                    $response['groups'] = array();
                    $response['status'] = false;
                }
            }else{
                $response['groups'] = array();
                $response['status'] = false;
            }
            return $response;

        }    
    // ===== Integration calls for admin dashboard end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Front end calls start =====
    
        // Mailchimp
        public function ays_add_mailchimp_transaction($username, $api_key, $list_id, $args){
            if($username == "" || $api_key == ""){
                return false;
            }
            
            $email = isset($args['email']) ? $args['email'] : null;
            $fname = isset($args['fname']) ? $args['fname'] : "";
            $lname = isset($args['lname']) ? $args['lname'] : "";
            
            $api_prefix = explode("-",$api_key)[1];
            
            $fields = array(
                "email_address" => $email,
                "status" => "subscribed",
                "merge_fields" => array(
                    "FNAME" => $fname,
                    "LNAME" => $lname
                )
            );

            // $data = array(
            //     'sslverify' => true,
            //     'body' => json_encode( $fields ),
            //     "headers" => array(
            //         "Authorization" => 'Basic ' . base64_encode( $username.':'.$api_key ),
            //         "Content-Type"  => "application/json",
            //         "cache-control" => "no-cache",
            //         "Api-Token"     => $api_key
            //     )
            // );

            $url = "https://".$api_prefix.".api.mailchimp.com/3.0/lists/".$list_id."/members/";

            // $response = wp_remote_post($url, $data);

            // if ( is_wp_error( $response ) ) {
            //     $error_message = $response->get_error_message();
            //     return $error_message;
            // }

            // $body = wp_remote_retrieve_body( $response );
            
            // if( empty( $body )){
            //     return false;
            // }else{
            //     $body = json_decode($body,true);
            // }
            // return $body;

            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $url, //"https://".$api_prefix.".api.mailchimp.com/3.0/lists/".$list_id."/members/",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_SSL_VERIFYPEER => false,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_USERPWD => "$username:$api_key",
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_POSTFIELDS => json_encode($fields),
                CURLOPT_HTTPHEADER => array(
                    "Authorization: Basic " . base64_encode( $username.':'.$api_key ),
                    "Content-Type: application/json",
                    "cache-control: no-cache",
                    "Api-Token: ". $api_key
                ),
            ));

            $response = curl_exec($curl);
            
            $err = curl_error($curl);

            curl_close($curl);

            if ($err) {
                return "cURL Error #: " . $err;
            } else {
                return $response;
            }
        }

        // Campaign Monitor
        public function ays_add_monitor_transaction( $client, $api_key, $list_id, $args ) {
            if ($client == "" || $api_key == "") {
                return false;
            }

            $default_options = array(
                "CustomFields" => array(
                    array(
                        "Key"   => "from",
                        "Value" => $this->plugin_name
                    ),
                    array(
                        "Key"   => "date",
                        "Value" => date("Y/m/d", current_time('timestamp'))
                    )
                ),
                "Resubscribe"                            => true,
                "RestartSubscriptionBasedAutoresponders" => true,
                "ConsentToTrack"                         => "Yes"
            );

            $default_options = array_merge($args, $default_options);
            $default_options = json_encode($default_options);

            $auth = base64_encode( $api_key . ':x' );
            
            $data = array(
                'sslverify' => true,
                'body' => $default_options,
                "headers" => array(
                    "Content-Type"  => "application/json",
                    "cache-control" => "no-cache",
                    'Authorization' => "Basic $auth"
                )
            );

            $url = "https://api.createsend.com/api/v3.2/subscribers/$list_id.json";

            $response = wp_remote_post($url, $data);      

            if ( is_wp_error( $response ) ) {
                $error_message = $response->get_error_message();
                return $error_message;
            }

            $body = wp_remote_retrieve_body( $response );
            
            if( empty( $body )){
                return false;
            }else{
                $body = json_decode($body,true);
            }
            return $body;

            // $curl = curl_init();
            // curl_setopt_array($curl, array(
            //     CURLOPT_URL            => "https://api.createsend.com/api/v3.2/subscribers/$list_id.json",
            //     CURLOPT_RETURNTRANSFER => true,
            //     CURLOPT_ENCODING       => "",
            //     CURLOPT_MAXREDIRS      => 10,
            //     CURLOPT_TIMEOUT        => 30,
            //     CURLOPT_SSL_VERIFYPEER => false,
            //     CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            //     CURLOPT_USERPWD        => "$api_key:x",
            //     CURLOPT_CUSTOMREQUEST  => "POST",
            //     CURLOPT_POSTFIELDS     => json_encode(array_merge($args, $default_options)),
            //     CURLOPT_HTTPHEADER     => array(
            //         "Content-Type: application/json",
            //         "cache-control: no-cache"
            //     ),
            // ));

            // $response = curl_exec($curl);

            // $err = curl_error($curl);

            // curl_close($curl);

            // if ($err) {
            //     return "cURL Error #: " . $err;
            // } else {
            //     return $response;
            // }
        }

        // ActiveCampaign
        public function ays_add_active_camp_transaction( $url, $api_key, $args, $list_id, $automation_id, $data = "contact" ) {
            if ($url == "" || $api_key == "") {
                return false;
            }

            $datas = array(
                'sslverify' => true,
                'body' => json_encode( array(
                    "$data" => $args
                ) ),
                "headers" => array(
                    "Content-Type"  => "application/json",
                    "cache-control" => "no-cache",
                    "Api-Token" => $api_key,
                )
            );
            $url = "$url/api/3/{$data}s";

            $response = wp_remote_post($url, $datas);

            if ( is_wp_error( $response ) ) {
                $error_message = $response->get_error_message();
                return $error_message;
            }
            
            $body = wp_remote_retrieve_body( $response );
            if( empty( $body )){
                return false;
            }else{
                $body = json_decode($body, true);
                $res = isset( $body["$data"] ) ? $body["$data"] : "";
            }

            if ($data == "contactList" || $data == "contactAutomation") {
                return $res;
            } else {
                if($res != ""){
                    if ($list_id) {
                        $list_args = array(
                            "list"    => $list_id,
                            "contact" => $res['id'],
                            "status"  => 1
                        );
    
                        return $this->ays_add_active_camp_transaction($url, $api_key, $list_args, $list_id, $automation_id, 'contactList');
                    }
                    if ($automation_id) {
                        $automation_args = array(
                            "automation" => $automation_id,
                            "contact"    => $res['id']
                        );
    
                        return $this->ays_add_active_camp_transaction($url, $api_key, $automation_args, $list_id, $automation_id, 'contactAutomation');
                    }
                }

                return $res;
            }

            // $curl = curl_init();
            // curl_setopt_array($curl, array(
            //     CURLOPT_URL            => "$url/api/3/{$data}s",
            //     CURLOPT_RETURNTRANSFER => true,
            //     CURLOPT_ENCODING       => "",
            //     CURLOPT_MAXREDIRS      => 10,
            //     CURLOPT_TIMEOUT        => 30,
            //     CURLOPT_SSL_VERIFYPEER => false,
            //     CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
            //     CURLOPT_CUSTOMREQUEST  => "POST",
            //     CURLOPT_POSTFIELDS     => json_encode(array("$data" => $args)),
            //     CURLOPT_HTTPHEADER     => array(
            //         "Content-Type: application/json",
            //         "cache-control: no-cache",
            //         "Api-Token: $api_key"
            //     ),
            // ));

            // $response = curl_exec($curl);

            // $err = curl_error($curl);

            // curl_close($curl);

            // $res = $err ? array(
            //     'Code'       => 0,
            //     'cURL Error' => $err
            // ) : json_decode($response, true)["$data"];

            // if ($data == "contactList" || $data == "contactAutomation") {
            //     return $res;
            // } else {
            //     if ($list_id) {
            //         $list_args = array(
            //             "list"    => $list_id,
            //             "contact" => $res['id'],
            //             "status"  => 1
            //         );

            //         return $this->ays_add_active_camp_transaction($url, $api_key, $list_args, $list_id, $automation_id, 'contactList');
            //     }
            //     if ($automation_id) {
            //         $automation_args = array(
            //             "automation" => $automation_id,
            //             "contact"    => $res['id']
            //         );

            //         return $this->ays_add_active_camp_transaction($url, $api_key, $automation_args, $list_id, $automation_id, 'contactAutomation');
            //     }

            //     return $res;
            // }

        }

        // GetResponse
        public function ays_popup_add_getResponse_contact($data){
            if(empty($data)){
                return false;
            }
            
            $api_key = isset($data['api_key']) && $data['api_key'] != "" ? $data['api_key'] : "";
            $list_id = isset($data['list_id']) && $data['list_id'] != "" ? $data['list_id'] : "";
            if($api_key == "" || $list_id == ""){
                return false;
            }
            $user_email = isset($data['email']) && $data['email'] != "" ? $data['email'] : "";
            $user_fname = isset($data['fname']) && $data['fname'] != "" ? $data['fname'] : "";
            $user_lname = isset($data['lname']) && $data['lname'] != "" ? $data['lname'] : "";

            $url = "https://api.getresponse.com/v3/contacts";
            $headers = array(
                'sslverify' => true,
                "headers" => array(
                    "X-Auth-Token" => "api-key ".$api_key
                ),
                "body"    => array(
                    "name" => $user_fname." ".$user_lname,
                    "campaign" => array(
                        "campaignId" => $list_id
                    ),
                    "email" => $user_email
                )
            );
            $api_call = wp_remote_post($url , $headers);

            $response = wp_remote_retrieve_body($api_call);
            if(wp_remote_retrieve_response_code($api_call) != 200){
                return false;
            }
        }

        // ConvertKit
        public function ays_popup_convertKit_add_user($data) {
            if (empty($data)) {
                return false;
            }

            $api_key = isset($data['api_key']) && $data['api_key'] != '' ? $data['api_key'] : '';
            $convertKit_fname   = (isset($data['fname']) && $data['fname'] != "") ? $data['fname'] : "";
            $convertKit_lname   = (isset($data['lname']) && $data['lname'] != "") ? $data['lname'] : "";
            $convertKit_email   = (isset($data['email']) && $data['email'] != "") ? $data['email'] : "";
            $convertKit_form_id = (isset($data['form_id']) && $data['form_id'] != "") ? $data['form_id'] : "";

            if($api_key == "" || $convertKit_form_id == "" || $convertKit_email == ""){
                return false;
            }

            $url = "https://api.convertkit.com/v3/forms/".$convertKit_form_id."/subscribe?";
            $url .= http_build_query(array(
                    "email"      => $convertKit_email,
                    "api_key"    => $api_key,
                    "first_name" => $convertKit_fname
                )
            );

            $api_call = wp_remote_post($url);
        }

        // Sendinblue add contact to a list
        public function ays_popup_sendinblue_add_contact_to_list($data) {
            if (empty($data)) {
                return false;
            }

            $sendinblue_api_key = isset($data['api_key']) && $data['api_key'] != '' ? $data['api_key'] : '';
            $sendinblue_fname   = (isset($data['fname']) && $data['fname'] != "") ? $data['fname'] : "";
            $sendinblue_lname   = (isset($data['lname']) && $data['lname'] != "") ? $data['lname'] : "";
            $sendinblue_email   = (isset($data['email']) && $data['email'] != "") ? $data['email'] : "";
            $sendinblue_list_id = (isset($data['list_id']) && $data['list_id'] != "") ? intval($data['list_id']) : "";
            
            if($sendinblue_api_key == "" || $sendinblue_list_id == "" || $sendinblue_email == ""){
                return false;
            }

            $url = "https://api.sendinblue.com/v3/contacts";
            $headers = array(
                'content-type' => 'application/json',
                'api-key'      => $sendinblue_api_key
            );
            $body = array(
                "attributes" => array(
                    "FIRSTNAME" => $sendinblue_fname,
                    "LASTNAME"  => $sendinblue_lname
                ),
                "updateEnabled" => false,
                "email"   => $sendinblue_email,
                "listIds" => array($sendinblue_list_id)
            );
            
            $settings = array(
                'sslverify' => true,
                "headers" => $headers,
                "body"    => json_encode($body)
            );

            $api_call = wp_remote_post($url, $settings);
        }

        // MalerLite add contact to a group
        public function ays_popup_malerLite_add_contact_to_group($data) {
            if (empty($data)) {
                return false;
            }

            $malerLite_api_key  = isset($data['api_key'])   && $data['api_key'] != '' ? $data['api_key'] : '';
            $malerLite_name     = (isset($data['name'])     && $data['name'] != "") ? $data['name'] : "";
            $malerLite_email    = (isset($data['email'])    && $data['email'] != "") ? $data['email'] : "";
            $malerLite_group_id = (isset($data['group_id']) && $data['group_id'] != "") ? intval($data['group_id']) : "";
            
            if($malerLite_api_key == "" || $malerLite_group_id == "" || $malerLite_email == ""){
                return false;
            }

            $url = "https://api.mailerlite.com/api/v2/groups/".$malerLite_group_id."/subscribers";
            $headers = array(
                'content-type'        => 'application/json',
                'X-MailerLite-ApiKey' => $malerLite_api_key
            );
            $body = array(
                "name"    => $malerLite_name,
                "email"   => $malerLite_email
            );
            
            $settings = array(
                'sslverify' => true,
                "headers" => $headers,
                "body"    => json_encode($body)
            );
            $api_call = wp_remote_post($url, $settings);
            
        }

    // ===== Front end calls end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== Integration calls end =====

    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////

    // ===== reCAPTCHA start =====

        // reCAPTCHA integration

        // reCAPTCHA integration in popup page content
        public function ays_popup_page_recaptcha_content( $integrations, $args ){

            $popup_settings = $this->settings_obj;
            // reCAPTCHA
            $recaptcha_res  = ($popup_settings->ays_get_setting('recaptcha') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('recaptcha');
            $recaptcha      = json_decode($recaptcha_res, true);
            $recaptcha_site_key = isset($recaptcha['site_key']) && $recaptcha['site_key'] != "" ? esc_attr($recaptcha['site_key']) : '';
            $recaptcha_secret_key = isset($recaptcha['secret_key']) && $recaptcha['secret_key'] != "" ? esc_attr($recaptcha['secret_key']) : '';

            $enable_recaptcha = $args['enable_recaptcha'];

            $icon = AYS_PB_ADMIN_URL .'/images/integrations/recaptcha_logo.png';
            $title = __('reCAPTCHA Settings',$this->plugin_name);

            $content = '';
            if(count($recaptcha) > 0){
                if($recaptcha_site_key == "" || $recaptcha_secret_key == ""){
                    $content .= $this->blockquote_content;
                }else{
                    $disabled = ($recaptcha_site_key == "" || $recaptcha_secret_key == "") ? "disabled" : '';
                    $checked = ($enable_recaptcha == true) ? "checked" : '';

                    $content .= '<div class="form-group row">
                            <div class="col-sm-4">
                                <label for="ays_popup_enable_recaptcha">'. __('Enable reCAPTCHA', $this->plugin_name) .'</label>
                            </div>
                            <div class="col-sm-1">
                                <input type="checkbox" class="ays-enable-timer1" id="ays_popup_enable_recaptcha" name="ays_popup_enable_recaptcha" value="on" '.$checked.' '.$disabled.'/>
                            </div>
                        </div>';
                }
            }else{
                $content .= $this->blockquote_content;
            }

            $integrations['recaptcha'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;
        }

        // reCAPTCHA integration in popup page options
        public function ays_popup_page_recaptcha_options( $args, $options ){

            // reCAPTCHA
            $args['enable_recaptcha'] = (isset($options['enable_recaptcha']) && $options['enable_recaptcha'] == 'on') ? true : false;

            return $args;
        }

        // reCAPTCHA integration in popup page data saver
        public function ays_popup_page_recaptcha_save( $options, $data ){

            $options['enable_recaptcha'] = ( isset( $data['ays_popup_enable_recaptcha'] ) && $data['ays_popup_enable_recaptcha'] == 'on' ) ? 'on' : 'off';

            return $options;
        }

        // reCAPTCHA integration / settings page

        // reCAPTCHA integration in General settings page content
        public function ays_settings_page_recaptcha_content( $integrations, $args ){

            $actions = $this->settings_obj;

            // reCAPTCHA
            $recaptcha_options = ($actions->ays_get_setting('recaptcha') === false) ? json_encode(array()) : $actions->ays_get_setting('recaptcha');
            $recaptcha_options = json_decode($recaptcha_options, true);
            $recaptcha_site_key = isset($recaptcha_options['site_key']) && $recaptcha_options['site_key'] != "" ? esc_attr($recaptcha_options['site_key']) : '';
            $recaptcha_secret_key = isset($recaptcha_options['secret_key']) && $recaptcha_options['secret_key'] != "" ? esc_attr($recaptcha_options['secret_key']) : '';
            $recaptcha_language = isset($recaptcha_options['language']) && $recaptcha_options['language'] != "" ? esc_attr($recaptcha_options['language']) : '';
            $recaptcha_theme = isset($recaptcha_options['theme']) && $recaptcha_options['theme'] != "" ? esc_attr($recaptcha_options['theme']) : 'light';

            $icon  = AYS_PB_ADMIN_URL . '/images/integrations/recaptcha_logo.png';
            $title = __( 'reCAPTCHA', $this->plugin_name );

            $content = '';
            $content .= '
                    <div class="form-group row">
                        <div class="col-sm-12">
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_popup_recaptcha_site_key">'. __('reCAPTCHA v2 Site Key', $this->plugin_name) .'</label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" class="ays-text-input" id="ays_popup_recaptcha_site_key" name="ays_popup_recaptcha_site_key" value="'. $recaptcha_site_key .'" >
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_popup_recaptcha_secret_key">'. __('reCAPTCHA v2 Secret Key', $this->plugin_name) .'</label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" class="ays-text-input" id="ays_popup_recaptcha_secret_key" name="ays_popup_recaptcha_secret_key" value="'. $recaptcha_secret_key .'" >
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_popup_recaptcha_language">'. __('reCAPTCHA Language', $this->plugin_name) .'</label>
                                </div>
                                <div class="col-sm-9">
                                    <input type="text" class="ays-text-input" id="ays_popup_recaptcha_language" name="ays_popup_recaptcha_language" value="'. $recaptcha_language .'" >
                                    <span class="ays_popup_small_hint_text">
                                        <span>' . sprintf(
                                            __( "e.g. en, de - Language used by reCAPTCHA. To get the code for your language click %s here %s", $this->plugin_name ),
                                            '<a href="https://developers.google.com/recaptcha/docs/language" target="_blank">',
                                            "</a>"
                                        ) . '</span>
                                    </span>
                                </div>
                            </div>
                            <hr/>
                            <div class="form-group row">
                                <div class="col-sm-3">
                                    <label for="ays_popup_recaptcha_theme">'. __('reCAPTCHA Theme', $this->plugin_name) .'</label>
                                </div>
                                <div class="col-sm-9">
                                    <select class="ays-text-input" id="ays_popup_recaptcha_theme" name="ays_popup_recaptcha_theme" >
                                        <option value="light" '. ( $recaptcha_theme == 'light' ? 'selected' : '' ) .'>'. __('Light', $this->plugin_name) .'</option>
                                        <option value="dark" '. ( $recaptcha_theme == 'dark' ? 'selected' : '' ) .'>'. __('Dark', $this->plugin_name) .'</option>
                                    </select>
                                </div>
                            </div>
                            ';
            $content .= '<blockquote>';
            $content .= sprintf( __( "You need to set up reCAPTCHA in your Google account to generate the required keys and get them by %s Google's reCAPTCHA admin console %s.", $this->plugin_name ), "<a href='https://www.google.com/recaptcha/admin/create' target='_blank'>", "</a>");
            $content .= '</blockquote>';
            $content .= '
                    </div>
                </div>';

            $integrations['recaptcha'] = array(
                'content' => $content,
                'icon' => $icon,
                'title' => $title,
            );

            return $integrations;
        }

        // reCAPTCHA integration in General settings page data saver
        public function ays_settings_page_recaptcha_save( $fields, $data ){

            $recaptcha_site_key = isset($data['ays_popup_recaptcha_site_key']) && $data['ays_popup_recaptcha_site_key'] != "" ? sanitize_text_field($data['ays_popup_recaptcha_site_key']) : '';
            $recaptcha_secret_key = isset($data['ays_popup_recaptcha_secret_key']) && $data['ays_popup_recaptcha_secret_key'] != "" ? sanitize_text_field($data['ays_popup_recaptcha_secret_key']) : '';
            $recaptcha_language = isset($data['ays_popup_recaptcha_language']) && $data['ays_popup_recaptcha_language'] != "" ? sanitize_text_field($data['ays_popup_recaptcha_language']) : '';
            $recaptcha_theme = isset($data['ays_popup_recaptcha_theme']) && $data['ays_popup_recaptcha_theme'] != "" ? sanitize_text_field($data['ays_popup_recaptcha_theme']) : '';

            $recaptcha_options = array(
                "site_key" => $recaptcha_site_key,
                "secret_key" => $recaptcha_secret_key,
                "language" => $recaptcha_language,
                "theme" => $recaptcha_theme,
            );

            $fields['recaptcha'] = $recaptcha_options;

            return $fields;
        }

        // reCAPTCHA integration / front-end

        // reCAPTCHA integration in front-end functional
        public function ays_front_end_recaptcha_functional( $arguments, $options, $data ){
            
            if( isset( $options['enable_recaptcha'] ) && $options['enable_recaptcha'] ){

                $popup_settings = $this->settings_obj;

                // reCAPTCHA
                $recaptcha_options = ($popup_settings->ays_get_setting('recaptcha') === false) ? json_encode(array()) : $popup_settings->ays_get_setting('recaptcha');
                $recaptcha_options = json_decode($recaptcha_options, true);
                $recaptcha_site_key = isset($recaptcha_options['site_key']) && $recaptcha_options['site_key'] != "" ? esc_attr($recaptcha_options['site_key']) : '';
                $recaptcha_secret_key = isset($recaptcha_options['secret_key']) && $recaptcha_options['secret_key'] != "" ? esc_attr($recaptcha_options['secret_key']) : '';
                $recaptcha_language = isset($recaptcha_options['language']) && $recaptcha_options['language'] != "" ? esc_attr($recaptcha_options['language']) : '';
                $recaptcha_theme = isset($recaptcha_options['theme']) && $recaptcha_options['theme'] != "" ? esc_attr($recaptcha_options['theme']) : '';

                $hl = '';
                if( $recaptcha_language != '' ){
                    $hl = "&hl=".$recaptcha_language;
                }

                wp_enqueue_script(
                    $this->plugin_name . '-grecaptcha',
                    // 'https://www.google.com/recaptcha/api.js?onload=wpformsRecaptchaLoad&render=explicit',
                    'https://www.google.com/recaptcha/api.js?render=explicit' . $hl,
                    array('jquery'),
                    null,
                    true
                );

                wp_enqueue_script(
                    $this->plugin_name . '-grecaptcha-js',
                    AYS_PB_PUBLIC_URL . '/js/partials/grecaptcha.js',
                    array('jquery'),
                    $this->version,
                    true
                );

                $unique_key = uniqid();

                $options = array(
                    'uniqueKey' => $unique_key,
                    'siteKey' => $recaptcha_site_key,
                    'secretKey' => $recaptcha_secret_key,
                    'language' => $recaptcha_language,
                    'theme' => $recaptcha_theme,
                );

                $inline_js = "
                    if(typeof aysPopupRecaptchaObj === 'undefined'){
                        var aysPopupRecaptchaObj = [];
                    }
                    aysPopupRecaptchaObj['" . $unique_key . "']  = '" . base64_encode( json_encode( $options ) ) . "';
                ";
                wp_add_inline_script( $this->plugin_name . '-grecaptcha', $inline_js, 'before' );

                $data_content = '';
                $data_content .= '<div class="ays-pb-section ays-popup-recaptcha-section">';
                    $data_content .= '<div class="ays-pb-section-header">';
                        $data_content .= '<div class="ays-pb-recaptcha-wrap">';
                            $data_content .= '<div class="ays-pb-g-recaptcha" data-unique-key="'. $unique_key .'"></div>';
                            $data_content .= '<div class="ays-pb-g-recaptcha-hidden-error ays-pb-question-validation-error">'. __( "reCAPTCHA field is required please complete!", $this->plugin_name ) .'</div>';
                        $data_content .= '</div>';
                    $data_content .= '</div>';
                $data_content .= '</div>';
    
                $arguments[] = $data_content;
            }

            return $arguments;
        }

        // reCAPTCHA integration in front-end options
        public function ays_front_end_recaptcha_options( $args, $setting ){
            $options = $setting;

            // reCAPTCHA
            $args['enable_recaptcha'] = ( isset( $options['enable_recaptcha'] ) && $options['enable_recaptcha'] == 'on') ? true : false;

            return $args;
        }

    // ===== reCAPTCHA end =====


    ////////////////////////////////////////////////////////////////////////////////////////
    //====================================================================================//
    ////////////////////////////////////////////////////////////////////////////////////////
}