<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       http://ays-pro.com/
 * @since      1.0.0
 *
 * @package    Ays_Pb
 * @subpackage Ays_Pb/includes
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Ays_Pb
 * @subpackage Ays_Pb/includes
 * @author     AYS Pro LLC <info@ays-pro.com>
 */

class Ays_Pb_Data {

    public static function get_validated_data_from_array( $popupbox, $attr ){
        global $wpdb;
        global $wp_roles;


        // Array for popup box validated options
        $settings = array();
        
        // ID
        $id = ( isset($attr['id']) ) ? absint( intval( $attr['id'] ) ) : null;
        $settings['id'] = $id;

        // PopUp box options
        $options = array();
        if( isset( $popupbox['options'] ) && $popupbox['options'] != '' ){
            $options = json_decode( $popupbox['options'], true );
        }
        $settings['options'] = json_encode($options);

        $popup_attributes = array();
        if( isset( $popupbox['attributes'] ) && $popupbox['attributes'] != '' ){
            $popup_attributes = json_decode( $popupbox['attributes'], true );
        }

        // CUSTOM FIELDS
        $settings['popup_attributes'] = (isset($popup_attributes['popup_attributes']) && !empty($popup_attributes['popup_attributes']) ) ? $popup_attributes['popup_attributes'] : array(); 

        $popupbox['onoffswitch'] = isset($popupbox['onoffswitch']) && $popupbox['onoffswitch'] != '' ? strtolower( $popupbox['onoffswitch'] ) : 'on';
        $ays_popup_on = isset($popupbox['onoffswitch']) && $popupbox['onoffswitch'] == 'on' ? true : false;
        $onoffswitch = $ays_popup_on;

        //Schedule the PopupBox
        $shedule_flag = '';
        $active_date_check = isset($popupbox['active_date_check']) && $popupbox['active_date_check'] == "on" ? true : false;
        $settings['active_date_check'] = $active_date_check;

        $activeIntervalDate = isset($popupbox['activeInterval']) && $popupbox['activeInterval'] != "" ? $popupbox['activeInterval'] : '';
        $settings['activeInterval'] = $activeIntervalDate;

        $deactiveIntervalDate = isset($popupbox['deactiveInterval']) && $popupbox['deactiveInterval'] != "" ? $popupbox['deactiveInterval'] : '';
        $settings['deactiveInterval'] = $deactiveIntervalDate;

        //Coupons
        $settings['pb_coupons_array'] = (isset($options['pb_coupons_array']) && $options['pb_coupons_array'] != '') ? $options['pb_coupons_array'] : array();

        //Hide on PC
        $options['hide_on_pc'] = ( isset( $options['hide_on_pc'] ) && $options['hide_on_pc'] == "on" ) ? "on" : "off";
        $settings['hide_on_pc'] = ( isset( $options['hide_on_pc'] ) && $options['hide_on_pc'] == "on" ) ? true : false;
        
        //Hide on Tablet
        $options['hide_on_tablets'] = ( isset( $options['hide_on_tablets'] ) && $options['hide_on_tablets'] == "on" ) ? "on" : "off";
        $settings['hide_on_tablets'] = ( isset( $options['hide_on_tablets'] ) && $options['hide_on_tablets'] == "on" ) ? true : false;

        // Countdown type timer end     
        if($popupbox['modal_content'] == 'countdown' && $ays_popup_on){
            if(isset($options['ays_pb_countdown_date']) && $options['ays_pb_countdown_date'] != ""){
                $current_time = strtotime(current_time( "Y:m:d H:i:s" ));
                $countdown_end_date = strtotime($options['ays_pb_countdown_date']);
                if($current_time > $countdown_end_date){
                    $onoffswitch = false;
                }
            }

            if($options['ays_pb_countdown_date'] == "" ){
                $onoffswitch = false;
            }
        }

        if ($ays_popup_on && $active_date_check){
            if ( $activeIntervalDate && $activeIntervalDate != "" && $deactiveIntervalDate && $deactiveIntervalDate != "" ) {
                $activeInterval = array();
                $deactiveInterval = array();

                if ( $activeIntervalDate != '' ) {
                    $activeInterval = json_decode( $activeIntervalDate, true );
                    if( $activeInterval === null ){
                        $activeInterval = array();
                        $activeInterval[0] = $activeIntervalDate;
                    }
                }

                if ( $deactiveIntervalDate != '' ) {
                    $deactiveInterval = json_decode( $deactiveIntervalDate, true );
                    if( $activeInterval === null ){
                        $deactiveInterval = array();
                        $deactiveInterval[0] = $deactiveIntervalDate;
                    }
                }

                $current_time = strtotime(current_time( "Y:m:d H:i:s" ));
                foreach ($activeInterval as $key => $active_value) {
                    $startDate = strtotime($active_value);                    
                    $endDate = strtotime($deactiveInterval[$key]);
                    if ($startDate < $current_time && $endDate > $current_time) {
                        $onoffswitch = $ays_popup_on;
                        $shedule_flag = "On";
                        break;
                    }else{
                        $onoffswitch = false;
                        $shedule_flag = "Off";
                    }
                }
            }
        }

        //Enable for selected user OS
        $users_os = (isset($options['users_os']) && $options['users_os'] != "") ? json_decode($options['users_os'], true) : array();
        $flag = false;
        if(!empty($users_os)){
            if($shedule_flag === "On" || $shedule_flag === ''){
                $user_os = self::ays_pb_get_OS($users_os);
                if($user_os){
                    $flag = true;
                    $onoffswitch = $ays_popup_on;
                }else{
                    $flag = false;
                    $onoffswitch = false;
                }
            }else{
                $onoffswitch = false;
            }
        }
        
        //Enable for selected browsers
        $users_browser = (isset($options['users_browser']) && $options['users_browser'] != "") ? json_decode($options['users_browser'], true) : array();
        if(!empty($users_browser)){
            if($shedule_flag === "On" || $shedule_flag === ''){
                $user_browser = self::ays_pb_get_browser($users_browser);
                if($flag || empty($users_os)){
                    if($user_browser){
                        $onoffswitch = $ays_popup_on;
                    }else{
                        $onoffswitch = false;
                    }
                }else{
                    $onoffswitch = false;
                }
            }else{
                $onoffswitch = false;
            }
        }
        
        //Hide PopupBox on mobile
        if(isset($options['pb_mobile']) && $options['pb_mobile'] == "on"){
            $check_mobile_device = self::ays_pb_detect_mobile_device();
            if ($check_mobile_device) {
                $onoffswitch = false;
            }
        }

        if( $settings['hide_on_pc'] ){
            $check_pc = self::ays_pb_detect_mobile_device();
            if( !$check_pc ){
                $onoffswitch = false;
            }
        }

        if( $settings['hide_on_tablets'] ){
            $check_tablets = self::ays_pb_detect_tablet_device();
            if( $check_tablets ){
                $onoffswitch = false;
            }
        }

        //Enable for guests օr logged in users 
        if (isset($popupbox['log_user']) && isset($popupbox['guest'])){
            if ( ( is_user_logged_in() && $popupbox['log_user'] != "On" ) || ( $popupbox['guest'] !='On' && $popupbox['log_user'] != "On" ) ) {
                $onoffswitch = false;
            }
            elseif (!is_user_logged_in() && $popupbox['log_user'] == "On"){
                if ($popupbox['guest'] !='On') {
                    $onoffswitch = false;
                }
            }
        }
        
        //limitation count of popup boxes
        if(isset($options['enable_tackers_count']) && $options['enable_tackers_count'] == 'on'){
            $tackers_count = absint(intval($options['tackers_count']));
            $get_pb_count_by_id = self::get_pb_count_by_id($id);
            $pb_count = absint(intval($get_pb_count_by_id));
            if($shedule_flag === "On" || $shedule_flag === ''){
                if($pb_count >= $tackers_count){
                    $onoffswitch = false;
                }else{
                    $onoffswitch = true;
                }
            }else{
                $onoffswitch = true;
            }
        }

        // Tigran
        $user = wp_get_current_user();
        $users_roles  = $wp_roles->role_names;
        $users_role = (isset($popupbox['users_role']) && $popupbox['users_role'] != '') ? $popupbox['users_role'] : '';
        $user_role_arr = json_decode($users_role);
        if (isset($user_role_arr) && is_array($user_role_arr) ) {
            $users_role = array_map('esc_attr', $user_role_arr);
        }
        if(!empty($users_role)){
            if (is_array($users_role)) {
                foreach($users_role as $key => $role){
                    if(in_array($role, $users_roles)){
                        $users_role[$key] = array_search($role, $users_roles);
                    }                        
                }
            }else{
                if(in_array($users_role, $users_roles)){
                    $users_role = array_search($users_role, $users_roles);
                }
            }
            $is_user_role = false;
            if(is_array($users_role)){
                foreach($users_role as $role){                        
                    if (in_array(strtolower($role), (array)$user->roles)) {
                        $is_user_role = true;
                        break;
                    }
                }                    
            }else{
                if (in_array(strtolower($users_role), (array)$user->roles)) {
                    $is_user_role = true;
                }
            }

            if (!$is_user_role) {
                $onoffswitch = false;
            }
        }

        $settings['onoffswitch'] = $onoffswitch;

        if( isset( $options['show_only_once'] ) && $options['show_only_once'] == 'on' ){
            $settings['show_only_once'] = true;
        }elseif( ! isset( $options['show_only_once'] ) ){
            $settings['show_only_once'] = null;
        }else{
            $settings['show_only_once'] = false;
        }

        if( isset( $options['pb_dismiss_closing'] ) && $options['pb_dismiss_closing'] == 'on' ){
            $settings['pb_dismiss_closing'] = true;
        }elseif( ! isset( $options['pb_dismiss_closing'] ) ){
            $settings['pb_dismiss_closing'] = null;
        }else{
            $settings['pb_dismiss_closing'] = false;
        }

        $settings['cookie'] = isset( $popupbox['cookie'] ) && $popupbox['cookie'] != '' ? intval( $popupbox['cookie'] ) : 0;



        $width = (isset( $popupbox["width"] ) && $popupbox["width"] != '' && $popupbox['width'] != 0) ? $popupbox["width"] : '400';
        $width = ( isset($attr['w']) ) ? absint( intval( $attr['w'] ) ) : $width;

        $height = (isset( $popupbox["height"] ) && $popupbox["height"] != '' && $popupbox["height"] != 0) ? $popupbox["height"] : '500';
        $height = ( isset($attr['h']) ) ? absint( intval( $attr['h'] ) ) : $height;

        $settings["width"] = $width;
        $settings["height"] = $height;

        $settings["shortcode"] = isset( $popupbox["shortcode"] ) && $popupbox["shortcode"] != '' ? $popupbox["shortcode"] : '';

        $popupbox['show_popup_title'] = isset($popupbox['show_popup_title']) && $popupbox['show_popup_title'] != '' ? strtolower( $popupbox['show_popup_title'] ) : 'on';
        $settings["show_popup_title"] = isset($popupbox['show_popup_title']) && $popupbox['show_popup_title'] == 'on' ? true : false;

        $popupbox['show_popup_desc'] = isset($popupbox['show_popup_desc']) && $popupbox['show_popup_desc'] != '' ? strtolower( $popupbox['show_popup_desc'] ) : 'on';
        $settings["show_popup_desc"] = isset($popupbox['show_popup_desc']) && $popupbox['show_popup_desc'] == 'on' ? true : false;

        $popupbox['close_button'] = isset($popupbox['close_button']) && $popupbox['close_button'] != '' ? strtolower( $popupbox['close_button'] ) : 'off';
        $settings["close_button"] = isset($popupbox['close_button']) && $popupbox['close_button'] == 'on' ? true : false;
        
        $settings["autoclose"] = isset($popupbox['autoclose']) && $popupbox['autoclose'] != '' ? intval( $popupbox['autoclose'] ) : 20;

        $settings["title"] = isset($popupbox['title']) && $popupbox['title'] != '' ? stripslashes( esc_attr($popupbox['title']) ) : '';

        $settings["description"] = isset($popupbox['description']) && $popupbox['description'] != '' ? $popupbox['description'] : '';

        $settings["custom_css"] = isset($popupbox['custom_css']) && $popupbox['custom_css'] != '' ? wp_unslash( stripslashes( htmlspecialchars_decode( $popupbox["custom_css"] ) ) ) : '';
        $settings["custom_html"] = isset($popupbox['custom_html']) && $popupbox['custom_html'] != '' ? $popupbox['custom_html'] : '';
        $settings["custom_class"] = isset($popupbox['custom_class']) && $popupbox['custom_class'] != '' ? stripslashes( esc_attr($popupbox['custom_class']) ) : '';

        $settings["animate_in"] = isset($popupbox['animate_in']) && $popupbox['animate_in'] != '' ? stripslashes( esc_attr($popupbox['animate_in']) ) : 'fadeIn';
        $settings["animate_out"] = isset($popupbox['animate_out']) && $popupbox['animate_out'] != '' ? stripslashes( esc_attr($popupbox['animate_out']) ) : 'fadeOut';

        $settings["view_type"] = isset($popupbox['view_type']) && $popupbox['view_type'] != '' ? stripslashes( esc_attr($popupbox['view_type']) ) : 'default';

        $settings["delay"] = isset($popupbox['delay']) && $popupbox['delay'] != '' ? intval( $popupbox['delay'] ) : 0;
        $settings["scroll_top"] = isset($popupbox['scroll_top']) && $popupbox['scroll_top'] != '' ? intval( $popupbox['scroll_top'] ) : 0;

        $settings["show_all"] = isset($popupbox['show_all']) && $popupbox['show_all'] != '' ? stripslashes( esc_attr($popupbox['show_all']) ) : 'all';

        $settings["action_button"] = isset($popupbox['action_button']) && $popupbox['action_button'] != '' ? stripslashes( esc_attr($popupbox['action_button']) ) : '';

        $settings["action_button_type"] = isset($popupbox['action_button_type']) && $popupbox['action_button_type'] != '' ? stripslashes( esc_attr($popupbox['action_button_type']) ) : 'both';

        $settings["modal_content"] = isset($popupbox['modal_content']) && $popupbox['modal_content'] != '' ? stripslashes( esc_attr($popupbox['modal_content']) ) : 'shortcode';

        $settings["pb_position"] = isset($popupbox['pb_position']) && $popupbox['pb_position'] != '' ? stripslashes( esc_attr($popupbox['pb_position']) ) : 'center-center';
        $settings["pb_margin"] = isset($popupbox['pb_margin']) && $popupbox['pb_margin'] != '' ? intval( $popupbox['pb_margin'] ) : 0;
        $settings["bgcolor2"] = isset($options['bgcolor2']) && $options['bgcolor2'] != '' ? stripslashes( esc_attr($options['bgcolor2']) ) : '#ffffff';
        $settings["ct_image"] = isset($options['ct_image']) && $options['ct_image'] != '' ? $options['ct_image'] : '';

        $settings["bgcolor"] = isset($popupbox['bgcolor']) && $popupbox['bgcolor'] != '' ? stripslashes( esc_attr($popupbox['bgcolor']) ) : '#ffffff';
        $settings["header_bgcolor"] = isset($popupbox['header_bgcolor']) && $popupbox['header_bgcolor'] != '' ? stripslashes( esc_attr($popupbox['header_bgcolor']) ) : '#ffffff';
        $settings["textcolor"] = isset($popupbox['textcolor']) && $popupbox['textcolor'] != '' ? stripslashes( esc_attr($popupbox['textcolor']) ) : '#000000';
        $settings["bordersize"] = isset($popupbox['bordersize']) && $popupbox['bordersize'] != '' ? intval( $popupbox['bordersize'] ) : 0;
        $settings["bordercolor"] = isset($popupbox['bordercolor']) && $popupbox['bordercolor'] != '' ? stripslashes( esc_attr($popupbox['bordercolor']) ) : '#000000';
        $settings["border_radius"] = isset($popupbox['border_radius']) && $popupbox['border_radius'] != '' ? stripslashes( esc_attr($popupbox['border_radius']) ) : 4;

        //popup box font-family
        $settings["pb_font_family"] = (isset($options['pb_font_family']) && $options['pb_font_family'] != '') ? stripslashes( esc_attr($options['pb_font_family']) ) : 'inherit';


        $settings["bg_image"] = (isset($popupbox['bg_image']) && $popupbox['bg_image'] != '') ? $popupbox['bg_image'] : '';

        //Background Gradient
        $options["enable_background_gradient"] = (!isset($options['enable_background_gradient'])) ? 'off' : strtolower( $options['enable_background_gradient'] );
        $settings["enable_background_gradient"] = (isset( $options['enable_background_gradient'] ) && $options['enable_background_gradient'] == 'on') ? true : false;
        $settings["pb_gradient_direction"] = (!isset($options['pb_gradient_direction'])) ? 'horizontal' : stripslashes( esc_attr($options['pb_gradient_direction']) );
        $settings["background_gradient_color_1"] = (!isset($options['background_gradient_color_1'])) ? "#000000" : stripslashes( esc_attr($options['background_gradient_color_1']) );
        $settings["background_gradient_color_2"] = (!isset($options['background_gradient_color_2'])) ? "#fff" : stripslashes( esc_attr($options['background_gradient_color_2']) );

        $settings["close_button_position"] = (isset($options['close_button_position']) && $options['close_button_position'] != '') ? stripslashes( esc_attr($options['close_button_position']) ) : 'right-top';

        //ays_pb_hover_show_close_btn
        $options['ays_pb_hover_show_close_btn'] = (isset($options['ays_pb_hover_show_close_btn']) && $options['ays_pb_hover_show_close_btn'] == "on") ? "on" : "off";
        $settings["ays_pb_hover_show_close_btn"] = (isset($options['ays_pb_hover_show_close_btn']) && $options['ays_pb_hover_show_close_btn'] == "on") ? true : false;

        // Disable Scrolling
        $options['disable_scroll'] = (isset($options['disable_scroll']) && $options['disable_scroll'] == "on") ? "on" : "off";
        $settings["disable_scroll"] = (isset($options['disable_scroll']) && $options['disable_scroll'] == "on") ? true : false;


        $settings["popup_width_by_percentage_px"] = (isset($options['popup_width_by_percentage_px']) && $options['popup_width_by_percentage_px'] != '') ? stripslashes( esc_attr($options['popup_width_by_percentage_px']) ) : 'pixels';

        $settings["popup_padding_by_percentage_px"] = (isset($options['popup_padding_by_percentage_px']) && $options['popup_padding_by_percentage_px'] != '') ? stripslashes( esc_attr($options['popup_padding_by_percentage_px']) ) : 'pixels';

        $default_padding = ($settings["view_type"] != 'minimal') ? 20 : 0;
        $settings["popup_content_padding"] =  (isset($options["popup_content_padding"]) && $options["popup_content_padding"] != '') ? absint( intval($options["popup_content_padding"]) ) : $default_padding;
        
        $options['enable_pb_fullscreen'] = (isset($options['enable_pb_fullscreen']) && $options['enable_pb_fullscreen'] != '') ? $options['enable_pb_fullscreen'] : 'off';
        $settings["enable_pb_fullscreen"] = (isset($options['enable_pb_fullscreen']) && $options['enable_pb_fullscreen'] == 'on') ? true : false;

        //Autoclose on video completion
        $settings["enable_autoclose_on_completion"] = (isset($options['enable_autoclose_on_completion']) && $options['enable_autoclose_on_completion'] == 'on') ? 'on' : 'off';

        //Overlay Color
        $settings["overlay_color"] = (isset($options["overlay_color"]) && $options["overlay_color"] != '') ? stripslashes( esc_attr($options["overlay_color"]) ) : "#000";

        //Close button delay
        $settings["close_button_delay"] = (isset($options["close_button_delay"]) && $options["close_button_delay"] != '') ? abs( intval($options["close_button_delay"]) ) : "0";

        //Animation Speed
        $settings["animation_speed"] = (isset($options["animation_speed"]) && $options["animation_speed"] != '') ? absint( intval($options["animation_speed"]) ) : 1;

        //Close Animation Speed
        $settings["close_animation_speed"] = (isset($options["close_animation_speed"]) && $options["close_animation_speed"] != '') ? absint( intval($options["close_animation_speed"]) ) : 1;
        
        //Close button text
        $settings["close_button_text"] = (isset($options['close_button_text']) && $options['close_button_text'] != '') ? stripslashes( esc_attr($options['close_button_text']) ) : '✕';

        // Close button hover text
        $settings["close_button_hover_text"] = (isset($options['close_button_hover_text']) && $options['close_button_hover_text'] != '') ? stripslashes( esc_attr($options['close_button_hover_text']) ) : '';

        // PopupBox container max-width for mobile
        if(isset($options['mobile_max_width']) && $options['mobile_max_width'] != ''){
            $settings["mobile_max_width"] = $options['mobile_max_width'] . '%';
        }else{
            $settings["mobile_max_width"] = '100%';
        }

        // PopupBox container width for mobile
        if(isset($options['mobile_width']) && $options['mobile_width'] != ''){
            $settings["mobile_width"] = $options['mobile_width'] . '%';
        }else{
           $settings["mobile_width"] = '100%';
        }



        //close popup by ESC
        $options["close_popup_esc"] = (isset($options['close_popup_esc']) && $options['close_popup_esc'] != '') ? $options['close_popup_esc'] : 'off';
        $settings["close_popup_esc"] = (isset($options['close_popup_esc']) && $options['close_popup_esc'] == 'on') ? true : false;

        //close popup my clicking outsite the box
        $options["close_popup_overlay"] = (isset($options['close_popup_overlay']) && $options['close_popup_overlay'] != '') ? $options['close_popup_overlay'] : 'off';
        $settings["close_popup_overlay"] = (isset($options['close_popup_overlay']) && $options['close_popup_overlay'] == 'on') ? true : false;

        //close popup my clicking outsite the box mobile
        $options["close_popup_overlay_mobile"] = (isset($options['close_popup_overlay_mobile']) && $options['close_popup_overlay_mobile'] == 'on') ? $options['close_popup_overlay_mobile'] : 'off';
        $settings["close_popup_overlay_mobile"] = (isset($options['close_popup_overlay_mobile']) && $options['close_popup_overlay_mobile'] == 'on') ? true : false;


        $settings['onoffoverlay'] = (isset($popupbox['onoffoverlay']) && $popupbox['onoffoverlay'] != '') ? strtolower( $popupbox['onoffoverlay'] ) : 'off';

        $settings['overlay_opacity'] = ($settings['onoffoverlay'] == 'on') && isset($popupbox['overlay_opacity']) ? stripslashes(sanitize_text_field($popupbox['overlay_opacity'])) : '0.5';

        //close popup by scroll
        $settings["close_pb_by_scroll_down"] = (isset($options['close_pb_by_scroll_down']) && $options['close_pb_by_scroll_down'] != '') ? intval($options['close_pb_by_scroll_down']) : 0;
        
        //close popup by classname
        $options["enable_close_by_classname"] = (isset($options['enable_close_by_classname']) && $options['enable_close_by_classname'] != '') ? $options['enable_close_by_classname'] : 'off';
        $settings["enable_close_by_classname"] = (isset($options['enable_close_by_classname']) && $options['enable_close_by_classname'] == 'on') ? true : false;
        $settings['close_by_classname_'.$id] = (isset($options['close_by_classname_'.$id]) && $options['close_by_classname_'.$id] != '') ? $options['close_by_classname_'.$id] : 'ays_close_pb_by_classname_'.$id;


        // PopupBox sound
        $options["enable_pb_sound"] = (isset($options['enable_pb_sound']) && $options['enable_pb_sound'] != '') ? $options['enable_pb_sound'] : 'off';
        $settings["enable_pb_sound"] = (isset($options['enable_pb_sound']) && $options['enable_pb_sound'] == 'on') ? true : false;

        //action on popup content
        $options["enable_content_click"] = (isset($options['enable_content_click']) && $options['enable_content_click'] != '') ? $options['enable_content_click'] : 'off';
        $settings["enable_content_click"] = (isset($options['enable_content_click']) && $options['enable_content_click'] == 'on') ? true : false;
        
        $options["enable_redirect_content_click"] = (isset($options['enable_redirect_content_click']) && $options['enable_redirect_content_click'] != '') ? $options['enable_redirect_content_click'] : 'off';
        $settings["enable_redirect_content_click"] = (isset($options['enable_redirect_content_click']) && $options['enable_redirect_content_click'] == 'on') ? true : false;

        $options["enable_close_content_click"] = (isset($options['enable_close_content_click']) && $options['enable_close_content_click'] != '') ? $options['enable_close_content_click'] : 'off';
        $settings["enable_close_content_click"] = (isset($options['enable_close_content_click']) && $options['enable_close_content_click'] == 'on') ? true : false;

        $options["enable_new_tab_content_click"] = (isset($options['enable_new_tab_content_click']) && $options['enable_new_tab_content_click'] != '') ? $options['enable_new_tab_content_click'] : 'off';
        $settings["enable_new_tab_content_click"] = (isset($options['enable_new_tab_content_click']) && $options['enable_new_tab_content_click'] == 'on') ? true : false;

        $settings["redirect_url_content_click"] = (isset($options['redirect_url_content_click']) && $options['redirect_url_content_click'] != '') ? $options['redirect_url_content_click'] : '';

        //title style
        $options["enable_title_styles"] = (isset($options['enable_title_styles']) && $options['enable_title_styles'] != '') ? $options['enable_title_styles'] : 'off';
        $settings["enable_title_styles"] = (isset($options['enable_title_styles']) && $options['enable_title_styles'] == 'on') ? true : false;
        $settings["title_font_family"] = (isset($options['title_font_family']) && $options['title_font_family'] != '') ? stripslashes( esc_attr($options['title_font_family']) ) : '';
        $settings["title_font_size"] = (isset($options['title_font_size']) && $options['title_font_size'] != '') ? absint(intval($options['title_font_size'])) : '';
        $settings["title_font_weight"] = (isset($options['title_font_weight']) && $options['title_font_weight'] != '') ? $options['title_font_weight'] : '';
        $settings["title_text_alignment"] = (isset($options['title_text_alignment']) && $options['title_text_alignment'] != '') ? stripslashes( esc_attr($options['title_text_alignment']) ) : '';
        $settings["title_text_transform"] = (isset($options['title_text_transform']) && $options['title_text_transform'] != '') ? stripslashes( esc_attr($options['title_text_transform']) ) : '';
        $settings["title_text_decoration"] = (isset($options['title_text_decoration']) && $options['title_text_decoration'] != '') ? stripslashes( esc_attr($options['title_text_decoration']) ) : '';
        $settings["title_line_height"] = (isset($options['title_line_height']) && $options['title_line_height'] != '') ? absint(intval($options['title_line_height'])) : '';
        $settings["title_letter_spacing"] = (isset($options['title_letter_spacing']) && $options['title_letter_spacing'] != '') ? absint(intval($options['title_letter_spacing'])) : '';

        //video url
        $settings["video_theme_url"] = (isset($options['video_theme_url']) && $options['video_theme_url'] != '') ? esc_url($options['video_theme_url']) : '';

        //hide timer
        $options["enable_hide_timer"] = (isset($options['enable_hide_timer']) && $options['enable_hide_timer'] != '') ? $options['enable_hide_timer'] : 'off';
        $settings["enable_hide_timer"] = (isset($options['enable_hide_timer']) && $options['enable_hide_timer'] == 'on') ? true : false;        

        //Close Button image
        $settings["close_button_image"] = (isset($options['close_button_image']) && $options['close_button_image'] != '') ? $options['close_button_image'] : '';
        
        //close button size 
        $settings['close_btn_size'] = (isset($options['close_button_size']) && $options['close_button_size'] != '') ? abs($options['close_button_size']) : '1';

        $settings['ays_pb_subs_email_placeholder'] = (isset($options['ays_pb_subs_email_placeholder']) && $options['ays_pb_subs_email_placeholder'] != '') ? $options['ays_pb_subs_email_placeholder'] : 'Email*';

        $settings['enable_ays_pb_subs_name_field'] = (isset($options['enable_ays_pb_subs_name_field']) && $options['enable_ays_pb_subs_name_field'] == 'on') ? true : false;

        $settings['ays_pb_subs_name_placeholder'] = (isset($options['ays_pb_subs_name_placeholder']) && $options['ays_pb_subs_name_placeholder'] != '') ? $options['ays_pb_subs_name_placeholder'] : 'Name';

        $settings['ays_pb_subs_name_required'] = (isset($options['ays_pb_subs_name_required']) && $options['ays_pb_subs_name_required'] == 'on') ? true : false;

        $settings['ays_pb_yes_or_no_question'] = (isset($options['ays_pb_yes_or_no_question']) && $options['ays_pb_yes_or_no_question'] != '') ? stripslashes( esc_attr($options['ays_pb_yes_or_no_question']) ) : 'Do you like our plugin?';

        $settings['ays_pb_yes_button_action'] = (isset($options['ays_pb_yes_button_action']) && $options['ays_pb_yes_button_action'] != '') ? stripslashes( esc_attr($options['ays_pb_yes_button_action']) ) : 'closePopup';

        $settings['ays_pb_no_button_action'] = (isset($options['ays_pb_no_button_action']) && $options['ays_pb_no_button_action'] != '') ? stripslashes( esc_attr($options['ays_pb_no_button_action']) ) : 'closePopup';

        $settings['ays_pb_yes_btn_redirect_url'] = (isset($options['ays_pb_yes_btn_redirect_url']) && $options['ays_pb_yes_btn_redirect_url'] != '') ? $options['ays_pb_yes_btn_redirect_url'] : '';

        $settings['ays_pb_no_btn_redirect_url'] = (isset($options['ays_pb_no_btn_redirect_url']) && $options['ays_pb_no_btn_redirect_url'] != '') ? $options['ays_pb_no_btn_redirect_url'] : '';

        $settings['yes_redirect_another_tab'] = (isset($options['yes_redirect_another_tab']) && $options['yes_redirect_another_tab'] == 'on') ? 'on' : 'off';

        $settings['no_redirect_another_tab'] = (isset($options['no_redirect_another_tab']) && $options['no_redirect_another_tab'] == 'on') ? 'on' : 'off';

        $settings['ays_pb_iframe_link'] = (isset($options['ays_pb_iframe_link']) && $options['ays_pb_iframe_link'] != '') ? $options['ays_pb_iframe_link'] : '';

        $settings['ays_pb_contact_admin_email'] = (isset($options['ays_pb_contact_admin_email']) && $options['ays_pb_contact_admin_email'] != '') ? $options['ays_pb_contact_admin_email'] : '';


        $settings['ays_pb_send_file_url'] = (isset($options['ays_popup_send_file_type']['ays_pb_send_file_url']) && $options['ays_popup_send_file_type']['ays_pb_send_file_url'] != '') ? $options['ays_popup_send_file_type']['ays_pb_send_file_url'] : '';

        $settings['ays_pb_send_file_id'] = (isset($options['ays_popup_send_file_type']['ays_pb_send_file_id']) && $options['ays_popup_send_file_type']['ays_pb_send_file_id'] != '') ? $options['ays_popup_send_file_type']['ays_pb_send_file_id'] : '';

        $settings['ays_pb_send_file_name'] = (isset($options['ays_popup_send_file_type']['ays_pb_send_file_name']) && $options['ays_popup_send_file_type']['ays_pb_send_file_name'] != '') ? $options['ays_popup_send_file_type']['ays_pb_send_file_name'] : '';

        $settings['ays_pb_send_file_content']  = (isset($options['ays_popup_send_file_type']['ays_pb_send_file_content']) && $options['ays_popup_send_file_type']['ays_pb_send_file_content'] != "") ? wpautop(stripslashes($options['ays_popup_send_file_type']['ays_pb_send_file_content'])) : "";
        
        $settings['ays_pb_down_file_url'] = (isset($options['ays_popup_down_file_type']['ays_pb_down_file_url']) && $options['ays_popup_down_file_type']['ays_pb_down_file_url'] != '') ? $options['ays_popup_down_file_type']['ays_pb_down_file_url'] : '';

        $settings['ays_pb_google_map_api_key']  = (isset($options['ays_pb_google_map_api_key']) && $options['ays_pb_google_map_api_key'] != "") ? $options['ays_pb_google_map_api_key'] : "";

        $settings['ays_pb_google_map_search']  = (isset($options['ays_pb_google_map_search']) && $options['ays_pb_google_map_search'] != "") ? $options['ays_pb_google_map_search'] : "";

        $settings['enable_limit_by_country'] = (isset($options['enable_limit_by_country']) && $options['enable_limit_by_country'] == 'on') ? true : false;

        $settings['limit_country'] = (isset($options['limit_country']) && $options['limit_country'] != '') ? explode('***', esc_attr($options['limit_country'])) : [];

        $settings['countries_choose_type']  = (isset($options['countries_choose_type']) && $options['countries_choose_type'] != "") ? $options['countries_choose_type'] : "exclude";
        
        //Coupons
        $settings['pb_coupons_array'] = (isset($options['pb_coupons_array']) && $options['pb_coupons_array'] != '') ? $options['pb_coupons_array'] : array();

        //WooCommerce Product
        $settings['woo_prod_sel'] = (isset($options['woo_prod_sel']) && $options['woo_prod_sel'] != '') ? $options['woo_prod_sel'] : "";

        $settings['ays_pb_countdown_date'] = (isset($options['ays_pb_countdown_date']) && $options['ays_pb_countdown_date'] != '') ? esc_attr($options['ays_pb_countdown_date']) : '';

        // Bg image positioning
        $settings['pb_bg_image_position'] = (isset($options['pb_bg_image_position']) && $options['pb_bg_image_position'] != '') ? str_ireplace( '-', ' ', $options['pb_bg_image_position'] ) : "center center";

        $settings['pb_bg_image_sizing'] = (isset($options['pb_bg_image_sizing']) && $options['pb_bg_image_sizing'] != '') ? $options['pb_bg_image_sizing'] : "cover";

        $settings['pb_min_height'] = (isset($options['pb_min_height']) && $options['pb_min_height'] != '') ? absint(intval($options['pb_min_height'])) : 0;

        // Font Size 
        $settings['pb_font_size'] = (isset($options['pb_font_size']) && $options['pb_font_size'] != '') ? absint($options['pb_font_size']) : 13;
        
        //Font Size for mobile
        $settings['pb_font_size_for_mobile'] = (isset($options['pb_font_size_for_mobile']) && $options['pb_font_size_for_mobile'] != '') ? absint($options['pb_font_size_for_mobile']) : 13;

        // Social Media links
        $settings['enable_social_links'] = (isset($options['enable_social_links']) && $options['enable_social_links'] == "on") ? true : false;
        $settings['social_links'] = (isset($options['social_links']) && !empty($options['social_links'])) ? $options['social_links'] : array(
            'linkedin_link'  => '',
            'facebook_link'  => '',
            'twitter_link'   => '',
            'vkontakte_link' => '',
            'youtube_link'   => '',
            'instagram_link' => '',
            'behance_link'   => '',
        );
        $settings['linkedin_link'] = isset($social_links['linkedin_link']) && $social_links['linkedin_link'] != '' ? esc_url($social_links['linkedin_link']) : '';
        $settings['facebook_link'] = isset($social_links['facebook_link']) && $social_links['facebook_link'] != '' ? esc_url($social_links['facebook_link']) : '';
        $settings['twitter_link'] = isset($social_links['twitter_link']) && $social_links['twitter_link'] != '' ? esc_url($social_links['twitter_link']) : '';
        $settings['vkontakte_link'] = isset($social_links['vkontakte_link']) && $social_links['vkontakte_link'] != '' ? esc_url($social_links['vkontakte_link']) : '';
        $settings['youtube_link'] = isset($social_links['youtube_link']) && $social_links['youtube_link'] != '' ? esc_url($social_links['youtube_link']) : '';
        $settings['instagram_link'] = isset($social_links['instagram_link']) && $social_links['instagram_link'] != '' ? esc_url($social_links['instagram_link']) : '';
        $settings['behance_link'] = isset($social_links['behance_link']) && $social_links['behance_link'] != '' ? esc_url($social_links['behance_link']) : '';

        // Heading for social buttons
        $settings['social_buttons_heading'] = (isset($options['social_buttons_heading']) && $options['social_buttons_heading'] != '') ? stripslashes( self::ays_autoembed( $options['social_buttons_heading']) ) : "";

        //Accept Cookie expire time 
        $settings['accept_cookie_expire_time'] = (isset($options['accept_cookie_expire_time']) && $options['accept_cookie_expire_time'] != '') ? absint($options['accept_cookie_expire_time']) : '';

        //Display post content by id
        $settings['display_post_content_by_id'] = ( isset( $options['display_post_content_by_id'] ) && $options['display_post_content_by_id'] != '' ) ? intval( $options['display_post_content_by_id'] ) : '';

        //Title text shadow start
        $options['enable_pb_title_text_shadow'] =(isset($options['enable_pb_title_text_shadow']) && $options['enable_pb_title_text_shadow'] == 'on') ? 'on' : 'off';
        $settings['enable_pb_title_text_shadow'] = (isset($options['enable_pb_title_text_shadow']) && $options['enable_pb_title_text_shadow'] == 'on') ? true : false; 

        $settings['pb_title_text_shadow'] = (isset($options['pb_title_text_shadow']) && $options['pb_title_text_shadow'] != '') ? stripslashes( esc_attr( $options['pb_title_text_shadow'] ) ) : 'rgba(255,255,255,0)';

        $settings['pb_title_text_shadow_x_offset'] = (isset($options['pb_title_text_shadow_x_offset']) && $options['pb_title_text_shadow_x_offset'] != '') ? stripslashes( esc_attr( $options['pb_title_text_shadow_x_offset'] ) ) : 2;

        $settings['pb_title_text_shadow_y_offset'] = (isset($options['pb_title_text_shadow_y_offset']) && $options['pb_title_text_shadow_y_offset'] != '') ? stripslashes( esc_attr( $options['pb_title_text_shadow_y_offset'] ) ) : 2;

        $settings['pb_title_text_shadow_z_offset'] = (isset($options['pb_title_text_shadow_z_offset']) && $options['pb_title_text_shadow_z_offset'] != '') ? stripslashes( esc_attr( $options['pb_title_text_shadow_z_offset'] ) ) : 0;
        //Title text shadow end

        // Confirmation box
        $options['ays_pb_sb_enable_conf_box'] =(isset($options['ays_pb_sb_enable_conf_box']) && $options['ays_pb_sb_enable_conf_box'] == 'on') ? 'on' : 'off';
        $settings['ays_pb_sb_enable_conf_box'] = (isset($options['ays_pb_sb_enable_conf_box']) && $options['ays_pb_sb_enable_conf_box'] == 'on') ? "true" : "false";

        //Scroll from top percentage to px
        $settings['popup_scroll_from_top_percentage_px'] = (isset( $options['popup_scroll_from_top_percentage_px'] ) && $options['popup_scroll_from_top_percentage_px'] != '' ) ? sanitize_text_field( $options['popup_scroll_from_top_percentage_px'] ) : 'pixels';

        // =========== Buttons Styles Start ===========

        // Buttons size
        $settings['buttons_size'] = (isset($options['buttons_size']) && $options['buttons_size'] != "") ? stripslashes( esc_attr($options['buttons_size']) ) : 'medium';

        // Buttons layout
        $settings["button_layout"] = (isset($options['button_layout']) && $options['button_layout'] != "") ? stripslashes( esc_attr($options['button_layout']) ) : 'row';

        // Buttons font size
        $settings['buttons_font_size'] = (isset($options['buttons_font_size']) && $options['buttons_font_size'] != "" && $options['buttons_font_size'] != 0) ? $options['buttons_font_size'] : '17';

        // Buttons width
        $settings['buttons_width'] = (isset($options['buttons_width']) && sanitize_text_field( $options['buttons_width'] ) != "") ? sanitize_text_field( $options['buttons_width'] ) : '';

        // Buttons Left / Right padding
        $settings['buttons_left_right_padding'] = (isset($options['buttons_left_right_padding']) && $options['buttons_left_right_padding'] != "") ? $options['buttons_left_right_padding'] : '20';

        // Buttons Top / Bottom padding
        $settings['buttons_top_bottom_padding'] = (isset($options['buttons_top_bottom_padding']) && $options['buttons_top_bottom_padding'] != "") ? $options['buttons_top_bottom_padding'] : '10';

        // Buttons padding
        $settings['buttons_border_radius'] = (isset($options['buttons_border_radius']) && $options['buttons_border_radius'] != "") ? $options['buttons_border_radius'] : '3';

        // Buttons text Color
        $settings['buttons_text_color'] = (isset($options['buttons_text_color']) && $options['buttons_text_color'] != "") ? sanitize_text_field( $options['buttons_text_color'] ) : '#fff';

        // Buttons BG Color
        $settings['buttons_bg_color'] = (isset($options['buttons_bg_color']) && $options['buttons_bg_color'] != "") ? sanitize_text_field( $options['buttons_bg_color'] ) : '#13aff0';

        $settings['buttons_bg_color_1'] = (isset($options['buttons_bg_color_1']) && $options['buttons_bg_color_1'] != "") ? sanitize_text_field( $options['buttons_bg_color_1'] ) : '#00AD00';
        $settings['buttons_bg_color_2'] = (isset($options['buttons_bg_color_2']) && $options['buttons_bg_color_2'] != "") ? sanitize_text_field( $options['buttons_bg_color_2'] ) : '#DE0000';

        // =========== Buttons Styles End ===========

        //Popup author
        $settings['author'] = (isset( $options['author'] ) && $options['author'] != '' ) ? $options['author']  : '';
       

        //Button Texts
        $settings['button_text'] = ( isset($options['button_text']) && $options['button_text'] != "" ) ? esc_attr(sanitize_text_field( $options['button_text'] )) : '';

        $settings['button_text_yes'] = ( isset($options['button_text_yes']) && $options['button_text_yes'] != "" ) ? esc_attr(sanitize_text_field( $options['button_text_yes'] )) : 'Yes';

        $settings['button_text_no']  = ( isset($options['button_text_no']) && $options['button_text_no'] != "" ) ? esc_attr(sanitize_text_field( $options['button_text_no'] )) : 'No';

        $settings['mobile_height'] = (isset($options['mobile_height']) && $options['mobile_height'] != "") ? absint($options['mobile_height']) : $popupbox["height"];

        //hide after subscribe
        $options["hide_after_subscribe"] = (isset($options['hide_after_subscribe']) && $options['hide_after_subscribe'] != '') ? $options['hide_after_subscribe'] : 'off';
        $settings["hide_after_subscribe"] = (isset($options['hide_after_subscribe']) && $options['hide_after_subscribe'] == 'on') ? true : false;

        // Change current pb creation date
        $settings['create_date'] = (isset($options['create_date']) && $options['create_date'] != '') ? $options['create_date'] : current_time( 'mysql' );

        //Enable dismiss
        $options['enable_redirect_after_subscription'] = (isset($options['enable_redirect_after_subscription']) && $options['enable_redirect_after_subscription'] == "on") ? "on" : "off";
        $settings['enable_redirect_after_subscription'] = (isset($options['enable_redirect_after_subscription']) && $options['enable_redirect_after_subscription'] == "on") ? true : false;
        
        $settings['enable_redirect_after_subscription_url'] = (isset($options['enable_redirect_after_subscription_url']) && $options['enable_redirect_after_subscription_url'] != "") ? $options['enable_redirect_after_subscription_url'] : '';

        //Enable dismiss
        $options['enable_dismiss'] = (isset($options['enable_dismiss']) && $options['enable_dismiss'] == "on") ? "on" : "off";
        $settings['enable_dismiss'] = (isset($options['enable_dismiss']) && $options['enable_dismiss'] == "on") ? true : false;
        
        $settings['enable_dismiss_text'] = (isset($options['enable_dismiss_text']) && $options['enable_dismiss_text'] != "") ? esc_html( stripslashes($options['enable_dismiss_text']) ) : 'Dismiss ad';

        // Box shadow
        $options['enable_box_shadow'] = (isset($options['enable_box_shadow']) && $options['enable_box_shadow'] == 'on') ? 'on' : 'off'; 
        $settings['enable_box_shadow']  = (isset($options['enable_box_shadow']) && $options['enable_box_shadow'] == 'on') ? true : false; 

        $settings['box_shadow_color'] = (isset($options['box_shadow_color']) && $options['box_shadow_color'] != '') ? stripslashes( esc_attr( $options['box_shadow_color'] ) ) : '#000';

        $settings['pb_box_shadow_x_offset'] = (isset($options['pb_box_shadow_x_offset']) && $options['pb_box_shadow_x_offset'] != '') ? stripslashes( esc_attr( $options['pb_box_shadow_x_offset'] ) ) : 2;

        $settings['pb_box_shadow_y_offset'] = (isset($options['pb_box_shadow_y_offset']) && $options['pb_box_shadow_y_offset'] != '') ? stripslashes( esc_attr( $options['pb_box_shadow_y_offset'] ) ) : 2;

        $settings['pb_box_shadow_z_offset'] = (isset($options['pb_box_shadow_z_offset']) && $options['pb_box_shadow_z_offset'] != '') ? stripslashes( esc_attr( $options['pb_box_shadow_z_offset'] ) ) : 15;

        //Border Style 
        $settings['border_style'] = ( isset ( $options['border_style'] ) && $options['border_style'] != '' ) ? stripslashes( esc_attr($options['border_style']) ) : 'solid';

        //Disabel scroll on popup
        $options['disable_scroll_on_popup'] = ( isset( $options['disable_scroll_on_popup'] ) && $options['disable_scroll_on_popup'] != '' ) ? $options['disable_scroll_on_popup'] : 'off';
        $settings['disable_scroll_on_popup'] = ( isset( $options['disable_scroll_on_popup'] ) && $options['disable_scroll_on_popup'] == 'on' ) ? true : false;

        //Show scrollbar
        $options['show_scrollbar'] = ( isset( $options['show_scrollbar'] ) && $options['show_scrollbar'] != '' ) ? $options['show_scrollbar'] : 'off';
        $settings['show_scrollbar'] = ( isset( $options['show_scrollbar'] ) && $options['show_scrollbar'] == 'on' ) ? true : false;
        
        //Background image position for mobile
        $options['pb_bg_image_direction_on_mobile'] = ( isset( $options['pb_bg_image_direction_on_mobile'] ) && $options['pb_bg_image_direction_on_mobile'] == "on" ) ? $options['pb_bg_image_direction_on_mobile'] : "off";
        $settings['pb_bg_image_direction_on_mobile'] = ( isset( $options['pb_bg_image_direction_on_mobile'] ) && $options['pb_bg_image_direction_on_mobile'] == "on" ) ? true : false;

        $settings['close_button_color'] = (isset($options['close_button_color']) && $options['close_button_color'] != "") ? esc_attr( stripslashes( $options['close_button_color'])) : $settings["textcolor"];

        $settings['close_button_hover_color'] = (isset($options['close_button_hover_color']) && $options['close_button_hover_color'] != "") ? esc_attr( stripslashes( $options['close_button_hover_color'])) : $settings['close_button_color'];

        // Inactivity seconds 
        $settings['inactivty_seconds'] = (isset($options['inactivty_seconds']) && $options['inactivty_seconds'] != "") ? esc_attr( intval( $options['inactivty_seconds'] )) : 5;
        
        //x page visiting
        $settings['show_popup_x_page_visiting'] = (isset($options['show_popup_x_page_visiting']) && $options['show_popup_x_page_visiting'] != "") ? esc_attr( intval( $options['show_popup_x_page_visiting'] )) : 3;

        //Scrolling to element
        $settings['scrolling_to_element'] = (isset($options['scrolling_to_element']) && $options['scrolling_to_element'] != "") ? esc_attr( stripslashes( $options['scrolling_to_element'] )) : '';

        //Blured overlay
        $options['blured_overlay'] = ( isset( $options['blured_overlay'] ) && $options['blured_overlay'] == "on" ) ? $options['blured_overlay'] : "off";
        $settings['blured_overlay'] = ( isset( $options['blured_overlay'] ) && $options['blured_overlay'] == "on" ) ? true : false;

        return $settings;
    }

    public static function sort_array_keys_by_array($array, $orderArray) {
        $ordered = array();
        foreach ($orderArray as $key) {
            if (array_key_exists('ays-question-'.$key, $array)) {
                $ordered['ays-question-'.$key] = $array['ays-question-'.$key];
                unset($array['ays-question-'.$key]);
            }
        }
        return $ordered + $array;
    }

    public static function replace_message_variables($content, $data){
        foreach($data as $variable => $value){
            $content = str_replace("%%".$variable."%%", $value, $content);
        }
        return $content;
    }

    public static function hex2rgba($color, $opacity = false){

        $default = 'rgb(0,0,0)';

        //Return default if no color provided
        if (empty($color))
            return $default;

        //Sanitize $color if "#" is provided
        if ($color[0] == '#') {
            $color = substr($color, 1);
        }else{
            return $color;
        }

        //Check if color has 6 or 3 characters and get values
        if (strlen($color) == 6) {
            $hex = array($color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5]);
        } elseif (strlen($color) == 3) {
            $hex = array($color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2]);
        } else {
            return $default;
        }

        //Convert hexadec to rgb
        $rgb = array_map('hexdec', $hex);

        //Check if opacity is set(rgba or rgb)
        if ($opacity) {
            if (abs($opacity) > 1)
                $opacity = 1.0;
            $output = 'rgba(' . implode(",", $rgb) . ',' . $opacity . ')';
        } else {
            $output = 'rgb(' . implode(",", $rgb) . ')';
        }

        //Return rgb(a) color string
        return $output;
    }

    public static function secondsToWords($seconds){
        $ret = "";

        /*** get the days ***/
        $days = intval(intval($seconds) / (3600 * 24));
        if ($days > 0) {
            $ret .= "$days days ";
        }

        /*** get the hours ***/
        $hours = (intval($seconds) / 3600) % 24;
        if ($hours > 0) {
            $ret .= "$hours hours ";
        }

        /*** get the minutes ***/
        $minutes = (intval($seconds) / 60) % 60;
        if ($minutes > 0) {
            $ret .= "$minutes minutes ";
        }

        /*** get the seconds ***/
        $seconds = intval($seconds) % 60;
        if ($seconds > 0) {
            $ret .= "$seconds seconds";
        }

        return $ret;
    }

    public static function get_user_ip(){
        $ipaddress = '';
        if (getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        elseif (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if (getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if (getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if (getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if (getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else
            $ipaddress = 'UNKNOWN';
        return $ipaddress;
    }

    public static function get_time_difference($strStart, $strEnd){
        $dteStart = new DateTime($strStart);
        $dteEnd = new DateTime($strEnd);
        $texts = array(
            'year' => __( "year", AYS_QUIZ_NAME ),
            'years' => __( "years", AYS_QUIZ_NAME ),
            'month' => __( "month", AYS_QUIZ_NAME ),
            'months' => __( "months", AYS_QUIZ_NAME ),
            'day' => __( "day", AYS_QUIZ_NAME ),
            'days' => __( "days", AYS_QUIZ_NAME ),
            'hour' => __( "hour", AYS_QUIZ_NAME ),
            'hours' => __( "hours", AYS_QUIZ_NAME ),
            'minute' => __( "minute", AYS_QUIZ_NAME ),
            'minutes' => __( "minutes", AYS_QUIZ_NAME ),
            'second' => __( "second", AYS_QUIZ_NAME ),
            'seconds' => __( "seconds", AYS_QUIZ_NAME ),
        );
        $interval = $dteStart->diff($dteEnd);
        $return = '';

        if ($v = $interval->y >= 1) $return .= $interval->y ." ". $texts[self::pluralize_new($interval->y, 'year')] . ' ';
        if ($v = $interval->m >= 1) $return .= $interval->m ." ". $texts[self::pluralize_new($interval->m, 'month')] . ' ';
        if ($v = $interval->d >= 1) $return .= $interval->d ." ". $texts[self::pluralize_new($interval->d, 'day')] . ' ';
        if ($v = $interval->h >= 1) $return .= $interval->h ." ". $texts[self::pluralize_new($interval->h, 'hour')] . ' ';
        if ($v = $interval->i >= 1) $return .= $interval->i ." ". $texts[self::pluralize_new($interval->i, 'minute')] . ' ';

        $return .= $interval->s ." ". $texts[self::pluralize_new($interval->s, 'second')];

        return $return;
    }

    public static function pluralize($count, $text){
        return $count . (($count == 1) ? (" $text") : (" {$text}s"));
    }

    public static function pluralize_new($count, $text){
        return ($count == 1) ? $text."" : $text."s";
    }

    public static function ays_autoembed( $content ) {
        global $wp_embed;
        $content = stripslashes( wpautop( $content ) );
        $content = $wp_embed->autoembed( $content );
        if ( strpos( $content, '[embed]' ) !== false ) {
            $content = $wp_embed->run_shortcode( $content );
        }
        $content = do_shortcode( $content );
        return $content;
    }

    public static function ays_pb_get_OS($users_os) { 

        $user_agent   = $_SERVER['HTTP_USER_AGENT'];
        $os_platform  = "Unknown OS Platform";

        $os_array     = array(
            '/windows nt 10/i'      =>  __('Windows 10', AYS_PB_NAME),
            '/windows nt 6.3/i'     =>  __('Windows 8.1', AYS_PB_NAME),
            '/windows nt 6.2/i'     =>  __('Windows 8', AYS_PB_NAME),
            '/windows nt 6.1/i'     =>  __('Windows 7', AYS_PB_NAME),
            '/windows nt 6.0/i'     =>  __('Windows Vista', AYS_PB_NAME),
            '/windows nt 5.2/i'     =>  __('Windows Server 2003/XP x64', AYS_PB_NAME),
            '/windows nt 5.1/i'     =>  __('Windows XP (NT 5.1)', AYS_PB_NAME),
            '/windows xp/i'         =>  __('Windows XP', AYS_PB_NAME),
            '/windows nt 5.0/i'     =>  __('Windows 2000', AYS_PB_NAME),
            '/windows me/i'         =>  __('Windows ME', AYS_PB_NAME),
            '/win98/i'              =>  __('Windows 98', AYS_PB_NAME),
            '/win95/i'              =>  __('Windows 95', AYS_PB_NAME),
            '/win16/i'              =>  __('Windows 3.11', AYS_PB_NAME),
            '/macintosh|mac os x/i' =>  __('Mac OS X', AYS_PB_NAME),
            '/mac_powerpc/i'        =>  __('Mac OS 9', AYS_PB_NAME),
            '/linux/i'              =>  __('Linux', AYS_PB_NAME),
            '/ubuntu/i'             =>  __('Ubuntu', AYS_PB_NAME),
            '/iphone/i'             =>  __('iPhone', AYS_PB_NAME),
            '/ipod/i'               =>  __('iPod', AYS_PB_NAME),
            '/ipad/i'               =>  __('iPad', AYS_PB_NAME),
            '/android/i'            =>  __('Android', AYS_PB_NAME),
            '/blackberry/i'         =>  __('BlackBerry', AYS_PB_NAME)
        );

        foreach ($os_array as $regex => $value){
            if (preg_match($regex, $user_agent)){
                $os_platform = $value;
            }
        }
        $show_popup = false;
        if($os_platform !== 'Unknown OS Platform' && $users_os != ''){
            if(in_array($os_platform, $users_os)){
                $show_popup = true;
            }else{
                $show_popup = false;
            }
        }

        return $show_popup;
    }

    public static function ays_pb_get_browser($users_browser) {

        $user_agent  = $_SERVER['HTTP_USER_AGENT'];
        $browser     = "Unknown Browser";

        $browser_array = array(
            '/msie|trident/i' => __('Internet Explorer', AYS_PB_NAME),
            '/firefox/i'      => __('Firefox', AYS_PB_NAME),
            '/safari/i'       => __('Safari', AYS_PB_NAME),
            '/chrome/i'       => __('Chrome', AYS_PB_NAME),
            '/edg/i'          => __('Edge', AYS_PB_NAME),
            '/opera|OPR/i'    => __('Opera', AYS_PB_NAME),
            '/netscape/i'     => __('Netscape', AYS_PB_NAME),
            '/maxthon/i'      => __('Maxthon', AYS_PB_NAME),
            '/konqueror/i'    => __('Konqueror', AYS_PB_NAME),
            '/mobile/i'       => __('Handheld Browser', AYS_PB_NAME)
        );

        foreach ($browser_array as $regex => $value){
            if (preg_match($regex, $user_agent)){
                $browser = $value;
            }
        }

        $show_popup = false;
        if($browser !== 'Unknown Browser' && $users_browser != ''){
            if(in_array($browser, $users_browser)){
                $show_popup = true;
            }else{
                $show_popup = false;
            }
        }

        return $show_popup;
    }

    public static function get_pb_count_by_id($id){
        global $wpdb;
      
        $sql = "SELECT COUNT(pb_id) AS pb_count FROM {$wpdb->prefix}ays_pb_reports  WHERE `pb_id`=".$id;
        $result = $wpdb->get_var($sql);

        return $result;
    }

    public static function array_split($array, $pieces) {
        if ($pieces < 2)
            return array($array);
        $newCount = ceil(count($array)/$pieces);
        $a = array_slice($array, 0, $newCount);
        $b = self::array_split(array_slice($array, $newCount), $pieces-1);
        return array_merge(array($a),$b);
    }

    public static function get_max_id() {
        global $wpdb;
        $pb_table = $wpdb->prefix."ays_pb";

        $sql = "SELECT max(id) FROM {$pb_table}";

        $result = $wpdb->get_var($sql);

        return $result;
    }

    public static function get_pb_by_id( $id ){
        global $wpdb;

        $sql = "SELECT * FROM {$wpdb->prefix}ays_pb WHERE id=" . absint( intval( $id ) );

        $result = $wpdb->get_row($sql, "ARRAY_A");

        return $result;
    }

    public static function get_popups(){
        global $wpdb;
        $popups_table = esc_sql( $wpdb->prefix . 'ays_pb' );

        $sql = "SELECT id,title
                FROM {$popups_table}";

        $popups = $wpdb->get_results( $sql , "ARRAY_A" );

        return $popups;
    }

    public static function ays_pb_detect_mobile_device(){
        $useragent = $_SERVER['HTTP_USER_AGENT'];
        $flag      = false;
        if(preg_match('/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i',$useragent)||preg_match('/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i',substr($useragent,0,4))){
            $flag = true;
        }
        return $flag;
    }

    public static function ays_pb_detect_tablet_device(){
        $flag = false;
        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $flag = true;
        }

        return $flag;
    }

    
    public static function insertBeforeKey($array, $key, $data = null){
        if (($offset = array_search($key, array_keys($array))) === false) // if the key doesn't exist
        {
            $offset = 0; // should we prepend $array with $data?
            $offset = count($array); // or should we append $array with $data? lets pick this one...
        }

        return array_merge(array_slice($array, 0, $offset), (array) $data, array_slice($array, $offset));
    }
    
    public static function insertAfterKey($array, $key, $data = null){
        if (($offset = array_search($key, array_keys($array))) === false) // if the key doesn't exist
        {
            $offset = 0; // should we prepend $array with $data?
            $offset = count($array); // or should we append $array with $data? lets pick this one...
        }

        return array_merge(array_slice($array, 0, $offset+1), (array) $data, array_slice($array, $offset+1));
    }
    
    public static function ays_pb_templates_before_container( $popupbox ){
        $popupbox_view = "<style>";
        
        if( $popupbox['enable_title_styles'] ){
            $popupbox_view .= ".ays-pb-modal_".$popupbox['id']." h2.ays_pb_title {
                font-size: ". $popupbox['font_size_str'] .";
                font-family: ". $popupbox['font_family_str'] ." !important;
                font-weight: ". $popupbox['font_weight_str'] ." ;
                text-align: ". $popupbox['text_alignment_str'] ." !important;
                text-transform: ". $popupbox['text_transform_str'] .";
                text-decoration: ". $popupbox['text_decoration_str'] .";
                line-height: ". $popupbox['line_height_str'] .";
                letter-spacing: ". $popupbox['letter_spacing_str'] .";
            }";
        }

        if($popupbox['enable_pb_title_text_shadow']){
            $popupbox_view .= ".ays-pb-modal_".$popupbox['id']." h2.ays_pb_title {"
                .$popupbox['title_text_shadow']. ";
            }";
        }

        $templates_arr = array(
            "template",
            "frozen",
            "holiday",
            "food",
            "forest",
        );

        $bgImageStyletoAppend = '';
        if ( isset( $popupbox["view_type"] ) && in_array($popupbox["view_type"], $templates_arr) ) {
            $popupbox['bg_image_final'] = "";
        } elseif( isset( $popupbox["lazy_loading_attr"] ) && $popupbox["lazy_loading_attr"] != '') {
            if ($popupbox['bg_image_final'] != '') {
                $bgImageStyletoAppend = ".ays-pb-modal_".$popupbox['id']." {
                    ". $popupbox['bg_image_final'] .";
                }";
            }
            $popupbox['bg_image_final'] = "";
        }

        $popupbox_view .= ".ays-pb-modal_".$popupbox['id']." {
                ". $popupbox['bg_image_final'] .";
                width: ". $popupbox['width'] .";
                height: ". $popupbox['height'] .";
                background-color: ". $popupbox['bgcolor'] ." !important;
                color: ". $popupbox['textcolor'] ." !important;
                border: ". $popupbox['bordersize'] ."px " .$popupbox['border_style']. " ". $popupbox['bordercolor'] ." !important;
                border-radius: ". $popupbox['border_radius'] ."px !important;
                font-family: ". $popupbox['pb_font_family'] .";
            }
        </style>";

        if (isset( $popupbox["lazy_loading_attr"] ) && $popupbox["lazy_loading_attr"] != '' && $bgImageStyletoAppend != '') {
            $popupbox_view .= "<script>
                                (function($) {
                                    'use strict';
                                    $(document).ready(function() {
                                        var styleTag = $('<style>');
                                        styleTag.text(`" . $bgImageStyletoAppend . "`);
                                        $('head').append(styleTag);
                                    });
                                })(jQuery);
                               </script>";
        }

        return $popupbox_view;
    }

    public static function ays_version_compare($version1, $operator, $version2) {

        $_fv = intval ( trim ( str_replace ( '.', '', $version1 ) ) );
        $_sv = intval ( trim ( str_replace ( '.', '', $version2 ) ) );

        if (strlen ( $_fv ) > strlen ( $_sv )) {
            $_sv = str_pad ( $_sv, strlen ( $_fv ), 0 );
        }

        if (strlen ( $_fv ) < strlen ( $_sv )) {
            $_fv = str_pad ( $_fv, strlen ( $_sv ), 0 );
        }

        return version_compare ( ( string ) $_fv, ( string ) $_sv, $operator );
    }

    public static function validateDate($date, $format = 'Y-m-d H:i:s'){
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    public static function get_setting_data( $meta_key = 'options' ){
        global $wpdb;

        $settings_table = $wpdb->prefix . "ays_pb_settings";
        $sql = "SELECT meta_value FROM " . $settings_table . " WHERE meta_key = '". esc_sql( $meta_key ) ."'";
        $result = $wpdb->get_var($sql);

        $options = ($result == "") ? array() : json_decode($result, true);

        return $options;
    }

    public static function popup_box_capabilities_for_editing(){
        global $wpdb;
        $options = self::get_setting_data();
        
        $capability = false;

        // User roles to change survey
        $ays_user_roles = (isset($options['user_roles_to_change_survey']) && !empty( $options['user_roles_to_change_survey'] ) ) ? $options['user_roles_to_change_survey'] : array('administrator');
        if(is_user_logged_in()){
            $current_user = wp_get_current_user();
            $current_user_roles = $current_user->roles;
            $ishmar = 0;
            foreach($current_user_roles as $r){
                if(in_array($r, $ays_user_roles)){
                    $ishmar++;
                }
            }
            if($ishmar > 0){
                $capability = true;
            }
        }
        
        return $capability;
    }

    public static function get_user_profile_data(){

        $user_first_name = '';
        $user_last_name  = '';
        $user_nickname   = '';
        $user_wordpress_roles = '';

        $user_id = get_current_user_id();
        if($user_id != 0){
            $usermeta = get_user_meta( $user_id );
            if($usermeta !== null){
                $user_first_name = (isset($usermeta['first_name'][0]) && $usermeta['first_name'][0] != '' ) ? sanitize_text_field( $usermeta['first_name'][0] ) : '';
                $user_last_name  = (isset($usermeta['last_name'][0]) && $usermeta['last_name'][0] != '' ) ? sanitize_text_field( $usermeta['last_name'][0] ) : '';
                $user_nickname   = (isset($usermeta['nickname'][0]) &&  $usermeta['nickname'][0] != '' ) ? sanitize_text_field( $usermeta['nickname'][0] ) : '';
            }
        }

        $current_user_data = get_userdata( $user_id );
        if ( ! is_null( $current_user_data ) && $current_user_data ) {
            $user_display_name    = ( isset( $current_user_data->data->display_name ) && $current_user_data->data->display_name != '' ) ? sanitize_text_field( $current_user_data->data->display_name ) : "";
            $user_wordpress_email = ( isset( $current_user_data->data->user_email ) && $current_user_data->data->user_email != '' ) ? sanitize_text_field( $current_user_data->data->user_email ) : "";

            $user_wordpress_roles = ( isset( $current_user_data->roles ) && ! empty( $current_user_data->roles ) ) ? $current_user_data->roles : "";

            if ( !empty( $user_wordpress_roles ) && $user_wordpress_roles != "" ) {
                if ( is_array( $user_wordpress_roles ) ) {
                    $user_wordpress_roles = implode(",", $user_wordpress_roles);
                }
            }
        }

        $message_data = array(
            'user_first_name'       => $user_first_name,
            'user_last_name'        => $user_last_name,
            'user_nickname'         => $user_nickname,
            'user_wordpress_roles'  => $user_wordpress_roles,
        );
        
        return $message_data;
    }

    public static function get_pb_options_by_id( $id ){
        global $wpdb;
        $ays_pb_table = $wpdb->prefix .'ays_pb';

        $options = '';
        if($id != null){
            $sql = "SELECT options FROM {$ays_pb_table} WHERE id =".$id;
            $results = $wpdb->get_row( $sql, 'ARRAY_A' );

            $options = ( json_decode($results['options'], true) != null ) ? json_decode($results['options'], true) : array();
        }

        return $options;
    }

    public static function get_category_by_id($id){
        global $wpdb;

        $ays_pb_category_table = $wpdb->prefix .'ays_pb_categories';

        $results = '';
        if($id != null){
            $sql = "SELECT * FROM {$ays_pb_category_table} WHERE id =".$id;
            $results = $wpdb->get_row( $sql, 'ARRAY_A' );
        }

        return $results;
    }

    public static function get_all_attributes(){
        global $wpdb;

        $ays_pb_attributes_table = esc_sql( $wpdb->prefix .'ays_pb_attributes' );

        $sql = "SELECT * FROM {$ays_pb_attributes_table}";
        $result = $wpdb->get_results($sql,'ARRAY_A');
        $attributes_arr = array();
        foreach($result as $key => $value){
            $attributes_arr[$value['slug']] = array(
                'id'        => $value['id'],
                'slug'      => $value['slug'],
                'name'      => $value['name'],
                'type'      => $value['type'],
                'enabled'   => 'off',
                'required'  => 'off',
                'options'   => $value['options']
            );
        }
        return $attributes_arr;
    }

    public static function get_subscribe_by_id( $id ){
        global $wpdb;

        $ays_pb_subscribes_table = esc_sql( $wpdb->prefix .'ays_pb_subscribes' );

        $sql = "SELECT * FROM {$ays_pb_subscribes_table} WHERE id=" .$id ;

        $result = $wpdb->get_row($sql, 'ARRAY_A');

        return $result;
    }

    public static function ays_pb_get_social_links_html( $popupbox ){
        // Social Media links
        $enable_social_links = (isset($popupbox['enable_social_links']) && $popupbox['enable_social_links'] == "on") ? true : false;

        $ays_social_links_array = array();
        
        if(! empty($popupbox['social_links']) ){
            $social_link_arr = (array)$popupbox['social_links'];
        }else{
            $social_link_arr = $popupbox['social_links'];
        }

        $linkedin_link = isset($social_link_arr['linkedin_link']) && $social_link_arr['linkedin_link'] != '' ? $social_link_arr['linkedin_link'] : '';
        $facebook_link = isset($social_link_arr['facebook_link']) && $social_link_arr['facebook_link'] != '' ? $social_link_arr['facebook_link'] : '';
        $twitter_link = isset($social_link_arr['twitter_link']) && $social_link_arr['twitter_link'] != '' ? $social_link_arr['twitter_link'] : '';
        $vkontakte_link = isset($social_link_arr['vkontakte_link']) && $social_link_arr['vkontakte_link'] != '' ? $social_link_arr['vkontakte_link'] : '';

        $youtube_link = isset($social_link_arr['youtube_link']) && $social_link_arr['youtube_link'] != '' ? $social_link_arr['youtube_link'] : '';

        $instagram_link = isset($social_link_arr['instagram_link']) && $social_link_arr['instagram_link'] != '' ? $social_link_arr['instagram_link'] : '';

        $behance_link = isset($social_link_arr['behance_link']) && $social_link_arr['behance_link'] != '' ? $social_link_arr['behance_link'] : '';

        if($linkedin_link != ''){
            $ays_social_links_array['Linkedin']['link'] = $linkedin_link;
            $ays_social_links_array['Linkedin']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/linkedin.svg">';
        }
        if($facebook_link != ''){
            $ays_social_links_array['Facebook']['link'] = $facebook_link;
            $ays_social_links_array['Facebook']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/facebook.svg">';
        }
        if($twitter_link != ''){
            $ays_social_links_array['Twitter']['link'] = $twitter_link;
            $ays_social_links_array['Twitter']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/twitter.svg">';
        }
        if($vkontakte_link != ''){
            $ays_social_links_array['VKontakte']['link'] = $vkontakte_link;
            $ays_social_links_array['VKontakte']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/vk.svg">';
        }
        if($youtube_link != ''){
            $ays_social_links_array['Youtube']['link'] = $youtube_link;
            $ays_social_links_array['Youtube']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/youtube.svg">';
        }
        if($instagram_link != ''){
            $ays_social_links_array['Instagram']['link'] = $instagram_link;
            $ays_social_links_array['Instagram']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/instagram.svg">';
        }
        if($behance_link != ''){
            $ays_social_links_array['Behance']['link'] = $behance_link;
            $ays_social_links_array['Behance']['img'] = '<img src="'.AYS_PB_PUBLIC_URL.'/images/icons/behance.svg">';
        }
        
        $ays_social_links = '';
        if($enable_social_links){
            $ays_social_links .= "<div class='ays-pb-social-buttons-content'>";
                $ays_social_links .= "<div class='ays-pb-social-buttons-heading'>".$popupbox['social_buttons_heading']."</div>";
                $ays_social_links .= "<div class='ays-pb-social-shares'>";
                    foreach($ays_social_links_array as $media => $link){
                        $ays_social_links .= "<!-- Branded " . $media . " button -->
                            <a  href='" . $link['link'] . "'
                                target='_blank'
                                title='" . $media . " link'>
                                <div class='ays-pb-share-btn-icon'>".$link['img']."</div>
                            </a>";
                    }
                $ays_social_links .= "</div>";
            $ays_social_links .= "</div>";
        }

        return $ays_social_links;
    }

    public static function get_subscribes_count_by_popup_id( $id ){
        global $wpdb;

        $ays_pb_subscribes_table = esc_sql( $wpdb->prefix .'ays_pb_subscribes' );

        $sql = "SELECT COUNT(*) FROM {$ays_pb_subscribes_table} WHERE pb_id=" .$id ;

        $result = $wpdb->get_var($sql);

        return $result;
    }

    public static function string_starts_with_number($string){
        $match = preg_match('/^\d/', $string);
        if($match === 1){
            return true;
        }else{
            return false;
        }
    }
    
}
